/***
*       GASystem
*       Mike Morrow
*       September 1989
***/




/**
*                       Hash table routines.
**/

#include "table.h"

#define HASH_TAB_LEN 31



typedef TBLENT *HASHTABLE[HASH_TAB_LEN];


/***
*	Declare the table.
**/
static HASHTABLE the_table;


static unsigned int hash();

extern void *calloc();


/* initialize the hash table by having all pointers set to NULL */
void tbl_init()
{
        unsigned int i;
        TBL_PTR *p;

        for (i=0, p = the_table; i<HASH_TAB_LEN; i++, p++)
			*p = (TBL_PTR)0;
}


/**
*	Insert a copy of the record rec_dat into the table.
**/

TBL_PTR tbl_ins(rec_dat)
TBL_PTR rec_dat;
{
        register TBL_PTR new_rec;
        register unsigned int index;

        new_rec = (TBL_PTR)calloc(1, sizeof(TBLENT));
        if(! new_rec)
			return new_rec;

        *new_rec = *rec_dat;

        index = hash(new_rec->key);
        new_rec->link = the_table[index];
        the_table[index] = new_rec;
        return new_rec;
}

/**
*	find the record whose key is target.
**/
TBL_PTR tbl_find(target)
char *target;
{
        register TBL_PTR rec_ptr;


        for(rec_ptr = the_table[hash(target)];
			rec_ptr && strcmp(target, rec_ptr->key);
            rec_ptr = rec_ptr->link)
			{
				/* empty */
			}

        return rec_ptr;
}



static unsigned int hash(key)
char *key;
{
   register unsigned int sum;
   register char *ptr;

   sum = 1;
   for(ptr = key; *ptr; ptr++)
   {
           sum <<= 1;
           sum ^= *ptr;
   }

   return sum % HASH_TAB_LEN;
}

