/***
*       GASystem
*       Mike Morrow
*       September 1989
***/


#ifndef TABLE_H


typedef struct TBL_ENTRY
{
        char *key;
        struct TBL_ENTRY *link;
		
#define	SYMVAR	1
#define SYMCMD	2
		char symtype;
		
		void *symdata;			/* pointer to storage */
		
		
#define MODEINT		1			/* int */
#define MODEDOUBLE	2			/* double fp */
#define MODEFIT		3			/* fitness value */
		char symmode;
		
		
#define FLAG_RO		1			/* read only variable (user can't set) */
#define FLAG_INIT	2			/* re-init population when variable is set */
		char symflags;
} TBLENT;



typedef TBLENT *TBL_PTR;

#if __STDC__
extern void tbl_init();
extern TBL_PTR tbl_ins(TBL_PTR), tbl_find(char *);
#else
extern void tbl_init();
extern TBL_PTR tbl_ins(), tbl_find();
#endif

#define TABLE_H 1

#endif /* #ifndef TABLE_H */


