/*   CIRRUS.H--    Header file for cirrus cloud template
	 This (and the other header files like it) can be used to define
     the initial fractal template for the SIERP.C and FRACDRAW.C programs
     In this and the other cloud models (STRATUS and CUMULUS), the air
     currents which control cloud formation are modelled as arrows.
     When those forces are reflected throughout all levels of scale,
     a realistic image of the cloud type that results from those air
     currents appears.  Cirrus clouds are characterized by high-altitude
     rising cross winds, stratus clouds by slow horizontal air flow,
     and cumulus clouds by warm air rising from the ground.
*/

#define NPOINTS 7    /* Number of points on the "parent" polygon */
#define NTRANS  6    /* Number of transformed "children" */
#define NLEVELS 5    /* Number of levels to draw */
#define COUNT 10000  /* Number of dots to paint */
#define CENTERX 180  /* Center of the screen */
#define CENTERY 240
#define SEEDX 16,-27,-42,-7,-27,54,23  /* The "parent" polygon */
#define SEEDY  33,52,36,-7,-13,-43,36

/* The tranformations which define the "children" */
#define MOVEX 143.4,-90,5,-4  /* Displacement */
#define MOVEY 11.08,13.6,-15.5,45
#define SIZEX   .75,.43,.38,.75    /* Size change */
#define SIZEY   .45,.47,.44,.21
#define SPINX   6.07,0.05,0.02,0.0    /* Rotation */
#define SPINY   6.07,0.05,0.02,6.28

/* The following color definitions are ignored by the SIERP program
   and used only by FRACDRAW.
   PALETTE defines the 16-color VGA palette
   COLOR intializes a two-dimensional array with color values:
   each column in the array definition below corresponds to one level
   of detail, and each row corresponds to a "part", or transformation.
   Note that the array only needs to be 6 by 3 for the template defined
   above, but more rows are included in case the user inserts additional
   "parts".
*/
#define PALETTE {_BLACK, _RED, _GREEN, _CYAN, \
		 _BLUE, _MAGENTA, _BROWN, _WHITE, \
		 _GRAY, _LIGHTBLUE, _LIGHTGREEN, _LIGHTCYAN, \
		 _LIGHTRED, _LIGHTMAGENTA, _LIGHTYELLOW, _BRIGHTWHITE}

#define COLOR {{15,15,15, 7, 8},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15},\
               {15,15,15,15,15}}
