/******* FILE DDJ_32C.C, FOR USE ON DSP BOARD WITH AT&T 'C' ****/

#include <stdio.h>
#include <math.h>
#include <nr.h>

#define PI 3.1415926
#define SQR(a) ((a)*(a))

asm(".global i1, i2, o1, o2");
asm(".global funcnum, bs");
asm(".global amp, dco, freq, samprate");

short funcnum;
short bs;

float *i1, *i2, *o1, *o2;
float amp, dco, freq, samprate;

short fft_stages(fft_size)
short fft_size;
{
   short rtn;

   switch(fft_size)
   {
      case 32  : rtn = 5; break;
      case 64  : rtn = 6; break;
      case 128 : rtn = 7; break;
      case 256 : rtn = 8; break;
      case 512 : rtn = 9; break;
      case 1024 : rtn = 10; break;
      case 2048 : rtn = 11; break;
      case 4096 : rtn = 12; break;
      case 8192 : rtn = 13; break;
      default  : rtn = 0; break;
   }
   return(rtn);
}

main()
{
     register float scal;
     short n;
     float *data1, *data2, temp;
     register short i,j;

     while (1) {
       funcnum=0;
       /* WAIT FOR PC TO DOWNLOAD FUNCTION NUMBER */
       while (!(funcnum));
       n = bs >> 1;
       switch(funcnum) {
          case 1: /* CONVERT TO DSP FORMAT */
                    dsp32(bs,o1);
                    break;

          case 2: /* CONVERT TO IEEE FORMAT */
                    ieee32(bs,o1);
                    break;

          case 3: /* SYNTHESIZE COSINE */
                    scal = 2.0 * PI * freq / samprate;
                    j = 0;
                    data1 = o1;
                    for (i=bs; i-- > 0; j++) {
                      *data1++ = (amp * cos(scal * j)) + dco;
                    }
                    break;

          case 4: /* FORWARD FFT */
                    data1 = o1;
                    data1--;
                    realft(data1,n,1);
                    break;

          case 5: /* INVERSE FFT */
                    data1 = o1;
                    data1--;
                    realft(data1,n,-1);

                    /* scale by 1/n to retain original amplitude */
                    data1 = o1;
                    scal = 1.0 / n;
                    for (i=bs; i-- > 0; data1++) {
                      *data1 = *data1 * scal;
                    }
                    break;

          case 6: /* CALCULATE LOG-MAGNITUDE (data output from NR-realft) */
                    o1[0]=log10(SQR(i1[0]));
                    temp=log10(SQR(i1[1]));
                    for (i=1;i<n;i++) {
                      o1[i]=log10(SQR(i1[2*i])+SQR(i1[2*i+1]));
                    }
                    o1[n] = temp;
                    for (i=n+1;i<bs;i++) {
                      o1[i]=0.0;
                    }
                    break;

          case 7: /* FORWARD FFT */
                    data1 = o1;
                    rffta(bs,fft_stages(bs),data1);
                    break;

          default : break;
       }
     }
}

