
/***********************************************************************/
/*   file ddj_mp87.c                                                   */
/***********************************************************************/
/*                                                                     */
/*   MathPak 87 FFT Function Group Execution Source File               */
/*                                                                     */
/***********************************************************************/

#include <hq_ci_.h>                     /* include function prototypes */
#include <mpak87.h>                     /* include math pak header */

#define BAD_BLOCK_SIZE        -1        /* user defined error codes */
#define BAD_FUNC_NUM          -2

/*** function prototypes ***********************************************/
int fft_stages(long fft_size);

/*** function implementations ******************************************/

void main(int argc, char *argv[])
{
   int         m;                                     /* number of fft stages */
   far_array_of_double o1;                                    /* data pointer */

   init_intfc(argc, argv);   /* MUST do this before other interface functions */
   o1 = get_data_out_ptr(1);                           /* get address of data */
   if ((m = fft_stages(get_block_size())) == 0)
      set_err_return(BAD_BLOCK_SIZE);    /* won't happen if .fnc file correct */
   else
   switch(get_func_num())
   {
      case 1: rvfft(o1, m); break;       /* real fft from MathPak library     */
      case 2: irvfft(o1, m); break;      /* inverse real fft from MathPak     */
      default:                           
        set_err_return(BAD_FUNC_NUM);    /* won't happen if .fnc file correct */
      break;
   }
}  /* IT'S THAT EASY !!! */

/* RETURN THE LOG(BASE 2) OF THE INPUT, OR 0 IF INPUT IS NOT A POWER OF 2 */
int fft_stages(long fft_size)
{
   int rtn;
   int sw_fft;

   sw_fft = fft_size;
   switch(sw_fft)
   {
      case 8  : rtn = 3; break;
      case 16  : rtn = 4; break;
      case 32  : rtn = 5; break;
      case 64  : rtn = 6; break;
      case 128 : rtn = 7; break;
      case 256 : rtn = 8; break;
      case 512 : rtn = 9; break;
      case 1024 : rtn = 10; break;
      case 2048 : rtn = 11; break;
      case 4096 : rtn = 12; break;
      case 8192 : rtn = 13; break;
      default  : rtn = 0; break;
   }
   return(rtn);
}


