/*******************************************************************
 *                                                                 *
 *          FILE: startup.s                                        *
 *                                                                 *
 *          DESCRIPTION: for several DSP32c boards                 *
 *                                                                 *
 *******************************************************************/

#define   sp   r14e                               /* stack pointer */
#define   rp   r18                               /* return pointer */
#define   rpe  r18e                              /* return pointer */
#define   ir   r19                           /* increment register */

#define   STACK_INC 4                           /* stack increment */

     .rsect    ".text"
     .global   __start
     .global   __end
     .global   errno

     .align    4

__start:
     nop
     dauc = 0                                  /* Set round to int */
     r1 = 0
     pcw = r1
     ioc = 0x30cc0       /* Disable serial DMA's, setup 32-bit I/O */
     sp = _stack                       /* Stack is empty at bottom */
     ir = STACK_INC                             /* stack increment */
     call main (rp)                      /* Nothing else to do now */
     rpe = . + 4                  /* to get around call bug in 32c */

     r1 = 0
     pdr = r1                                          /* exit (0) */
__end:    goto __end
     nop

     .rsect    ".data"
errno:    int

     .rsect    ".bss"
_stack:   byte
