/* ------------- rect.c --------------- */

#include "dflat.h"

/*
 * Produce the intersection of two vectors
 */
static void subVector(int *v1, int *v2, int t1, int t2, int o1, int o2)
{
	*v1 = *v2 = -1;
	if (within(o1, t1, t2))	{
		*v1 = o1;
		if (within(o2, t1, t2))
			*v2 = o2;
		else
			*v2 = t2;
	}
	else if (within(o2, t1, t2))	{
		*v2 = o2;
		if (within(o1, t1, t2))
			*v1 = o1;
		else
			*v1 = t1;
	}
	else if (within(t1, o1, o2))	{
		*v1 = t1;
		if (within(t2, o1, o2))
			*v2 = t2;
		else
			*v2 = t2;
	}
	else if (within(t2, o1, o2))	{
		*v2 = t2;
		if (within(t1, o1, o2))
			*v1 = t1;
		else
			*v1 = o1;
	}
}

/*
 * Return the rectangle that is the intersection of the two arguments
 */
RECT subRectangle(RECT r1, RECT r2)
{
	RECT r = {0,0,0,0};
	subVector((int *) &RectLeft(r), (int *) &RectRight(r),
			RectLeft(r1), RectRight(r1), RectLeft(r2), RectRight(r2));
	subVector((int *) &RectTop(r), (int *) &RectBottom(r),
			RectTop(r1), RectBottom(r1), RectTop(r2), RectBottom(r2));
	if (RectRight(r) == -1 || RectTop(r) == -1)
		RectRight(r) = RectLeft(r) = RectTop(r) = RectBottom(r) = 0;
	return r;
}

/*
 * Assumes that r1 is a proper subset of r2
 * Returns a rectangle that is the relative position of r1 within r2
 */
RECT RelativeRectangle(RECT r1, RECT r2)
{
	RECT rc;
	RectLeft(rc) = RectLeft(r1) - RectLeft(r2);
	RectTop(rc) = RectTop(r1) - RectTop(r2);
	RectBottom(rc) = RectTop(rc) + RectHeight(r1) - 1;
	RectRight(rc) = RectLeft(rc) + RectWidth(r1) - 1;
	return rc;
}

RECT ClientRect(void *wnd)
{
	RECT rc = ((WINDOW)wnd)->rc;
	if (TestAttribute((WINDOW)wnd, HASBORDER))	{
		RectLeft(rc)++;
		RectRight(rc)--;
	}
	if (WindowHeight((WINDOW)wnd) > 1 && (GetClass((WINDOW)wnd) != EDITBOX ||
			TestAttribute((WINDOW)wnd, MULTILINE)))	{
		RectTop(rc)++;
		RectBottom(rc)--;
		if (TestAttribute((WINDOW)wnd, HASMENUBAR))
			RectTop(rc)++;
	}
	return rc;
}

/*
 * Initialize a rectangle
 */
RECT SetRect(int lf, int tp, int rt, int bt)
{
	RECT rc;
	rc.lf = lf;
	rc.tp = tp;
	rc.rt = rt;
	rc.bt = bt;
	return rc;
}

