/* -------------- button.c -------------- */

#include <conio.h>
#include "dflat.h"

int ButtonProc(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
{
	DBOX *db = GetParent(wnd)->extension;
	CTLWINDOW *ct = ControlBox(db, wnd);
	int rtn, i;
	switch (msg)	{
		case SETFOCUS:
			BaseWndProc(BUTTON, wnd, msg, p1, p2);
			if (p1)
				return TRUE;
		case PAINT:
			if (isVisible(wnd))	{
				/* -------- draw the button's shadow ------- */
				background = WndBackground(GetParent(wnd));
				foreground = BLACK;
				PutWindowChar(wnd, WindowWidth(wnd), 0, 220);
				for (i = 0; i < WindowWidth(wnd); i++)
					PutWindowChar(wnd, i+1, 1, 223);
				/* --------- write the button's text ------- */
				WriteTextLine(wnd, NULL, 0, wnd == inFocus);
			}
			return TRUE;
		case KEYBOARD:
			if (p1 == '\r')	{
				PostMessage(GetParent(wnd), COMMAND, ct->command, 0);
				return TRUE;
			}
			break;
		case LEFT_BUTTON:
			rtn = BaseWndProc(BUTTON, wnd, msg, p1, p2);
			PostMessage(GetParent(wnd), COMMAND, ct->command, 0);
			return rtn;
		case HORIZSCROLL:
			return TRUE;
		default:
			break;
	}
	return BaseWndProc(BUTTON, wnd, msg, p1, p2);
}


