/* --------------- notepad.c ----------- */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <dos.h>
#include "dflat.h"

static char Untitled[] = "Untitled";
static int DocumentCount = 0;

static int MemoPadProc(WINDOW, MESSAGE, PARAM, PARAM);
static void OpenPadWindow(WINDOW, char *);
static void LoadFile(WINDOW, int);
static void SaveFile(WINDOW);
static int EditorProc(WINDOW, MESSAGE, PARAM, PARAM);
static char *NameComponent(char *);

char **Argv;

void main(int argc, char *argv[])
{
	WINDOW wnd;
	init_messages();
	Argv = argv;
	wnd = CreateWindow(APPLICATION,
						"D-Flat MemoPad " VERSION,
						0, 0, -1, -1,
						MainMenu,
						NULL,
						MemoPadProc,
						MOVEABLE | SIZEABLE
						);

	SendMessage(wnd, SETFOCUS, TRUE, 0);
	if (argc > 1)
		OpenPadWindow(wnd, argv[1]);
	while (dispatch_message())
		;
}

static int MemoPadProc(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
{
	switch (msg)	{
		case COMMAND:
			switch ((int)p1)	{
                case ID_NEW:
				    OpenPadWindow(wnd, Untitled);
					return TRUE;
                case ID_SAVE:
                    SaveFile(inFocus);
					return TRUE;
				case ID_ABOUT:
					MessageBox(
						"About D-Flat and the MemoPad",
						"D-Flat is an operating environment\n"
						"that implements the SAA/CUA user\n"
						"interface in a public domain\n"
						"C language library originally\n"
						"published in Dr. Dobb's Journal.\n"
						"    ------------------------ \n"
						"The NotePad is a single document\n"
						"text editor that demonstrates the\n"
						"use of D-Flat.");
					return TRUE;
				default:
					break;
			}
			break;
		default:
			break;
	}
	return DefaultWndProc(wnd, msg, p1, p2);
}


/*
 *  open a document window and load a file
 */
static void OpenPadWindow(WINDOW wnd, char *FileName)
{
    static WINDOW wnd1 = NULLWND;
    struct stat sb;
	char *Fname = FileName;
	char *ermsg;
    if (strcmp(FileName, Untitled))	{
		if (stat(FileName, &sb))    {
			if ((ermsg = malloc(strlen(FileName)+20)) != NULL)	{
				strcpy(ermsg, "No such file as\n");
				strcat(ermsg, FileName);
		        ErrorMessage(ermsg);
				free(ermsg);
			}
    	    return;
	    }
		Fname = NameComponent(FileName);
	}
	if (wnd1 != NULLWND)
		SendMessage(wnd1, CLOSE_WINDOW, 0, 0);
	wnd1 = CreateWindow(EDITBOX,
				Fname,
				GetClientLeft(wnd),GetClientTop(wnd),
				ClientHeight(wnd),ClientWidth(wnd),
				NULL, wnd, EditorProc,
				VSCROLLBAR |
				HSCROLLBAR |
				MOVEABLE   |
				HASBORDER  |
				SIZEABLE   |
				MULTILINE
	);
    if (strcmp(FileName, Untitled))	{
		if ((wnd1->extension = malloc(strlen(FileName)+1)) != NULL)	{
			strcpy(wnd1->extension, FileName);
    	    LoadFile(wnd1, (int) sb.st_size);
		}
	}
	SendMessage(wnd1, SETFOCUS, TRUE, 0);
}

/*
 *  Load the notepad file into the editor text buffer
 */
static void LoadFile(WINDOW wnd, int tLen)
{
    char *Buf;
    FILE *fp;

    if ((Buf = malloc(tLen+1)) != NULL)    {
        if ((fp = fopen(wnd->extension, "rt")) != NULL)    {
            memset (Buf, 0, tLen+1);
            fread(Buf, tLen, 1, fp);
		    SendMessage(wnd, SETTEXT, (PARAM) Buf, 0);
            fclose(fp);
        }
		free(Buf);
    }
}

static void SaveFile(WINDOW wnd)
{
	FILE *fp;
	if (wnd->extension != NULL)	{
		WINDOW mwnd = MomentaryMessage("Saving the file");
		if ((fp = fopen(wnd->extension, "wt")) != NULL)	{
			fwrite(GetText(wnd), strlen(GetText(wnd)), 1, fp);
			fclose(fp);
			wnd->TextChanged = FALSE;
		}
		SendMessage(mwnd, CLOSE_WINDOW, 0, 0);
	}
}

static int EditorProc(WINDOW wnd, MESSAGE msg, PARAM p1, PARAM p2)
{
	switch (msg)	{
		case CREATE_WINDOW:
			if (DocumentCount == 0)
				ActivateCommand(MainMenu, ID_SAVE);
			DocumentCount++;
			break;
		case CLOSE_WINDOW:
			if (wnd->extension != NULL)	{
				free(wnd->extension);
				wnd->extension = NULL;
			}
			break;
		default:
			break;
	}
	return DefaultWndProc(wnd, msg, p1, p2);
}

static char *NameComponent(char *FileName)
{
	char *Fname;
	if ((Fname = strrchr(FileName, '\\')) == NULL)
		if ((Fname = strrchr(FileName, ':')) == NULL)
			Fname = FileName-1;
	return Fname + 1;
}


