/* bob.c - the main routine */
/*
	Copyright (c) 1991, by David Michael Betz
	All rights reserved
*/

#include <stdio.h>
#include <setjmp.h>
#include "bob.h"

#define BANNER	"Bob v1.0 - Copyright (c) 1991, by David Betz"

/* global variables */
jmp_buf error_trap;

/* external variables */
extern int decode,trace;

/* main - the main routine */
main(argc,argv)
  int argc; char *argv[];
{
    char fullname[20];
    int i;

    /* display the banner */
    osputs(BANNER);
    osputs("\n");

    /* initialize */
    initialize(SMAX,CMAX);

    /* load and execute some code */
    for (i = 1; i < argc; ++i)
	if (strcmp(argv[i],"-d") == 0)
	    decode = 1;
	else if (strcmp(argv[i],"-t") == 0)
	    trace = 1;
	else {
	    strcpy(fullname,argv[i]);
	    strcat(fullname,".bob");
	    compile_file(fullname);
	}
    execute("main");
}

/* compile_file - compile definitions in a file */
static compile_file(name)
  char *name;
{
    FILE *ifp;
    if ((ifp = fopen(name,"r")) != NULL) {
	compile_definitions(fgetc,ifp);
	fclose(ifp);
    }
}

/* info - display progress information */
info(fmt,a1,a2,a3,a4,a5,a6)
  char *fmt;
{
    char buf1[100],buf2[100];
    sprintf(buf1,fmt,a1,a2,a3,a4,a5,a6);
    sprintf(buf2,"[ %s ]\n",buf1);
    osputs(buf2);
}

/* error - print an error message and exit */
error(fmt,a1,a2,a3,a4)
  char *fmt;
{
    char buf1[100],buf2[100];
    sprintf(buf1,fmt,a1,a2,a3,a4);
    sprintf(buf2,"Error: %s\n",buf1);
    osputs(buf2);
    longjmp(error_trap,1);
}

osputc(ch)
  int ch;
{
    putc(ch,stdout);
}

osputs(str)
  char *str;
{
    fputs(str,stdout);
}
