#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <string.hpp>

String &String::operator=(const String&s)
{
    if (this == &s)
        return *this;
    if (--rp->refs < 1)
        delete rp;
    rp = s.rp;
    if (rp)
        rp->refs++;
    return *this;
}

String &String::operator=(const char *s)
{
    if (--rp->refs < 1)
        delete rp;
    int n = strlen(s);
    if (n) {
        rp = new(n) srep(n,s);
        if (!rp)
            errno = ENOMEM;
        else
            rp->refs++;
    } else
        rp = 0;
    return *this;
}

String &String::operator=(char c)
{
    if (--rp->refs < 1)
        delete rp;
    rp = new(1) srep(1,&c);
    if (!rp)
        errno = ENOMEM;
    else
        rp->refs++;
    return *this;
}
