#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <string.hpp>

String &String::insert(int pos, const char *s, int count)
{
    int sl = count? count: strlen(s);
    if (!sl)
        return *this;
    if (pos > length()) { // pos == length() is concatenate
        errno = ERANGE;
        return *this;
    }
    int n = length()+sl;
    srep *p = new(n) srep(n);
    if (!p) {
        errno = ENOMEM;
        return *this;
    }
    memmove(p->body,body(),pos);
    memmove(p->body+pos, s, sl);
    memmove(p->body+pos+sl, body()+pos, length()-pos);
    if (rp) {
        if (--rp->refs < 1)
        delete rp;
    }
    rp = p;
    rp->refs++;
    return *this;
}
