#ifndef __STRING_HPP
#define __STRING_HPP
#include <stddef.h>
#include <string.h>
#include <limits.h>

class istream;
class ostream;

class srep {
friend class String;
friend String dup(const String&);
private:
    srep(int, const char * = 0);
    void *operator new(size_t cs, size_t ss = 0);

    int refs;
    int length;
    char body[1];
};

class String {
friend int strlen(const String&);

friend String operator+(const String&, const String&);
friend String operator+(const String&, const char *);
friend String operator+(const char *, const String&);
friend int operator==(const String&, const String&);
friend int operator==(const String&, const char *);
friend int operator==(const char *, const String&);
friend int operator!=(const String&, const String&);
friend int operator!=(const String&, const char *);
friend int operator!=(const char *, const String&);
friend int operator>(const String&, const String&);
friend int operator>(const String&, const char *);
friend int operator>(const char *, const String&);
friend int operator<(const String&, const String&);
friend int operator<(const String&, const char *);
friend int operator<(const char *, const String&);
friend int operator>=(const String&, const String&);
friend int operator>=(const String&, const char *);
friend int operator>=(const char *, const String&);
friend int operator<=(const String&, const String&);
friend int operator<=(const String&, const char *);
friend int operator<=(const char *, const String&);

friend istream &operator>>(istream&, String&);
friend ostream &operator<<(ostream&, const String&);
public:

    enum string_enum { all = INT_MAX };

    String();
    String(const String&);
    String(const char *, int count = 0);
    String(char);

    ~String();

    operator char*() const { return body(); }
    operator char() const { return *body(); }
    String upper() const;
    String lower() const;

    String &operator=(const String&);
    String &operator=(const char *);
    String &operator=(char);
    String &operator+=(const String&);
    String &operator+=(const char *);
    String &operator+=(char);

    String &insert(int pos, const String&);
    String &insert(int pos, const char *, int count = 0);
    String &insert(int pos, char);
    String &remove(int pos, int count);
    String &truncate(int);

    char &operator[](int);
    char operator()(int i) { return *(rp->body+i); }
    String operator()(int start, int len);

    int match(const String&) const;
    int match(const char *) const;
    int index(const String&, int pos = 0) const;
    int index(const char *, int = 0) const;
    int index(char, int = 0) const;

    int operator!() const { return !rp; }
    int length() const { return rp? rp->length: 0; }
private:
    char *body() const { return rp? rp->body: 0; }

    srep *rp;
    static char dummy;
};

inline int strlen(const String &s)
{
    return s.length();
}

#endif
