#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <string.hpp>

String &String::operator+=(const String &s)
{
    if (!s.rp) return *this;
    int n = length()+s.length();
    srep *p = new(n) srep(n);
    if (!p) {
        errno = ENOMEM;
        return *this;
    }
    memmove(p->body,body(),length());
    memmove(p->body+length(),s.body(),s.length());
    if (rp) {
        if (--rp->refs < 1)
        delete rp;
    }
    rp = p;
    rp->refs++;
    return *this;
}

String &String::operator+=(const char *s)
{
    int n = strlen(s);
    if (!n) return *this;
    int m = n+length();
    srep *p = new(m) srep(m);
    if (!p) {
        errno = ENOMEM;
        return *this;
    }
    memmove(p->body,body(),length());
    memmove(p->body+length(),s,n);
    if (rp) {
        if (--rp->refs < 1)
        delete rp;
    }
    rp = p;
    rp->refs++;
    return *this;
}

String &String::operator+=(char c)
{
    int n = length()+1;
    srep *p = new(n) srep(n);
    if (!p) {
        errno = ENOMEM;
        return *this;
    }
    memmove(p->body,body(),length());
    p->body[n-1] = c;
    if (rp) {
        if (--rp->refs < 1)
        delete rp;
    }
    rp = p;
    rp->refs++;
    return *this;
}
