#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <string.hpp>

int String::match(const String &a) const
{
    if (!rp || !a.rp) return 0;
    int lim, rv = -1;
    if (a.length() > length())
        lim = rv = length();
    else
        lim = a.length();
    const char *p = body(), *q = a.body();
    for (int i = 0; i < lim; ++i)
        if (*p++ != *q++)
            return i;
    return rv;
}

int String::match(const char *s) const
{
    if (!rp || !*s) return 0;
    int rv = -1, lim, sl = strlen(s);
    if (sl > length())
        lim = rv = length();
    else
        lim = sl;
    const char *p = body();
    for (int i = 0; i < lim; ++i)
        if (*p++ != *s++)
            return i;
    return rv;
}
