/****************************************************************
 *                                                              *
 * REBOOT.C - Disable ^ALT-DEL for CodeBuilder programs         *
 * Al Williams -- August 1991                                   *
 *                                                              *
 ****************************************************************/
#include <stdio.h>
#include <i32.h>
#include <stk.h>
#include <dos.h>
#include <conio.h>

/* When running DOS we replace the keyboard interrupt
   (INT 9) */

/* old INT 9 handler */
static void (*oldint9)();

#pragma interrupt(ourint9)

/* replacement interrupt handler */
static void ourint9()
  {
  int code,temp;
/* pointer to CodeBuilder stack frames */
  _XSTACK *frame=_get_stk_frame();
/* pointer to BIOS shift status byte */
  unsigned char *shift_status=(unsigned char *)0x417;
/* read keyboard */
  code=inp(0x60);

/* DEL is scan code 0x53 -- if *shift_status&0xc==0xc then shift
   and Alt are down */
  if (code!=0x53||(*shift_status&0xc)!=0xc) _chain_intr(oldint9);
/* will not allow ^ALT-DEL */
/* consume key from keyboard */
  temp=inp(0x61);
  outp(0x61,temp|0x80);
  outp(0x61,temp);
  outp(0x20,0x20);
/* Tell CodeBuilder not to reissue interrupt */
  frame->opts=_STK_NOINT;
  return;
  }

/* This function locks the page ourint9 is on so it can't be
   swapped out. 4K is the minimum size, and surely ourint9
   isn't that big.... */
static lockint9(int flag)
  {
  static lock=0;
  if (flag!=lock)
    {
    lock=flag;
    if (flag)
      _dpmi_lockregion(ourint9,4096);
    else
      _dpmi_unlockregion(ourint9,4096);
    }
  }

/********************** External interfaces ******************/

/* Disable ^ALT-DEL */
void noreboot()
  {
  lockint9(1);
  oldint9=_dos_getvect(9);
  _dos_setvect(9,ourint9);
  }

/* Enable ^ALT-DEL */
void okreboot()
  {
  lockint9(0);
  _dos_setvect(9,oldint9);
  }
