	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
ENDIF

	EXTRN	clrNextContext:NEAR
	EXTRN	sendMsg:NEAR

	EXTRN	Hardware:WORD
	EXTRN	KeyBoard:WORD
	EXTRN	Mouse:WORD
	EXTRN	Self:WORD

	.CODE

	PUBLIC	readEvent
COMMENT	%
==============================================================================
Dispatches keyboard events to appropriate handler.

=============================================================================%
readEvent	PROC	NEAR
rdt1:	push		Self
	send		Hardware,Refresh	;Update devices' status
	send		Hardware,Read		;Read input devices
	pop		Self
	getInst		al,?NewState,Mouse	;Get new state flag
	identity	al,rdt2			;Jump if new state
	getInst		ah,ScanCode,Keyboard	;Get scan code
	null		ah,rdt1			;Loop if no key pressed

	call		findKeyHandler		;Find handler from key event
	jmp		rdt3

rdt2:	call		findMouseHandler	;Find handler from mouse event

rdt3:	call		passMsg			;Pass message
	null		bx,rdt1			;Nil? - Keep reading

	mov		Wptr[Self],bx		;Get new Self
	jmp		rdt1			;Keep reading
	ret
readEvent	ENDP



COMMENT	%
==============================================================================
Finds appropriate handler for given keyboard event.

Passed:	si - Pointer to Keyboard instance variable structure

Passes:	si - Pointer to event handler record

=============================================================================%
findKeyHandler	PROC	NEAR
	getInst		al,AsciiCode		;Get ASCII code
	getInst		si,DispTbl,Self		;Pointer to dispatch tbl

fkh1:	eq		al,Bptr[si],fkh3	;Jump if match on ASCII code
fkh2:	add		si,10			;Point to next entry
	identity	Bptr[si],fkh1,fkh4	;Loop if more else use default

fkh3:	neq		ah,Bptr[si+1],fkh2	;Jump if no match
fkh4:	ret
findKeyHandler	ENDP



COMMENT	%
==============================================================================
Finds appropriate handler for given mouse event.

Passed:	si - Pointer to Mouse instance variable structure

Passes:	si - Pointer to event handler record

=============================================================================%
findMouseHandler	PROC	NEAR
	getInst		al,Row1			;Get mouse row
	getInst		ah,Col1			;Get mouse column
	getInst		bl,Status		;Get button status
	getInst		si,DispTbl,Self		;Pointer to dispatch tbl

fmh1:	null		Bptr[si+2],fmh3		;Jump on don't care status
	eq		bl,Bptr[si+2],fmh3	;Else jump on status match
fmh2:	add		si,10			;Point to next entry
	identity	Bptr[si+3],fmh1,fmh7	;Loop if more else use default

fmh3:	moreThanEq	al,Bptr[si+3],fmh4	;Jump if >= upper row
	jmp		fmh2

fmh4:	lessThanEq	al,Bptr[si+5],fmh5 	;Jump if <= lower row
	jmp		fmh2

fmh5:	moreThanEq	ah,Bptr[si+4],fmh6	;Jump if >= left column
	jmp		fmh2

fmh6:	moreThan	ah,Bptr[si+6],fmh2	;Jump if > right column
fmh7:	ret
findMouseHandler	ENDP



COMMENT	%
==============================================================================
Passes message to object in a dispatch table entry.

Passed:	si - Pointer to dispatch table entry

Passes:	bx - Pointer to next object providing dispatch table

=============================================================================%
passMsg	PROC	NEAR
	sendLoop	si,7,8			;Send messages
	getInst		bx,NextContext,Dispatch	;Get next obj
	setInst		NextContext,Nil,,2	;Clear next obj
	ret
passMsg	ENDP



COMMENT	%
==============================================================================
Sets the next object to be the dispatch table source.

=============================================================================%
setNextContext	PROC	NEAR
	mov		ax,Wptr[Self]		;Get current object
	setInst		NextContext,ax,Dispatch	;Set it as next context
	ret
setNextContext	ENDP



COMMENT	%
==============================================================================
Updates hardware to return devices to normal state.

=============================================================================%
updateHardware	PROC	NEAR
	push		Self
	send		Hardware,Update		;Update devices
	pop		Self
	ret
updateHardware	ENDP

	
	.DATA

defMsg	Dispatch,\
	Read,\
	<,,setNextContext>

defMsg	Dispatch,\
	Clear,\
	<updateHardware,,clrNextContext>

defObj	Dispatch,\
	<>,\
	<NextContext,2,Nil>,\
	<Read,Clear>



	END

