	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	messages.inc
	INCLUDE	instance.inc
	INCLUDE	objects.inc

	MouseCursor	EQU	30d		;Character code for cursor

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
ENDIF

	EXTRN	sendMsg:NEAR

	EXTRN	Self:WORD

	.CODE

IF Dbug
	PUBLIC	mouseReset
ENDIF
COMMENT	%
==============================================================================
Resets the mouse. 

=============================================================================%
mouseReset      PROC	NEAR 
	push		es
	xor		ax,ax
	mov		es,ax
	mov     	si,204d
	neq		ax,es:[si],mr1	   	;Jump if we have a vector
	eq		ax,es:[si+2],mr2   	;Jump if no vector
mr1:	int     	33h
mr2:	setInst     	?Mouse,al,Mouse		;Set flag if mouse present
	pop		es
	ret
mouseReset      ENDP 



IF Dbug
	PUBLIC	?UpdateMouseCursor
ENDIF
COMMENT	%
==============================================================================
Update the mouse cursor if its state has changed.

=============================================================================%
?UpdateMouseCursor      PROC	NEAR 
	getInst		al,?Mouse,Mouse
	identity	al,umc1			;Exit if no mouse installed

	mov		ax,1			;Enable function code
	int		33h			;Show cursor

	getInst		al,?NewState,Mouse	;Get new state flag
	null		al,umc1			;Exit if not new state

	mov		ax,10			;Function number
	xor		bx,bx			;Want s/w cursor
	mov		cx,7700h		;Screen mask
	mov		dx,MouseCursor		;Cursor mask
	int     	33h			;Update mouse cursor

umc1:	ret
?UpdateMouseCursor      ENDP 



COMMENT	%
==============================================================================
Makes the mouse cursor visible.

=============================================================================%
showMouseCursor      PROC	NEAR 
	getInst		al,?Mouse,Mouse
	identity	al,smc1			;Exit if no mouse installed
	mov		ax,1			;Enable function code
	int		33h			;Show cursor
smc1:	ret
showMouseCursor      ENDP 



	PUBLIC	hideMouseCursor
COMMENT	%
==============================================================================
Makes the mouse cursor invisible.

=============================================================================%
hideMouseCursor      PROC	NEAR 
	getInst		al,?Mouse,Mouse
	identity	al,hmc1			;Exit if no mouse installed
	mov		ax,2			;Disable function code
	int		33h			;Hide cursor
hmc1:	ret
hideMouseCursor      ENDP 



IF Dbug
	PUBLIC	getMouseStatus
ENDIF
COMMENT	%
==============================================================================
Makes the mouse cursor visible.

=============================================================================%
getMouseStatus      PROC	NEAR 
	getInst		al,?Mouse,Mouse
	identity	al,gms1			;Exit if no mouse installed

	mov		ax,3			;Status function code
	int		33h			;Get mouse status

	setInst		?NewState,Nil,,1	;Clear new mouse state flag
	getInst		bh,Status		;Get last number of status
	eq		bh,bl,gms2		;Jump if no change

	setInst		?NewState,1,,1		;Flag as new mouse state
	and		bl,1			;Mask off other buttons' status
	setInst		Status,bl		;Save number of button status

gms2:	push		cx			;Save column
	push		dx			;Save row
	pop		ax			;Get row
	mov		cl,8			;Calc 24X80 row
	div		cl
	getInst		ah,Row1			;Get last mouse row
	eq		ah,al,gms3		;Jump if no change
	setInst		?NewState,1,,1		;Flag as new mouse state
	setInst		Row1,al			;Save mouse row

gms3:	pop		ax			;Get column
	div		cl			;Calc 24X80 column
	getInst		ah,Col1			;Get last mouse column
	eq		ah,al,gms1		;Jump if no change
	setInst		?NewState,1,,1		;Flag as new mouse state
	setInst		Col1,al			;Save mouse column

gms1:	ret
getMouseStatus      ENDP 



	.DATA

defMsg	Mouse,\
	Init,\
	<mouseReset,,showMouseCursor>

defMsg	Mouse,\
	Read,\
	<,,getMouseStatus>

defMsg	Mouse,\
	Refresh,\
	<,,?UpdateMouseCursor>

defObj	Mouse,\
	<>,\
	<Row1,1,0,\
	Col1,1,0,\
	Status,1,0,\
	?Mouse,1,0,\
	?NewState,1,Nil>,\
	<Init,Read,Refresh>



	END
