	.MODEL	SMALL

	INCLUDE	equates.inc
	INCLUDE	instance.inc
	INCLUDE	messages.inc
	INCLUDE	objects.inc

IF1
	INCLUDE	macros.mac
	INCLUDE	objects.mac
	INCLUDE	video.mac
ENDIF

	EXTRN	Self:WORD

	.CODE

	PUBLIC	winInstVars
COMMENT	%
==============================================================================
Gets the instance variables for Window objects.

=============================================================================%
winInstVars	PROC	NEAR
	getInst		ch,Row1,Self		;Get upper row
	getInst		cl,Col1			;Get left column
	getInst		dh,Row2			;Get lower row
	getInst		dl,Col2			;Get right column
	getInst		bl,Color		;Get window color
	ret
winInstVars	ENDP



COMMENT	%
==============================================================================
Clears a window.

=============================================================================%
clrWindow	PROC	NEAR
	call		winInstVars		;Get window instance vars
	clrWin		ch,cl,dh,dl,bl
	ret
clrWindow	ENDP



COMMENT	%
==============================================================================
Clears a window skipping the border.

=============================================================================%
clrWindow_	PROC	NEAR
	call		winInstVars		;Get window instance vars
	inc		ch			;Shrink window coords
	inc		cl
	dec		dh
	dec		dl
	clrWin		ch,cl,dh,dl,bl
	ret
clrWindow_	ENDP



COMMENT	%
==============================================================================
Scrolls a window up.

Passed:	StackTop - Number of lines to scroll

=============================================================================%
scrlWinUp	PROC	NEAR
	getStackArgs	ax			;Get #lines to scroll
	call		winInstVars		;Get window instance vars
	inc		ch			;Shrink window coords
	inc		cl
	dec		dh
	dec		dl
	scrlUp		ch,cl,dh,dl,bl,al
	ret
scrlWinUp	ENDP



COMMENT	%
==============================================================================
Scrolls a window down.

Passed:	StackTop - Number of lines to scroll

=============================================================================%
scrlWinDown	PROC	NEAR
	getStackArgs	ax			;Get #lines to scroll
	call		winInstVars		;Get window instance vars
	inc		ch			;Shrink window coords
	inc		cl
	dec		dh
	dec		dl
	scrlDn		ch,cl,dh,dl,bl,al
	ret
scrlWinDown	ENDP



	.DATA

defMsg	Window,\
	Refresh,\
	<clrWindow,,>

defMsg	Window,\
	ScrollUp,\
	<scrlWinUp,,>

defMsg	Window,\
	ScrollDown,\
	<scrlWinDown,,>

defMsg	Window,\
	ScrollLeft,\
	<clrWindow_,,>

defMsg	Window,\
	ScrollRight,\
	<clrWindow_,,>

defObj	Window,\
	<>,\
	<>,\
	<Refresh,ScrollUp,ScrollDown,ScrollLeft,ScrollRight>



	END
