;---------------------------------------------------------------    
;cdlogdat.inc - data for monitoring device drivers used with   |
;               MSCDEX.                                        |
;--------------------------------------------------------------|
;
cmd0_desc       db      'Init', NULL
cmd3_desc       db      'IOCTL Input', NULL
cmd7_desc       db      'Input Flush', NULL
cmd11_desc      db      'Output Flush', NULL
cmd12_desc      db      'IOCTL Output', NULL
cmd13_desc      db      'Device Open', NULL
cmd14_desc      db      'Device CLOSE', NULL
cmd128_desc     db      'Read Long', NULL
cmd130_desc     db      'Read Long Prefetch', NULL
cmd131_desc     db      'Seek', NULL
cmd132_desc     db      'Play Audio', NULL
cmd133_desc     db      'Stop Audio', NULL
cmd136_desc     db      'Resume Audio', NULL
cmduk_desc      db      'Unknown Command!', NULL

sub_3_0_desc    db      'Return Address of Device Header', NULL
sub_3_1_desc    db      'Location of Head', NULL
sub_3_3_desc    db      'Error Statistics', NULL
sub_3_4_desc    db      'Audio Channel Info ', NULL
sub_3_5_desc    db      'Read Drive Bytes', NULL
sub_3_6_desc    db      'Device Status ', NULL
sub_3_7_desc    db      'Return Sector Size ', NULL
sub_3_8_desc    db      'Return Volume Size ', NULL
sub_3_9_desc    db      'Media Changed ', NULL
sub_3_10_desc   db      'Audio Disk Info ', NULL
sub_3_11_desc   db      'Audio Track Info ', NULL
sub_3_12_desc   db      'Audio Q-Channnel Info ', NULL
sub_3_13_desc   db      'Audio Sub-Channel Info ', NULL
sub_3_14_desc   db      'UPC Code ', NULL
sub_3_15_desc   db      'Audio Status Info ', NULL

sub_12_0_desc   db      'Eject',NULL
sub_12_1_desc   db      'Lock/Unlock Door',NULL
sub_12_2_desc   db      'Reset Drive',NULL
sub_12_3_desc   db      'Audio Channel Control',NULL
sub_12_4_desc   db      'Write Device Control String',NULL
sub_12_5_desc   db      'Close Tray',NULL

subuk_desc      db      'Unknown Function! - Define it in tables', NULL


cmd_table       req_info        < 0, cmd0_desc,,,>   
                req_info        <  3, cmd3_desc,,cmd3_sub,>
                req_info        <  7, cmd7_desc,,,>     
                req_info        < 11, cmd11_desc,,,>     
                req_info        < 12, cmd12_desc,,cmd12_sub,>
                req_info        < 13, cmd13_desc,,,>     
                req_info        < 14, cmd14_desc,,,>
                req_info        <128, cmd128_desc, cmd128_io,,>
                req_info        <130, cmd130_desc,,,>
                req_info        <131, cmd131_desc,,,>   
                req_info        <132, cmd132_desc,,,>   
                req_info        <133, cmd133_desc,,,>   
                req_info        <136, cmd136_desc,,,>   
                req_info        < TABLE_TERM, cmduk_desc,,,>


;The data in the following table follows the format defined in the        
;io_table structure.  Each group of data can have a variable length.  If the
;element at offset io_bs_indic is FALSE, then a variable number of additional
;elements as outlined in the structure io_bs_elements will appear.
;

io_cmd_table    label   word
cmd128_io       dw      14
                dw      18
                db      INPUT
                db      FALSE
                dw      24
                db      0                       ;if read mode 0
                dw      2048                    ;block size is 2048
                db      1
                dw      2352        




cmd3_sub        func            <14, 0, NULL, cmd_3_det, FALSE>              

cmd_3_det       func_detail     < 0, 0, sub_3_0_desc, 5,,>
                func_detail     < 1, 0, sub_3_1_desc, 6,,>
                func_detail     < 3, 0, sub_3_3_desc, 15,,>
                func_detail     < 4, 0, sub_3_4_desc, 9,,>
                func_detail     < 5, 0, sub_3_5_desc, 130,,>
                func_detail     < 6, 0, sub_3_6_desc, 5,,>
                func_detail     < 7, 0, sub_3_7_desc, 4,,>
                func_detail     < 8, 0, sub_3_8_desc, 5,,>
                func_detail     < 9, 0, sub_3_9_desc, 2,,>
                func_detail     <10, 0, sub_3_10_desc, 7,,>
                func_detail     <11, 0, sub_3_11_desc, 7,,>
                func_detail     <12, 0, sub_3_12_desc, 11,,>
                func_detail     <13, 0, sub_3_13_desc, 13,,>
                func_detail     <14, 0, sub_3_14_desc, 11,,>
                func_detail     <15, 0, sub_3_15_desc, 11,,>
                func_detail     <TABLE_TERM, 0, subuk_desc, 0,,>


cmd12_sub       func            <14, 0, NULL, cmd_12_det, FALSE>
cmd_12_det      func_detail     < 0, 0, sub_12_0_desc, 1,,>
                func_detail     < 1, 0, sub_12_1_desc, 2,,>
                func_detail     < 2, 0, sub_12_2_desc, 1,,>
                func_detail     < 3, 0, sub_12_3_desc, 9,,>
                func_detail     < 4, 0, sub_12_4_desc, 129,>
                func_detail     < 5, 0, sub_12_5_desc, 1,,>
                func_detail     <TABLE_TERM, 0, subuk_desc, 0,,>

;------end of cdlogdat.inc

