;---------------------------------------------------------------    
;Logdat.inc - data for device driver monitor                   |
;--------------------------------------------------------------|
;
                even
logr_stack      dw      128 dup('S')
logr_sp         label   word

;these 2 variables must remain together
old_stack_ptr   dw      ?  
old_stack_seg   dw      ?


max_blocks      dw      0
block_count     dw      0
sector_size     dw      1               ;default to char device xfer size
sector_count    dw      0               ;count of sectors to read/write
block_dev_flag  dw      FALSE           ;TRUE if block device
req_header      dd      ?
old_user_int    dd      ?               ;previous user int vector
drv_state       dw      0  
mdrv_req_ptr    dd      ?               ;request header ptr for 
                                        ;driver being monitored

mdrv_strat_ptr  dd      0
mdrv_int_ptr    dd      0
mdrv_ret_ptr    dd      0
save_patch      dw      0
patch_flag      db      FALSE
save_code       dw      0
user_data_ptr   dd      ?
user_data_size  dd      0
wrk_data_count  dd      0
wrk_data_ptr    dd      0

header_flag     db      FALSE

data_buf_text   db      'Data Buffer ', NULL
head_line       db      '         Driver '
head_drv_name   db      8 dup(' ')
HEAD_DRV_NLEN   EQU     $ - head_drv_name
                db      6 dup(' ')
head_dev_type   db      5 dup(' ')
head_dev_tlen   EQU     $ - head_dev_type
                db      ' device   loaded at '
head_load       db      10 dup(0)

drv_req_num     dw      0
block_text      db      'block',NULL
char_text       db      'char', NULL
entry_text      db      'Entry', NULL
exit_text       db      'Exit ', NULL
driv_req_text   db      ' - Driver request number ', NULL

config_dat      config_options  <OUT_SCREEN, TRUE, 10, TRUE, 10, INPUT_OUTPUT, \
                                 1, 0ffffh, FALSE, FALSE>    

log_it          db      TRUE            ;indicates if a request should be logged
hold_sub_det_ptr  dw      0             ;hold offset of subfunction detail table entry
func_req_ptr    dd     ?                ;ptr to function packet
io_table_ptr    dw      0               ;hold offset of io table info for command

stop_msg        db      '****Error - Press any key****', NULL        
cmd_com_text    db      'Command completion status - ',NULL
success_text    db      'Success', NULL
err_msg0        db      'Write protect violation', NULL
err_msg1        db      'Unknown unit', NULL
err_msg2        db      'Drive not ready', NULL
err_msg3        db      'Unknown command ', NULL
err_msg4        db      'CRC error ', NULL
err_msg5        db      'Bad drive request structure length ', NULL
err_msg6        db      'Seek error ', NULL
err_msg7        db      'Unknown Media ', NULL
err_msg8        db      'Sector not found ', NULL
err_msg9        db      'Printer out of paper ', NULL
err_msg10       db      'Write Fault ', NULL
err_msg11       db      'Read Fault ', NULL
err_msg12       db      'General failure ', NULL
err_msg13       db      'Reserved ', NULL
err_msg14       db      'Reserved ', NULL
err_msg15       db      'Invalid disk change ', NULL
err_msg16       db      '!!!weird message number!! ', NULL



err_msg_ptrs    label   word
                dw      err_msg0 
                dw      err_msg1 
                dw      err_msg2 
                dw      err_msg3 
                dw      err_msg4 
                dw      err_msg5 
                dw      err_msg6 
                dw      err_msg7 
                dw      err_msg8 
                dw      err_msg9 
                dw      err_msg10
                dw      err_msg11
                dw      err_msg12
                dw      err_msg13
                dw      err_msg14
                dw      err_msg15

                ifdef msc_flag
                        include cdlogdat.inc    ;includes for MSCDEX drivers
                else
                        include stlogdat.inc    ;includes for standard drivers
                endif

;------end of logdat.inc

