;---------------------------------------------------------------    
;Logstruc.inc - structures for device driver logger            |
;--------------------------------------------------------------|
;
dev_header      struc
dev_chain       dd      ?
dev_attrib      dw      ?
dev_strat       dw      ?
dev_int         dw      ?
dev_header      ends

req_hdr         struc
req_hdr_len     db      ?       ;length of request header
req_hdr_unit    db      ?       ;subunit - block devices only
req_hdr_cmd     db      ?       ;command code
req_hdr_status  dw      ?       ;status of command
req_hdr_reserv  db      8 dup(?) 
req_hdr         ends

cmd0_req        struc
cmd0_std_hdr    db      size req_hdr dup(?) ;13 byte standard header
cmd0_num_units  db      ?
cmd0_eadrs_off  dw      ?
cmd0_eadrs_seg  dw      ?
cmd0_bpb_ptr    dd      ?
cmd0_dev_num    db      ?
cmd0_req        ends

cmd2_req        struc
cmd2_std_hdr    db      size req_hdr dup(?) ;13 byte standard header
cmd2_media_des  db      ?
cmd2_buf_ptr    dd      ?
cmd2_bpb_ptr    dd      ?
cmd2_req        ends

ioctl_req       struc
ioctl_std_hdr   db      size req_hdr dup(?) ;13 byte standard header
ioctl_media_des db      ?
ioctl_buf_ptr   dd      ?
ioctl_count     dw      ?
ioctl_req       ends



ioctl_out_data  struc    
user_buf_ptr    dd      ?
user_buf_size   dd      ?
ioctl_out_data  ends     

ioctl_in_data   struc    
drv_buf_count   dd      ?
drv_config_dat  dw      ?
drv_cmd_tbl     dw      ?
ioctl_in_data   ends     

a_word          struc
w_lsb           db      ?
w_msb           db      ?
a_word          ends 


doub_word       struc   
d_offset        dw      ?
d_segment       dw      ?
doub_word       ends    


stack_area1     struc
mdrv_off        dw      ?
mdrv_seg        dw      ?
mdrv_flags      dw      ?
mdrv_ret_off    dw      ?
mdrv_ret_seg    dw      ?
stack_area1     ends 


config_options  struc
output_device   dw      ?       ;NULL device, printer, screen or memory (0-3)
show_buf_out    db      ?       ;TRUE if show output buffers
max_show_out    dw      ?       ;maximum output buffers to display
show_buf_in     db      ?       ;TRUE if show input buffers
max_show_in     dw      ?       ;maximum input buffers to display
show_cmd_blk    db      ?       ;show cmd req on entry, exit, or both (1-3)
log_start_num   dw      ?       ;sequence number at which to start logging
max_to_log      dw      ?       ;max requests to log
log_all         db      ?       ;TRUE if log all requests
wait_key_err    db      ?       ;TRUE if stop for key on error
config_options  ends

req_info        struc
ri_cmd_code     db      ?       ;command number
ri_descrip      dw      ?       ;offset to command description
ri_iotbl_ptr    dw      NULL    ;ptr to i/o info
ri_func_ptr     dw      NULL    ;ptr to function info
ri_log_flag     db      TRUE    ;default to logging request 
req_info        ends

func            struc
f_off_ptr      dw      ?       ;offset of function block ptr
f_off_cat_code dw      ?       ;offset that has category code
f_off_fun_code dw      ?       ;offset that has function code
f_detail_ptr   dw      ?       ;ptr to more table info
f_sub_in       db      ?       ;true if function in main block
func            ends

func_detail     struc
fd_cat_code     db      ?       ;category code
fd_fun_code     db      ?       ;function code
fd_descrip      dw      ?       ;offset to function description
fd_packet_len   db      ?       ;length of function request block
fd_iotbl_ptr    dw      NULL    ;ptr to i/o info
fd_log_flag     db      TRUE    ;default to logging request 
func_detail     ends

io_table        struc
io_buf_ptr_off  dw      ?       ;offset of i/o ptr from start cmd block
io_count        dw      ?       ;offset of word that contains count
io_type         db      ?       ;1 if input , 2 if output
io_bs_indic     db      ?       ;true if use block size from BPB
io_off_indic    dw      ?       ;offset of element that tells block size
io_table        ends

io_bs_elements  struc
io_bs_value     db      ?       ;value that tells block size
io_bs           dw      ?       ;size to use per value
io_bs_elements  ends



;------end of logstruc.inc
