#define WAVEDEMO

#include <conio.h>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <bios.h>
#include <dos.h>

typedef enum { FALSE, TRUE } tftype;
typedef enum { APPROX, DETAIL, INPUT, OUTPUT } signaltype;
typedef enum { DECOMP, RECON } wavetype;
typedef enum { NONE, HELP1, HELP2 } helptype;

#include "wavelet.h"
#include "wave_mgt.h"
#include "wavegrph.h"

void SignalFileIn(char *filename, int *length, int levels);
void SignalFileOut(char *filename, int length);
void CoeffFileIn(char *filename, int *length, int *levels,
																					double *alpha, double *beta);
void CoeffFileOut(char *filename, int signal_length, int levels,
																					double alpha, double beta);

double InData[317], OutData[317];
double alphaD, alphaR, betaD, betaR;
double g[6], gtilda[6], h[6], htilda[6];
double WaveCoeffD[6], WaveCoeffR[6];
double **ExCoeffD, **ExCoeffR;
int WaveLevels, DataLength, filtlenD, filtlenR;
char InSignalname[20], OutSignalname[20];
char InCoeffname[20], OutCoeffname[20];

void SignalFileIn(char *filename, int *length, int levels)
{
	int i, new_length, str_len;
	char buffer[15];
	FILE *in;

	str_len = GetGraphicInput(384, trow1, buffer, 14);
	if (str_len && ((in = fopen(buffer, "rt")) == NULL))
	{
		GraphMessage(328, trow7, "CANNOT OPEN THIS FILE         ");
		beep();
		delay(1000);
	}

	if (in && str_len)
	{
		i = 0;
		do  /* assign the new file to the input data */
		{
			filename[i] = buffer[i];
		} while (buffer[i++] != '\0');

		fscanf(in, "%d", &new_length); /* get number of data points */
		if (new_length != *length)  /* resize dynamic storage if necessary */
		{
			DestroyTreeStorage(ExCoeffR, levels);
			DestroyTreeStorage(ExCoeffD, levels);
			ExCoeffD = BuildTreeStorage(new_length, levels);
			ExCoeffR = BuildTreeStorage(new_length, levels);
			*length = new_length;
		}

		for (i = 0; i < *length; i++) /* load in the data points */
			fscanf(in, "%lf", &InData[i]);

		fclose(in);
		for (i = *length; i < 312; i++)
			InData[i] = 0.0;

	}
}


void SignalFileOut(char *filename, int length)
{
	int i, str_len;
	char buffer[15];
	FILE *out;

	str_len = GetGraphicInput(392, trow1, buffer, 14);
	if (str_len && ((out = fopen(buffer, "wt")) == NULL))
	{
		GraphMessage(328, trow7, "CANNOT OPEN THIS FILE         ");
		beep();
		delay(1000);
	}

	if (out && str_len)
	{
		i = 0;
		do /* assign the new file to the output data */
		{
			filename[i] = buffer[i];
		} while (buffer[i++] != '\0');

		fprintf(out, "%d\n", length); /* output number of data points */
		for (i = 0; i < length; i++)
			fprintf(out, "%20.14le\n", OutData[i]); /* output the data */

		fclose(out);
	}
}


void CoeffFileIn(char *filename, int *length, int *levels,
																					double *alpha, double *beta)
{
	int i, j, new_length, new_levels, str_len;
	char buffer[15];
	FILE *in;

	str_len = GetGraphicInput(384, trow3, buffer, 14);
	if (str_len && ((in = fopen(buffer, "rt")) == NULL))
	{
		GraphMessage(328, trow7, "CANNOT OPEN THIS FILE         ");
		beep();
		delay(1000);
	}

	if (in && str_len)
	{
		i = 0;
		do /* assign the new file to the input coefficients */
		{
			filename[i] = buffer[i];
		} while (buffer[i++] != '\0');

		 /* get length of transform and number of levels */
		fscanf(in, "%d   %d\n", &new_length, &new_levels);
		 /* resize dynamic storage if necessary */
		if ((new_length != *length) || (new_levels !=  *levels))
		{
			DestroyTreeStorage(ExCoeffR, *levels);
			DestroyTreeStorage(ExCoeffD, *levels);
			ExCoeffD = BuildTreeStorage(new_length, new_levels);
			ExCoeffR = BuildTreeStorage(new_length, new_levels);
			*length = new_length;
			*levels = new_levels;
		}

		fscanf(in, "%le %le", alpha, beta); /* load values of alpha and beta */

		for (i = 0; i < *levels; i++) /* load detail coefficients */
		{
			new_length = (*length >> (i + 1)) + 5;
			for (j = 0; j < new_length; j++)
				fscanf(in, "%le", &ExCoeffR[(2 * i) + 1][j]);
		}

		for (j = 0; j < new_length; j++) /* load approximation coefficients */
			fscanf(in, "%le", &ExCoeffR[2 * (*levels - 1)][j]);

		fclose(in);
	}
}


void CoeffFileOut(char *filename, int signal_length, int levels,
																					double alpha, double beta)
{
	int i, j, length, str_len;
	char buffer[15];
	FILE *out;

	str_len = GetGraphicInput(392, trow3, buffer, 14);
	if (str_len && ((out = fopen(buffer, "wt")) == NULL))
	{
		GraphMessage(328, trow7, "CANNOT OPEN THIS FILE         ");
		beep();
		delay(1000);
	}

	if (out && str_len)
	{
		i = 0;
		do /* assign the new file to the output coefficients */
		{
			filename[i] = buffer[i];
		} while (buffer[i++] != '\0');

			/* write length of transform and number of levels */
		fprintf(out, "%d   %d\n", signal_length, levels);
			/* write values of alpha and beta */
		fprintf(out, "%20.14le   %20.14le\n", alpha, beta);

		for (i = 0; i < levels; i++) /* write detail coefficients */
		{
			length = (signal_length >> (i + 1)) + 5;
			for (j = 0; j < length; j++)
				fprintf(out, "%20.14le\n", ExCoeffD[(2 * i) + 1][j]);
		}

		for (j = 0; j < length; j++) /* write approximation coefficients */
			fprintf(out, "%20.14le\n", ExCoeffD[2 * (levels - 1)][j]);

		fclose(out);
	}
}


void main(void)
{
	tftype quit;
	double temp, pi = 3.14159265358979323846;
	int i;
	char buffer[20];
	unsigned char str_len;

	union
	{
		char c[2];
		int i;
	} key;

	if (GraphSetup())
		exit(255);

	DataLength = 312;
	DispLength = DataLength;
	for (i = 0; i < DataLength; i++)
		InData[i] = sin(0.02 * pi * (double) i);

	TopResShown = 0;
	WaveLevels = 3;
	DispWaveLevels = WaveLevels;
	ExCoeffD = BuildTreeStorage(DataLength, WaveLevels);
	ExCoeffR = BuildTreeStorage(DataLength, WaveLevels);
	DispExCoeff = ExCoeffD;
	DispCoeffname = OutCoeffname;
	DispData = InData;
	DispSignalname = InSignalname;
	DispAlpha = &alphaD;
	DispBeta = &betaD;
	DispWaveCoeff = WaveCoeffD;
	WaveShown = DECOMP;
	HelpToggle = HELP1;
	WaveletCoeffs(alphaD, betaD, WaveCoeffD);
	filtlenD = MakeWaveletFilters(WaveCoeffD, htilda, gtilda, DECOMP);
	WaveletCoeffs(alphaR, betaR, WaveCoeffR);
	filtlenR = MakeWaveletFilters(WaveCoeffR, h, g, RECON);
	DrawViewedLevels();

	quit = FALSE;
	delay(0);

	do
	{
    	if (bioskey(1))
		{
			key.i = bioskey(0);
			if (!key.c[0])
			{
				switch (key.c[1])
				{
					case 0x48:	/* Up Arrow */
						if (ViewingData && (ViewStart > 0))
							ShowViewData(-1);
						else
							beep();

						break;
					case 0x49:	/* PGUP */
						if (!ViewingData && TopResShown)
							ScrollInLevel(--TopResShown, WaveLevels, 1);
						else if ((ViewingData == TRUE) && (ViewStart > 0))
							ShowViewData(-(viewlines - 1));
						else
							beep();

						break;
					case 0x50:	/* Dn Arrow */
						if (ViewingData && (ViewStart < (ViewLength - 1)))
							ShowViewData(1);
						else
							beep();

						break;
					case 0x51:	/* PGDN */
						if (!ViewingData && (TopResShown < WaveLevels))
							ScrollInLevel(3 + TopResShown++, WaveLevels, 0);
						else if ((ViewingData == TRUE)
							&& (ViewStart < (ViewLength - 1)))
							ShowViewData(viewlines - 1);
						else
							beep();

						break;
					case 0x3B:	/* F1 - HELP */
						if ((TopResShown == 0) && (HelpToggle != NONE) && !ViewingData)
						{
							HelpToggle = NONE;
							DrawPanel();
						}
						else if ((TopResShown == 0) && !HelpToggle && !ViewingData)
						{
							HelpToggle = HELP1;
							DrawPanel();
						}
						else
							beep();

						break;
					default:
						beep();
						delay(50);
						beep();
				}
			}
			else
			{
				switch (key.c[0])
				{
					case 0x1b:	/* ESC exit the program */
						if (ViewingData)
						{
							ExitViewData();
							DrawViewedLevels();
						}
						else
							quit = TRUE;

						break;
					case 'A': /* set value of alpha */
					case 'a':
						if ((TopResShown == 0) && !HelpToggle && !ViewingData)
						{
							str_len = GetGraphicInput(376, trow4, buffer, 15);
							temp = atof(buffer);
							if ((WaveShown == DECOMP) && str_len)
							{
								if ((temp >= -pi) && (temp <= pi))
								{
									alphaD = temp;
									WaveletCoeffs(alphaD, betaD, WaveCoeffD);
									filtlenD = MakeWaveletFilters(WaveCoeffD,
																			htilda, gtilda, DECOMP);
								}
								else
									beep();
							}
							else if (str_len)
							{
								if ((temp >= -pi) && (temp <= pi))
								{
									alphaR = temp;
									WaveletCoeffs(alphaR, betaR, WaveCoeffR);
									filtlenR = MakeWaveletFilters(WaveCoeffR, h, g, RECON);
								}
								else
									beep();
							}

							DrawPanel();
						}
						else
							beep();

						break;
					case 'B': /* set value of beta */
					case 'b':
						if ((TopResShown == 0) && !HelpToggle && !ViewingData)
						{
							str_len = GetGraphicInput(368, trow5, buffer, 15);
							temp = atof(buffer);
							if ((WaveShown == DECOMP) && str_len)
							{
								if ((temp >= -pi) && (temp <= pi))
								{
									betaD = temp;
									WaveletCoeffs(alphaD, betaD, WaveCoeffD);
									filtlenD = MakeWaveletFilters(WaveCoeffD,
																			htilda, gtilda, DECOMP);
								}
								else
									beep();
							}
							else if (str_len)
							{
								if ((temp >= -pi) && (temp <= pi))
								{
									betaR = temp;
									WaveletCoeffs(alphaR, betaR, WaveCoeffR);
									filtlenR = MakeWaveletFilters(WaveCoeffR, h, g, RECON);
								}
								else
									beep();
							}

							DrawPanel();
						}
						else
							beep();

						break;
					case 'C': /* copy expansion coefficients */
					case 'c':
						if (!HelpToggle && (WaveShown == DECOMP) && !ViewingData)
						{
							TreeCopy(ExCoeffD, ExCoeffR, DataLength, WaveLevels);
							DrawViewedLevels();
						}
						else if (!HelpToggle
							&& (WaveShown == RECON) && !ViewingData)
						{
							TreeCopy(ExCoeffR, ExCoeffD, DataLength, WaveLevels);
							DrawViewedLevels();
						}
						else
							beep();

						break;
					case 'E': /* execute displayed transform */
					case 'e':
						if (!HelpToggle && (WaveShown == DECOMP) && !ViewingData)
						{
							WaveletDecomposition(InData, DataLength, htilda,
													gtilda, filtlenD, WaveLevels, ExCoeffD);
							DispMSE = CalculateMSE(InData, OutData, DataLength);
							DrawViewedLevels();
						}
						else if (!HelpToggle
            	&& (WaveShown == RECON) && !ViewingData)
						{
							WaveletReconstruction(ExCoeffR, DataLength, h,
														g, filtlenR, WaveLevels, OutData);
							DispMSE = CalculateMSE(InData, OutData, DataLength);
							DrawViewedLevels();
						}
						else
							beep();

						break;
					case 'I': /* input signal read */
					case 'i':
						if (!HelpToggle && (TopResShown == 0)
								&& (WaveShown == DECOMP) && !ViewingData)
						{
							SignalFileIn(InSignalname, &DataLength, WaveLevels);
							DispLength = DataLength;
							DispExCoeff = ExCoeffD;
							DrawViewedLevels();
						}
					else
							beep();

						break;
					case 'L': /* set number of levels in transform */
					case 'l':
						if ((TopResShown == 0) && !HelpToggle && !ViewingData)
						{
							str_len = GetGraphicInput(384, trow6, buffer, 1);
							i = atoi(buffer);
							if ((i > 0) && (i < 7) && str_len)
							{
								DestroyTreeStorage(ExCoeffR, WaveLevels);
								DestroyTreeStorage(ExCoeffD, WaveLevels);
								WaveLevels = i;
								DispWaveLevels = WaveLevels;
								ExCoeffD = BuildTreeStorage(DataLength, WaveLevels);
								ExCoeffR = BuildTreeStorage(DataLength, WaveLevels);
								if (WaveShown == DECOMP)
									DispExCoeff = ExCoeffD;
								else
									DispExCoeff = ExCoeffR;
							}
							else
								beep();

							DrawViewedLevels();
						}
						else
							beep();

						break;
					case 'M': /* show more help */
					case 'm':
						if ((TopResShown == 0) && (HelpToggle == HELP1) && !ViewingData)
						{
							HelpToggle = HELP2;
							DrawPanel();
						}
						else if ((TopResShown == 0) && (HelpToggle == HELP2))
						{
							HelpToggle = HELP1;
							DrawPanel();
						}
						else
							beep();

						break;
					case 'O': /* output signal write */
					case 'o':
						if (!HelpToggle && (TopResShown == 0)
            	&& (WaveShown == RECON) && !ViewingData)
						{
							SignalFileOut(OutSignalname, DataLength);
							DrawPanel();
						}
						else
							beep();

						break;
					case 'P': /* prune selected levels of expansion coeffs from tree */
					case 'p':
						if (!HelpToggle && (TopResShown == 0)
            	&& (WaveShown == RECON) && !ViewingData)
						{
							GraphMessage(424, trow6, "ZERO DETAIL IN TOP   LEVELS");
							str_len = GetGraphicInput(550, trow6, buffer, 1);
							i = atoi(buffer);
							if ((i > 0) && (i <= WaveLevels) && str_len)
								ZeroTreeDetail(DispExCoeff, DataLength, i);

							DrawViewedLevels();
						}
						else
							beep();

						break;
					case 'R': /* read expansion coefficients */
					case 'r':
						if ((TopResShown == 0) && !HelpToggle
            	&& (WaveShown == RECON) && !ViewingData)
            {
							CoeffFileIn(InCoeffname, &DataLength, &WaveLevels,
																									&alphaR, &betaR);
							WaveletCoeffs(alphaR, betaR, WaveCoeffR);
							filtlenR = MakeWaveletFilters(WaveCoeffR, h, g, RECON);
							DispLength = DataLength;
							DispWaveLevels = WaveLevels;
							DispExCoeff = ExCoeffR;
							DrawViewedLevels();
						}
						else
							beep();

						break;
					case 'T':
					case 't':
						if (!ViewingData)
						{
							if (WaveShown == DECOMP)
							{
								DispData = OutData;
								DispSignalname = OutSignalname;
								DispAlpha = &alphaR;
								DispBeta = &betaR;
								DispWaveCoeff = WaveCoeffR;
								DispExCoeff = ExCoeffR;
								DispCoeffname = InCoeffname;
								WaveShown = RECON;
							}
							else
							{
								DispData = InData;
								DispSignalname = InSignalname;
								DispAlpha = &alphaD;
								DispBeta = &betaD;
								DispWaveCoeff = WaveCoeffD;
								DispExCoeff = ExCoeffD;
								DispCoeffname = OutCoeffname;
								WaveShown = DECOMP;
							}

							DrawViewedLevels();
						}
						else
							beep();

						break;
					case 'V': /* view the expansion coefficient */
					case 'v':
						if (!HelpToggle && !ViewingData)
						{
							InitViewData(InData, OutData, ExCoeffD, ExCoeffR);
							ShowViewData(0);
						}
						else
							beep();

						break;
					case 'W': /* write expansion coefficients */
					case 'w':
						if (!HelpToggle && (TopResShown == 0)
            	&& (WaveShown == DECOMP) && !ViewingData)
						{
							CoeffFileOut(OutCoeffname, DataLength, WaveLevels,
																											alphaD, betaD);
							DrawPanel();
						}
						else
							beep();

						break;
					case 'Z': /* zero expansion coefficients shown */
					case 'z':
						if (!HelpToggle && (WaveShown == DECOMP) && !ViewingData)
						{
							TreeZero(ExCoeffD, DataLength, WaveLevels);
							DrawViewedLevels();
						}
						else if (!HelpToggle && (WaveShown == RECON))
						{
							TreeZero(ExCoeffR, DataLength, WaveLevels);
							DrawViewedLevels();
						}
						else
							beep();

						break;
					default:
						beep();
						delay(50);
						beep();
				}
			}
		}
	} while (!quit);

	GraphExit();
}
