/* WAVEGRPH.H */

int GraphSetup(void);
void GraphExit(void);
int ScrollGraph(int displacement);
void DrawBarGraph(int left, int top, int right, int bot,
											double *data, int length, int barsize);
void DrawLevel(int left, int top, int right, int bot, double *data,
								int length, int res, int barsize, signaltype heading);
void DrawPanel(void);
void DrawViewedLevels(void);
void ScrollInLevel(int res, int maxlevels, int scrollup);
unsigned char GetGraphicInput(int left, int top, char *in_str, int length);
void GraphMessage(int left, int top, char *message_str);
void InitViewData(double *InData, double *OutData,
													double **ExCoeffD, double **ExCoeffR);
void ExitViewData(void);
void ShowViewData(int offset);
void beep(void);

#ifdef WAVEGRPH
tftype ViewingData;
wavetype WaveShown;
helptype HelpToggle;
double *DispAlpha, *DispBeta, *DispWaveCoeff;
double *DispData, **DispExCoeff, DispMSE;
int TopResShown, DispLength, DispWaveLevels, ViewStart;
int trow0, trow1, trow2, trow3, trow4;
int trow5, trow6, trow7, trow8, trow9;
int viewlines, ViewLength;
char *DispSignalname, *DispCoeffname;
#else
extern tftype ViewingData;
extern wavetype WaveShown;
extern helptype HelpToggle;
extern double *DispAlpha, *DispBeta, *DispWaveCoeff;
extern double *DispData, **DispExCoeff, DispMSE;
extern int TopResShown, DispLength, DispWaveLevels, ViewStart;
extern int trow0, trow1, trow2, trow3, trow4;
extern int trow5, trow6, trow7, trow8, trow9;
extern int viewlines, ViewLength;
extern char *DispSignalname, *DispCoeffname;
#endif
