; *************************************************************************************************
; *
; *	Title:	NETWORK.INC
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This is a header file for all the assembly language functions in the Novell network library
; *
; *************************************************************************************************

ifdef	LARGEMODEL
	.model	large,c
else
	.model	small,c
endif
	.286

; *************************************************************************************************
; *
; *					Definitions
; *
; *************************************************************************************************

IPX_FLAG	equ	(0 shl 0)	; Packet is used for IPX, see ecb_type field in ECB_S
SPX_FLAG	equ	(1 shl 0)	; Packet is used for SPX, this must be a 1
LISTEN_FLAG	equ	(0 shl 1)	; Packet is used for listening
TALK_FLAG	equ	(1 shl 1)	; Packet is used for talking, this must be a 1
FULL_FLAG	equ	(1 shl 2)	; Set if this packet has come back from listening with data

IPX_PACKET	equ	4		; Packet type for IPX
SPX_PACKET	equ	5		; Packet type for SPX

DEFAULT_TALKERS	equ	5	; Default number of talking packets for the IPX/SPX open functions
DEFAULT_LISTENERS	equ	5	; Default number of listening packets for the IPX/SPX open functions
DEFAULT_HANDLE_MAXIMUM	equ	20	; Maximum number of IPX/SPX handles


; *************************************************************************************************
; *
; *					Structures
; *
; *************************************************************************************************

NET_ADDRESS_S struct
	network	dd	?		; Network number
	node	db	6 dup(?)	; Physical node address
	socket	dw	?		; Socket number
NET_ADDRESS_S ends


IPX_S struct
	checksum	dw	?	; Dummy checksum of the 30-byte packet header, filled by IPX
	packet_length	dw	?	; Length of the complete IPX packet, filled by IPX
	control		db	?	; Transport control byte for internetwork bridges, filled by IPX
	packet_type	db	?	; Packet type: IPX=4, SPX=5, defined by Xerox, set by application	*
	dest_network	dd	?	; Network number, set by application					*
	dest_node	db	6 dup(?); Physical node address, set by application				*
	dest_socket	dw	?	; Socket number, set by application					*
	src_network	dd	?	; Network number
	src_node	db	6 dup(?); Physical node address
	src_socket	dw	?	; Socket number
IPX_S ends


SPX_S struct
	checksum	dw	?	; Dummy checksum of the 30-byte packet header, filled by IPX
	packet_length	dw	?	; Length of the complete IPX packet, filled by IPX
	control		db	?	; Transport control byte for internetwork bridges, filled by IPX
	packet_type	db	?	; Packet type: IPX=4, SPX=5, defined by Xerox, set by application	*
	dest_network	dd	?	; Network number, set by application					*
	dest_node	db	6 dup(?); Physical node address, set by application				*
	dest_socket	dw	?	; Socket number, set by application					*
	src_network	dd	?	; Network number
	src_node	db	6 dup(?); Physical node address
	src_socket	dw	?	; Socket number

	con_control	db	?	; Connection control structure, set by SPX
	datastream	db	?	; Datastream type, 0x00-0xFD are ignored, set by application		*
	src_ID		dw	?	; Source connection ID, used by SPX, filled by SPX
	dest_ID		dw	?	; Destination connection ID, used by SPX, filled by SPX
	sequence	dw	?	; Sequence number to keep track of the packet sequence, filled by SPX
	ACK_number	dw	?	; Acknowledge number, used by SPX, filled by SPX
	allocation	dw	?	; Allocation number, used by SPX, filled by SPX
SPX_S ends


ECB_HEADER_S struct
	next		dd	?	; Used by IPX/SPX when the ECB is active, can be used when ECB is inactive
	function	dd	0	; Called when packet sent/recd, called Event Service Routine, set by application	s,r
	in_use		db	?	; Flag used by IPX/SPX while it processes the ECB, !0 while in use, set by IPX/SPX
	completion_code	db	?	; Completion code that is valid only when in_use is set to 0, set by IPX/SPX
	socket		dw	?	; Transmission/reception socket to use for this ECB, set by application			s,r
	IPX_work	db	4 dup(?); Workspace used internally by IPX, set by IPX
	driver_work	db	12 dup(?); Workspace used internally by the IPX driver, set by IPX
	dest_address	db	6 dup(?); Address of the node to which the packet(s) is sent/received, set by application and IPX
	fragment_count	dw	?	; Number of address/size IPX/SPX fragments that follow, set by application		s,r
ECB_HEADER_S ends


FRAGMENT_S struct
	fragment_ptr	dd	?	; -> buffer that data is sent from or received into
	fragment_size	dw	?	; Size of that buffer
FRAGMENT_S ends


ECB_S struct	; This defines the structure of a single packet ECB, it contains both an ECB and an SPX structure
	next		dd	?	; Used by IPX/SPX when the ECB is active, used by this program when back from IPX/SPX
	function	dd	0	; Called when packet sent/recd, called Event Service Routine, set by application	s,r
	in_use		db	?	; Flag used by IPX/SPX while it processes the ECB, !0 while in use, set by IPX/SPX
	completion_code	db	?	; Completion code that is valid only when in_use is set to 0, set by IPX/SPX
	socket		dw	?	; Transmission/reception socket to use for this ECB, set by application			s,r
	IPX_work	db	4 dup(?); Workspace used internally by IPX, set by IPX
	driver_work	db	12 dup(?); Workspace used internally by the IPX driver, set by IPX
	dest_address	db	6 dup(?); Address of the node to which the packet(s) is sent/received, set by application and IPX
	fragment_count	dw	?	; Number of address/size IPX/SPX fragments that follow, set by application		s,r

	hdr		dd	?	; -> header for this transmission/reception descriptor, both IPX/SPX start the same	s,r
	size_hdr	dw	?	; Number of bytes in the header, must be set to IPX or SPX header size by application	s,r
	buffer_ptr	dd	?	; -> data to send/receive								s,r
	size_buffer	dw	?	; Must be set by application on transmission of the packet				s

	checksum	dw	?	; Dummy checksum of the 30-byte packet header, filled by IPX
	packet_length	dw	?	; Length of the complete IPX packet, filled by IPX
	control		db	?	; Transport control byte for internetwork bridges, filled by IPX
	packet_type	db	?	; Packet type: IPX=4, SPX=5, defined by Xerox, set by application	*
	dest_network	dd	?	; Network number, set by application					*
	dest_node	db	6 dup(?); Physical node address, set by application				*
	dest_socket	dw	?	; Socket number, set by application					*
	src_network	dd	?	; Network number of the source, filled by IPX/SPX
	src_node	db	6 dup(?); Physical node address of the source, filled by IPX/SPX
	src_socket	dw	?	; Socket number of the source, filled by IPX/SPX

	con_control	db	?	; Connection control structure, set by SPX
	datastream	db	?	; Datastream type, 0x00-0xFD are ignored, set by application		*
	src_ID		dw	?	; Source connection ID, used by SPX, filled by SPX
	dest_ID		dw	?	; Destination connection ID, used by SPX, filled by SPX
	sequence	dw	?	; Sequence number to keep track of the packet sequence, filled by SPX
	ACK_number	dw	?	; Acknowledge number, used by SPX, filled by SPX
	allocation	dw	?	; Allocation number, used by SPX, filled by SPX

	next_sibling	dw	?	; Segment of the next packet allocated to this socket
	parent		dw	?	; Segment of the LISTEN_S header that owns this packet
	user_function	dd	?	; Function to call after list management has occurred
	ecb_type	db	?,?	; Bit0:0 IPX,1 SPX;Bit1:0 listener;1 talker

	buffer		db	?	; Start of the buffer
ECB_S ends


LIST_S struct
	next			dw	0	; Segment of the next listening list
	socket			dw	0	; Socket number that this structure is associated with
	first_unprocessed_ECB	dw	0	; Segment of the first received block that has not been processed
	last_unprocessed_ECB	dw	0	; Segment of the last received block that has not been processed
	unprocessed_count	dw	0	; Number of unprocessed ECBs
	first_free_ECB		dw	0	; Segment of the first free packet that we can use for transmission
	free_count		dw	0	; Number of free ECBs
	first_allocated_ECB	dw	0	; -> first allocated packet associated with this list
	listener_count		dw	0	; Number of listeners attached to this socket
	talker_count		dw	0	; Number of talkers attached to this socket
	total_transmissions	dd	0	; Number of transmissions made through this socket
	total_receptions	dd	0	; Number of receptions made from this socket
LIST_S ends


HANDLE_S struct
	network		dd	?		; Network number, this MUST always be at the front
	node		db	6 dup(?)	; Physical node address, this MUST be second
	socket		dw	?		; Socket number, 0 if not open
	list_ptr	dw	?		; -> socket list header, points to next available when not in use
	partial_count	dw	?		; Total number of bytes read from the current unprocessed packet
HANDLE_S ends
HANDLE_SHIFT	equ	0			; Shift value to convert from index to a structure segment


; *************************************************************************************************
; *
; *					Macros
; *
; *************************************************************************************************

IPX	macro	command
	mov	bx, command
	push	bp
	call	dword ptr IPX_Vector	; Call the IPX function
	pop	bp
	endm


IPX_CHECK macro command
	mov	bx, command
	push	bp
	call	dword ptr IPX_Vector	; Call the IPX function
	pop	bp
	cbw
	or	ax, ax			; Check the return code in AL
	endm


; *************************************************************************************************
; *
; *					External Definitions
; *
; *************************************************************************************************

ifndef _XPX_INIT_ASM_

extern	IPX_Vector:dword, _Our_Address:dword
extern	_Socket_Life:byte, _SPX_Version:word, _SPX_Max_Connections:word, _SPX_Available_Connections:word

endif
