; *************************************************************************************************
; *
; *	Title:	XPX_INIT.ASM
; *	Copyright (c) December 1991, Ryu Consulting, 916/722-1939
; *	Written by Rahner James
; *
; *	This file contains all the functions to support initializing the IPX engine
; *
; *************************************************************************************************

_XPX_INIT_ASM_	equ	1

	include network.inc

.data

	public	IPX_Vector, _Socket_Life, _SPX_Version, _SPX_Max_Connections, _Our_Address
	public	_SPX_Available_Connections, _SPX_Retry_Count

IPX_Vector	dw	offset dummy_IPX_function,@Code	; -> IPX support function
_Socket_Life			db	0		; 0   = socket closed at termination of application
							; 0ffh= socket closed only when explicitly requested
_SPX_Version			dw	0		; SPX version number, MSByte=major, LSByte=minor
_SPX_Max_Connections		dw	0		; Maximum number of SPX connections
_SPX_Available_Connections	dw	0		; Number of SPX connections that are available to the application
_SPX_Retry_Count		db	0		; Retry count for SPX establish connection
_SPX_Bowser_Flag		db	1		; Watchdog flag, 0=disable, 1=enable
_Our_Address label dword				; Global access for this structure
network			dd	0		; Network address
node				db	6 dup(0)	; Node address
socket				dw	0		; Socket number


.code
; *************************************************************************************************
; *
; *	int XPX_INIT( us SOCKET_NUMBER )
; *	Initializes all IPX/SPX internals
; *
; *	Given:
; *		SOCKET_NUMBER = socket number to open for listening, 0 opens the next available
; *
; *	Returns:
; *		0 if IPX was initialized successfully
; *		-1 = socket already open (!)
; *		-2 = socket table full
; *		-3 = IPX or SPX is not installed
; *
; *	Note:
; *		This initializes the IPX vector and opens a listening socket for the IPX driver
; *		All internal vectors, counter and pointers are brought to initial conditions
; *
; *************************************************************************************************
xpx_init proc uses di si, socket_number:word

	mov	ax, 7a00h		; Get the IPX vector
	int	2fh			; Query the DOS multiplexer
	inc	al			; AL = 0ffh if IPX is there
	jnz	derr_xpx_init		; Quit in disgrace if it's not there

	mov	IPX_Vector, di		; IPX function vector returned in ES:DI if call was successful
	mov	IPX_Vector+2, es

; *
; * See if we need to close the old stuff down
; *
	mov	dx, socket
	or	dx, dx			; See if we opened a socket
	jz	xpx10_init		; Skip if we didn't

	cmp	socket_number, 0	; See if bwana just wants anything (s)he can get
	jz	xpx20_init		; Skip if so
	cmp	socket_number, dx	; See if it's the same as before
	je	xpx20_init		; Skip if it is

	IPX	1			; IPX Close Socket command

; *
; * Now, open the socket bwana wants us to
; *
xpx10_init:
	mov	dx, socket_number
	mov	al, _Socket_Life
	IPX_CHECK	0		; IPX Open Socket command
	jnz	done_xpx_init		; Quit if an error

xpx20_init:
	mov	socket, dx

; *
; * Get our internetwork address
; *
	mov	ax, ds			; ES = DS
	mov	es, ax
	mov	si, offset network
	mov	di, si
	IPX	9			; IPX Get Internetwork Address command

; *
; * Last, we have to initialize the SPX interface
; *
	xor	ax, ax
	IPX_CHECK	10h		; SPX Initialize command
	jz	derr_xpx_init		; Quit if it's not there

	mov	_SPX_Version, bx	; Save the information returned
	mov	_SPX_Max_Connections, cx
	mov	_SPX_Available_Connections, dx
	xor	ax, ax			; Good return
	jmp	short done_xpx_init

derr_xpx_init:
	mov	al, -3			; It's gone McCreedy!
done_xpx_init:
	cbw
	ret
xpx_init endp


; *************************************************************************************************
; *
; *	int DUMMY_IPX_FUNCTION( void )
; *	Dummy function that returns error code -10 so that system will not hang if not initialized
; *
; *	Given:
; *		nothing
; *
; *	Returns:
; *		-10 always
; *
; *************************************************************************************************
dummy_IPX_function proc far
	mov	ax, -10
	ret
dummy_IPX_function endp

	end

