/**************************************************************************************************
*
*		Title:	XPX_READ.C
*		Copyright (c) January 1992, Ryu Consulting, 916/722-1939
*		Written by Rahner James
*
*		This file contains all the functions that support reading IPX packets
*
**************************************************************************************************/

#define	_XPX_READ_C_
#include	<dos.h>
#include	<malloc.h>
#include	<stdlib.h>
#include	<time.h>
#include	"network.h"


/**************************************************************************************************
*
*	int XPX_READ( XPX_STREAM_T far *SP, void far *BP, int COUNT )
*	Reads the next packet from the unread queue
*
*	Given:
*		SP -> packet stream to check
*		BP -> buffer to place the packet into
*		COUNT = size of the buffer that this packet will be moved into
*
*	Returns:
*		Number of bytes placed in the destination buffer, only a partial packet will
*		be read if there is not enough room to place it into the destination buffer
*		Negative number indicates an error condition
*
**************************************************************************************************/
int xpx_read( XPX_STREAM_T far *sp, void far *bp, int count )
{
	int	rv;
	SPX_PACKET_T	far *pp;

#ifdef DEBUG_MODE
	if ( (sp=find_stream(&sp->dest)) == NULL )
		return ERR_NOT_OPEN;
#endif

	if ( sp->unread_count == 0 )
		return 0;

/*
** Move the packet into the destination buffer
*/
	_disable();
	pp = sp->first_unread;
	farmove( bp, pp->buffer_ptr, rv = count < pp->length ? count : pp->length );

/*
** Check if that was a full packet
*/
	if ( (pp->length -= rv) == 0 )
	{

/*
** If the packet is now empty, update count, pull it from the list and send it back to listening
*/
		--sp->unread_count;
		if ( (sp->first_unread = pp->next_sibling) == NULL )
			sp->last_unread = NULL;
		pp->buffer_ptr = pp->default_buffer;
		pp->buffer_size = pp->default_size;
		((sp->open_flags & XPX_SPX)?spx_add_listener:ipx_add_listener)( (ECB_HEADER_T far *)pp );
	}

/*
** Return with the number of bytes we read
*/
	_enable();
	return rv;
}
