/**************************************************************************************************
*
*		Title:	XPX_WRITE.C
*		Copyright (c) January 1992, Ryu Consulting, 916/722-1939
*		Written by Rahner James
*
*		This file contains all the functions that support writing IPX packets
*
**************************************************************************************************/

#define	_XPX_WRITE_C_
#include	<dos.h>
#include	<malloc.h>
#include	<stdlib.h>
#include	<time.h>
#include	"network.h"


/**************************************************************************************************
*
*	int XPX_WRITE( XPX_STREAM_T far *SP, void far *BP, int COUNT, char far *DONE_FLAG )
*	Packetizes and writes a number of bytes using IPX or SPX
*
*	Given:
*		SP -> packet stream to write through
*		BP -> buffer that contains the data to write
*		COUNT = total number of bytes to write
*		DONE_FLAG -> byte that is set with a completion code when last packet has transmitted
*
*	Returns:
*		Number of bytes that could be sent without a significant delay;
*		otherwise a negative error code
*
**************************************************************************************************/
int xpx_write( XPX_STREAM_T far *sp, void far *bp, int count, char far *done_flag )
{
	int	rv=0, i;
	SPX_PACKET_T	far *pp;
	int packet_size;

#ifdef DEBUG_MODE
	if ( (sp=find_stream(&sp->dest)) == NULL )
		return ERR_NOT_OPEN;
#endif
	if ( sp->total_talkers == 0 )
		return ERR_NO_SUPPORT;

/*
** Check for special case of SPX establish connection
*/
	if ( (sp->open_flags & XPX_SPX) && (count == 0) )
	{
		_disable();
		pp = sp->first_free;
		sp->first_free = pp->next_sibling;
		--sp->free_count;
		_enable();
		pp->fragment_count = 1;
		pp->done_flag = done_flag;
		if ( (rv=spx_establish_connection((ECB_HEADER_T far *)pp,&sp->connection_ID)) != 0 )
		{
			_disable();
			pp->next_sibling = sp->first_free;
			sp->first_free = pp;
			++sp->free_count;
			_enable();
		}
		return rv;
	}

/*
** Setup for normal communications
*/
	if ( _Asynch_Flag && (done_flag == NULL) )
		return ERR_NO_NULLS;

/*
** Loop through the available talking packets until they are used up
*/
	packet_size = (sp->open_flags & XPX_SPX) ? sizeof(SPX_T) : sizeof(IPX_T);
	while ( sp->free_count && count )
	{

/*
** Take the next free packet away from its current list
*/
		_disable();
		pp = sp->first_free;
		sp->first_free = pp->next_sibling;
		--sp->free_count;
		_enable();

/*
** Setup the buffer pointers, flags, counts and buffers
*/
		pp->fragment_count = 2;
		if ( (pp->done_flag = done_flag) != NULL )
		{
			pp->buffer_size = count > MAX_PACKET_SIZE-packet_size ? MAX_PACKET_SIZE-packet_size : count;
			pp->buffer_ptr = bp;
			*done_flag = IU_PROCESSING;
		}
		else
		{
			farmove( pp->buffer_ptr=pp->default_buffer, bp, pp->buffer_size = count>pp->default_size ? pp->default_size : count );
		}
		if ( (count -= pp->buffer_size) > 0 )
			pp->done_flag = NULL;
		rv += pp->buffer_size;

/*
** Now, shoot this puppy out
*/
		ipx_send_packet( (ECB_HEADER_T far *)pp );
	}

/*
** Return the number of bytes "written" to the caller
*/
	return rv;
}

