#--------------------------------------------------------------------------
#	Make file for: AvkCapt - Windows sample capture program. 
#
# Copyright Intel Corp. 1991, 1992
# All Rights Reserved.
#
#--------------------------------------------------------------------------

TARGET=AvkCapt

#DEBSYM=Y

#--------------------------------------------------------------------------
#	libraries
#--------------------------------------------------------------------------

AVKLIB=KMVLWL.LIB AVKIOWM.LIB
MSCLIB=MLIBCEW.LIB
WINLIB=LIBW.LIB

LIBS=$(MSCLIB) $(AVKLIB) $(WINLIB)

COMMON=..\common\ 

#--------------------------------------------------------------------------
#	Source Files
#--------------------------------------------------------------------------

#	c source files (lower case only)

CFILES=acmain.c acavk.c acrect.c accapt.c \
disperr.c memalloc.c log.c copylist.c

#	assembly source file (lower case only)

AFILES=

#	object modules

OBJS=$(CFILES:.c=.obj) $(AFILES:.asm=.obj)

#--------------------------------------------------------------------------
# Compiler and Linker flags for production and debug versions
#--------------------------------------------------------------------------

CFLAGS=-c -AM -Zip -Gsw -W3 -D_WINDOWS -nologo -I..\common
LFLAGS=/ALIGN:16 /MAP /NOD /NOE

!IF "$(DEBSYM)" == "Y"
COMPILEFLAGS=$(CFLAGS) -Od
LINKFLAGS=$(LFLAGS) /CO
!ELSE
COMPILEFLAGS=-Oxw $(CFLAGS)
LINKFLAGS=$(LFLAGS)
!ENDIF

#--------------------------------------------------------------------------
#	link commands
#--------------------------------------------------------------------------

$(TARGET): $(TARGET).exe
#$(TARGET).EXE: $(OBJS) $(TARGET).def $(TARGET).res
$(TARGET).EXE: $(OBJS) $(TARGET).def $(TARGET).res
	LINK $(LINKFLAGS) @<<response.lnk
$(OBJS),
$*,
$*,
$(LIBS),
$(TARGET).def
<<KEEP
	rc $(TARGET).res

#--------------------------------------------------------------------------
# dependencies
#--------------------------------------------------------------------------

avkcapt.res: 	avkcapt.rc avkcapt.h 
	rc -r -I..\common avkcapt.rc

acmain.obj: 	acmain.c avkcapt.h $(COMMON)log.h
	cl $(COMPILEFLAGS) acmain.c

acavk.obj:		acavk.c avkcapt.h $(COMMON)disperr.h $(COMMON)memalloc.h \
		$(COMMON)log.h $(COMMON)copylist.h
	cl $(COMPILEFLAGS) acavk.c

acrect.obj:		acrect.c avkcapt.h
	cl $(COMPILEFLAGS) acrect.c

accapt.obj:		accapt.c avkcapt.h
	cl $(COMPILEFLAGS) accapt.c

disperr.obj:	$(COMMON)disperr.c $(COMMON)bitflags.h
	cl $(COMPILEFLAGS) $(COMMON)disperr.c

memalloc.obj:	$(COMMON)memalloc.c
	cl $(COMPILEFLAGS) $(COMMON)memalloc.c

log.obj:		$(COMMON)log.c $(COMMON)memalloc.h
	cl $(COMPILEFLAGS) $(COMMON)log.c

copylist.obj:	$(COMMON)copylist.c $(COMMON)copylist.h
	cl $(COMPILEFLAGS) $(COMMON)copylist.c

