/****************************************************************************

    FILE   : Viewer.h

    PURPOSE: header file for graphic viewer

 1992, Evangelo Prodromou.  All rights reserved.
****************************************************************************/

/* Viewer Menu item definitions */

#define IDM_ABOUT       100
#define IDC_STATIC      -1

/*  general-use string size. */

#define STRINGSIZE 511

/* The following definitions are data types defined by the Aldus
** Interface. */

typedef DWORD FILETYPE;

typedef struct {
   unsigned    slippery : 1;        /* TRUE if file may disappear. */
   unsigned    write : 1;           /* TRUE if open for write. */
   unsigned    unnamed : 1;         /* TRUE if unnamed. */
   unsigned    linked : 1;          /* Linked to an FS FCB. */
   unsigned    mark : 1;            /* Generic mark bit. */
   FILETYPE    fType;               /* The file type. */
#define IBMFNSIZE 124
   short       handle;              /* MS-DOS open file handle. */
   char        fullName[IBMFNSIZE]; /* Device, path, file names. */
   DWORD       filePos;          /* Our current file posn. */
} FILESPEC, FAR *LPFILESPEC;

typedef short DC;

typedef struct {        /* --- PICTINFO for Windows --- */
  HANDLE        hmf;    /* Global memory handle to the metafile */
  RECT          bbox;   /* Tightly bounding rectangle in metafile units */
  DC            inch;   /* Length of an inch in metafile units */
} PICTINFO, FAR* LPPICTINFO;


/* The following types are pointers to functions with the same arguments
** as those found in an Aldus-standard function.  They are necessary to
** make anonymous function calls. */

/* Version 1.0 filter functions */

typedef WORD (FAR PASCAL *PFN_INFO)   (short, LPSTR, HANDLE FAR*, HANDLE FAR*);
typedef WORD (FAR PASCAL *PFN_IMPORT) (HDC, LPFILESPEC, LPPICTINFO, HANDLE);
typedef void (FAR PASCAL *PFN_PREF)   (HANDLE, HWND, HANDLE, WORD);

/* Version 2.0 filter functions */

typedef WORD (FAR PASCAL *PFN_VER)    (DWORD, BOOL FAR *, WORD FAR *, WORD FAR *);
typedef WORD (FAR PASCAL *PFN_ISMY)   (LPFILESPEC);
typedef WORD (FAR PASCAL *PFN_PREF2)  (HANDLE, HANDLE, HANDLE FAR *, DWORD, FARPROC, LPFILESPEC);
typedef WORD (FAR PASCAL *PFN_OUTPUT) (HDC, HDC, LPFILESPEC, LPSTR, LPPICTINFO, HANDLE, FARPROC, BOOL);

/* The following are function declarations for functions local to 
** this application. */

int PASCAL WinMain( HANDLE, HANDLE, LPSTR, int );
long FAR PASCAL MainWndProc( HWND, unsigned, WORD, LONG );
BOOL FAR PASCAL AboutDlgProc( HWND, unsigned, WORD, LONG );
BOOL NEAR ImportFile( HWND );
BOOL NEAR GetExtFilter( void );
HDC NEAR GetPrinterIC( void );
