/* ---------- tsrbuild.c --------- */

/*
 * A builder of swapped TSR programs
 */

#include <dos.h>
#include "tsr.h"

static struct swap_header swap;
static unsigned TsrSS, TsrSP, psp;
static unsigned myss, mysp;
static char far *mydta;
static char far *dta;

void InitPopup(void);
void TSRPopup(void);
void CommandLinePopup(void);
void LoadPopup(void);

void main(int argc, char *argv[])
{
	InitPopup();
	if (!tsrplus_loaded())
		CommandLinePopup();
	else
		LoadPopup();
}

static void setpsp(unsigned psp)
{
	_BX = psp;
	_AH = 0x50;
	geninterrupt(DOS);
}

static unsigned getpsp(void)
{
	_AH = 0x51;
	geninterrupt(DOS);
	return _BX;
}

/* ---------------- ENTER THE TSR FROM TSRPLUS ------------------- */
void interrupt start_tsr(IREGS ir)
{
	TsrSS = _SS;	/* Save the current ss:sp  */
	TsrSP = _SP;

	disable();			/* no interrupts now					*/
	_SS = myss;			/* Set the TSR's SS and SP from values	*/
	_SP = mysp;			/* that were remembered at registration */
	enable();

	dta = getdta();		/* switch DTA and PSP contexts 			*/
	setdta(mydta);
	psp = getpsp();
	setpsp(_psp);

	TSRPopup();			/* execute the TSR 						*/

	setdta(dta);		/* restore DTA and PSP contexts 		*/
	setpsp(psp);

	disable();			/* no interrupts now					*/
	_SS = TsrSS;		/* restore the TSRPLUS stack			*/
	_SP = TsrSP;
	enable();
}

/* ------- Register a TSR Application Program ------- */
int registertsr(unsigned char Keymask, unsigned char Scancode)
{
	if (_osmajor < 3)
		return -1;
	mydta = getdta();

	/* ------ save the TSR's stack for later when it pops up ------- */
	myss = _SS;
	mysp = _SP;

	/* -------- build the TSRPLUS registration structure ---------- */
	swap.startptr = (void interrupt(*)(void))start_tsr;
	swap.psp = _psp;
	swap.Keymask = Keymask;
	swap.Scancode = Scancode;

	/* ------------- call TSRPLUS to register -------------- */
	_ES = _DS;
	_BX = (unsigned) &swap;
	_AX = PLUSIDENT | REGISTER;
	geninterrupt(TSRPLUSINT);
	if ((int)_AX != -1)
		return 0;
	return -1;
}

/* ------- test TSRPLUS loaded into memory ------- */
BOOL tsrplus_loaded(void)
{
	_AX = PLUSIDENT | ISLOADED;
	geninterrupt(TSRPLUSINT);
	return _AL == 0xff;
}

/* -------- unload TSRPLUS from memory --------- */
void unload_tsrplus(void)
{
	if (tsrplus_loaded())	{
		_AX = PLUSIDENT | UNLOAD;
		geninterrupt(TSRPLUSINT);
	}
}

