;dbdbreg.asm 
;Debugger debug register handling routines
;
.386P
;---------------------------------------------------------------------------- 
;Copyright 1991, 1992 ASMicro Co. 
;7/6/91	   Rick Knoblaugh
;-----------------------------------------------------------------------------
                include dbequ.inc
                include dbstruc.inc

data            segment para public 'data16' use16
                extrn   bp_reg_dat:byte
                extrn   trace_count:word
                extrn   num_io_bp:byte
                extrn   write_text:byte
                extrn   WRITE_LEN:abs
                extrn   rw_text:byte
                extrn   RW_LEN:abs
                extrn   bp_reg_dat:byte
                extrn   num_reg_type:byte
                extrn   io_bpdat:byte
                extrn   io_instrucf:byte
data            ends

zcode    segment para public 'code16' use16

                extrn   set_trap:near
                extrn   format_seg:near
                extrn   uflags:word

                public  tmp_disable_bp, tmp_disable_all, reset_tmp_dis
                public  ck_exec_bp, tmp_disable_io, reset_tmp_io 

	assume cs:zcode, ds:data, es:nothing


ck_exec_bp      proc    near
                mov     ch, 3                   ;get status reg function
                int     60h                     ;let PL0 code read it
                mov     si, ax                  ;save status
                shr     ax, 1                   ;only care about 1-3
                and     al, 7                   ;any "break points"?
                jz      short ck_exec550        ;if not, go look for Go
                mov     dl, 1
                mov     cx, 3                   ;dr1 through dr3
                mov     bx, offset bp_reg_dat
ck_exec100:
                test    al, dl                  ;this one cause break?
                jz      short ck_exec500        ;if not, try next one
                cmp     [bx].info_bptype, DEB_TYPE_EXEC ;an exec type?
                jne     short ck_exec500
;Determine if this break point is truely active (an old condition 
;could still cause processor to set bits in DR6 even though it may not
;be enabled).
;
                cmp     [bx].info_bpstat, AVAIL ;is break point enabled?
                je      short ck_exec500        ;if not, try next one

                cmp     trace_count, 1          ;already tracing?
                jae     short ck_exec300

                bt      cs:uflags, trapf        ;tracing in user debugger?
                jc      ck_exec400              ;if so, exit
ck_exec300:
                call    tmp_disable_all
                cmp     trace_count, 1          ;already tracing?
                jae     short ck_exec900

                call    set_trap                ;set trap flag
                mov     trace_count, 1          ;trace once only
ck_exec400:
                stc
                ret
ck_exec500:
                add     bx, size info_bpreg 
                shl     dl, 1                   ;check next one
                loop    ck_exec100
ck_exec550:
                shr     si, 1                   ;get bit 0 of saved status
                jnc     short ck_exec900        ;if DR0 didn't cause break
ck_exec600:
                cmp     trace_count, 1          ;already tracing?
                jae     short ck_exec900
                bt      cs:uflags, trapf        ;user debugger tracing?
                jnc     short ck_exec900
;disable DR0 Go break point because we're already here within user debugger
                xor     cx, cx                  ;ch=0 (clear brk ) cl=0 (DR0)
                xor     ax, ax                  ;no additional bits to clear
                int     60h                     ;"do_debug_reg" routine
                jmp     short ck_exec400        ;in user debugger, so exit
ck_exec900:
                clc
ck_exec999:
                ret
ck_exec_bp      endp


;----------------------------------------------------------------------
; tmp_disable_bp -  temporarily disable a debug register break point. |
;                   Flag the appropriate table entry as such and      |
;                   disable the break point via DR7.                  |
;                                                                     |
;             Enter: bx = offset of table entry                       |
;                    al = 1 through 3                                 |
;                                                                     |
;              Exit: break point diabled.                             |
;                                                                     |
;        All registers saved.                                         |
;----------------------------------------------------------------------
tmp_disable_bp  proc    near
                push    ax
                push    bx
                push    cx
                push    dx              ;must save
                or      [bx].info_bpstat, DEB_TEMP_DISAB
                sub     ch, ch          ;indicate disable in DR7
                mov     cl, al          ;debug register number
                xor     ax, ax          ;no other bits to clear
                int     60h             ;do_debug_reg              
                pop     dx
                pop     cx
                pop     bx
                pop     ax
                ret
tmp_disable_bp  endp

;----------------------------------------------------------------------
; tmp_disable_all - temporarily disable all break points which use    |
;                   debug registers.                                  |
;                                                                     |
;        No registers saved.                                          |
;----------------------------------------------------------------------
tmp_disable_all proc    near
;
;First, disable DR0 which is used for Go break points
                xor     cx, cx                  ;ch=0 (clear brk ) cl=0 (DR0)
                xor     ax, ax                  ;no additional bits to clear
                int     60h                     ;"do_debug_reg" routine
;
;Next, look for and disable any other debug register type break points.
;
                mov     bx, offset bp_reg_dat
                mov     dl, num_reg_type ;number of debug register brk points
                or      dl, dl
                jz      short tmp_da_999 ;exit if none active
                mov     al, 1            ;else start with DR1
tmp_da_100:
                cmp     [bx].info_bpstat, AVAIL ;is it set?
                je      short tmp_da_300 ;if not, try next one

                call    tmp_disable_bp
                dec     dl              ;number left to check
tmp_da_300:
                add     bx, size info_bpreg ;next table entry                       
                inc     al              ;next debug register
                or      dl, dl          ;check all?
                jnz     short tmp_da_100                

tmp_da_999:
                ret
tmp_disable_all endp        

;----------------------------------------------------------------------
; tmp_disable_io - temporarily disable all I/O type break points.     |
;                                                                     |
;        No registers saved.                                          |
;----------------------------------------------------------------------
tmp_disable_io  proc    near
                sub     ch, ch
                mov     cl, num_io_bp   ;number of I/O type break points
                jcxz    tmp_di_999      ;if none, exit

                mov     bx, offset io_bpdat
                jmp     short tmp_di_200
tmp_di_100:
                add     bx, size info_io  ;advance to next entry
tmp_di_200:
                cmp     [bx].io_stat, AVAIL   ;is this one defined?
                je      short tmp_di_100      ;if not, check next one
                or      [bx].io_stat, DEB_TEMP_DISAB
                push    cx                      ;save number I/O break points
                mov     dx, [bx].io_port        ;get port address
                sub     ah, ah                  ;clear bit
                mov     cx, 1                   ;one bit
                int     61h                     ;do_bit_map
                pop     cx              ;restore number of I/O break points

                loop    tmp_di_100  
tmp_di_999:
                ret
tmp_disable_io  endp        

reset_tmp_dis   proc    near
                mov     dl, num_reg_type ;number of debug register bps
                or      dl, dl
                jz      short reset_tmp_999  ;exit if none active
                mov     bx, offset bp_reg_dat
                mov     cx, 101h        ;else start with DR1 (also ch=1)
reset_tmp_100:
                test    [bx].info_bpstat, DEB_TEMP_DISAB ;is it temp disabled?
                jz      short reset_tmp_300 ;if not, try next one
                and     [bx].info_bpstat, NOT DEB_TEMP_DISAB
                mov     al, '*'         ;keep existing address etc.
;Note:  ch=1 indicating set, cl=DRn number
                push    bx
                push    cx
                push    dx
                int     60h             ;do_debug_reg              
                pop     dx
                pop     cx
                pop     bx
                dec     dl              ;number left to check
reset_tmp_300:
                add     bx, size info_bpreg ;next table entry                       
                inc     cl              ;next debug register
                or      dl, dl          ;any remaining break points?
                jnz     short reset_tmp_100                

reset_tmp_999:
                ret
reset_tmp_dis   endp



reset_tmp_io    proc    near
;
;Reactivate any I/O break points that were temporarily disabled.  
;
                movzx   cx, num_io_bp   ;number of I/O type break points
                jcxz    reset_tmpio_999   ;exit if none 
                mov     bx, offset io_bpdat
                jmp     short reset_tmpio_200
reset_tmpio_100:
                add     bx, size info_io
reset_tmpio_200:
                cmp     [bx].io_stat, AVAIL     ;is this one defined?
                je      short reset_tmpio_100     ;if not, try next one
                and     [bx].io_stat, NOT DEB_TEMP_DISAB

                push    cx                      ;save number I/O break points
                mov     dx, [bx].io_port        ;get port address
                mov     ah, 1                   ;set bit
                mov     cx, 1                   ;one bit
                int     61h                     ;do_bit_map
                pop     cx              ;restore number of I/O break points

                loop    reset_tmpio_100  

reset_tmpio_999:
                ret
reset_tmp_io    endp




disp_deb_reg    proc    near
                push    ax
                push    bx
                mov     bx, [bx].brk_off        ;offset of detailed debug info
                mov     si, [bx].info_bpcmd     ;offset of data for this cmd
                movzx   cx, [si].cmd_len 
                mov     si, [si].cmd_text
disp_deb100:
                movsb
                inc     di              ;past attribute
                loop    disp_deb100
                add     di, 2           ;skip a space
                push    ds
                lds     si, dword ptr [bx].info_bpoff ;get address
                call    format_seg      ;go display it
                add     di, 2           ;skip a space
                pop     ds
;
;Next, if break point is for data accesses, print a description of
;the type of access (i.e. "W" or "RW")
;
                mov     si, offset write_text ;default to write
                mov     cx, WRITE_LEN
                mov     dl, [bx].info_bptype 
                cmp     dl, DEB_TYPE_WRITE 
                jb      short disp_deb900 ;if execution type, no direction
                je      short disp_deb500
                mov     si, offset rw_text ;r/w description
                mov     cx, RW_LEN

disp_deb500:
                movsb
                inc     di
                loop    disp_deb500
disp_deb900:
                pop     bx
                pop     ax
                ret
disp_deb_reg    endp

zcode            ends
        	end          

