;dbsupt.asm 
;Miscellaneous support routines for debugger 
;
.386P
;---------------------------------------------------------------------------- 
;Copyright 1991, 1992 ASMicro Co. 
;7/6/91	   Rick Knoblaugh
;-----------------------------------------------------------------------------
                include dbequ.inc
                include dbstruc.inc

data            segment para public 'data16' use16
data            ends

zcode    segment para public 'code16' use16

                public  convert_upper, convert_2_linear, must_be_hex     
                public  format_seg, put_hex_byte, put_nibble, get_validate               
                public  hex2bin, skip_white_sp, put_hex_word

	assume cs:zcode, ds:data, es:nothing


;----------------------------------------------------------------------
; convert_upper - convert string to upper case.                       |
;                                                                     |
;             Enter: si = offset of start of string                   |
;                    cx = string length                               |
;                                                                     |
;        All registers saved.                                         |
;----------------------------------------------------------------------
convert_upper   proc    near
                jcxz    convert_u999
                push    cx
                push    si
convert_u100:
                cmp     byte ptr [si], 'a'
                jb      short convert_u500
                and     byte ptr [si], 0dfh
convert_u500:
                inc     si
                loop    convert_u100
                pop     si
                pop     cx
convert_u999:
                ret
convert_upper   endp        

convert_2_linear proc   near
                movzx   edx, dx
                shl     edx, 4
                movzx   ebx, bx
                add     edx, ebx
                ret
convert_2_linear endp


;--------------------------------------------------------------
;must_be_hex - Test char in al for hex range.                 |
;                                                             |
;               Enter: al = char to test.                     |
;                Exit: carry flag set if al not an ASCII hex  |
;                      digit.                                 |
;--------------------------------------------------------------
must_be_hex     proc    near
                push    ax
                cmp     al, 'a'
                jb      short must_b100
                and     al, 0dfh                ;force to uppercase
must_b100:
                cmp     al, '0'
                jb      short must_b800
                cmp     al, '9'                 ;see if 0-9 or A-F
                jbe     short must_b600

                cmp     al, 'A'
                jb      short must_b800
                cmp     al, 'F'
                ja      short must_b800
must_b600:
                clc
                jmp     short must_b900
must_b800:
                stc
must_b900:
                pop     ax
                ret
must_be_hex     endp

;--------------------------------------------------------------
;format_seg - format segment and offset in ds:si in ASCII     |
;             as follows:                                     |
;                          xxxx:xxxx                          |
;             Put into buffer from ptr es:di                  |
;                                                             |
;             Exit: di = next offset in output buffer.        |
;--------------------------------------------------------------

format_seg      proc    near
                mov     ax, ds                  ;do the segment
                call    put_hex_word
                mov     al, ':'
                stosb
                inc     di                      ;past attribute
                mov     ax, si                  ;do the offset
                call    put_hex_word
                ret
format_seg      endp        


put_hex_word:
                mov     dl, al                  ;save LSB
                mov     al, ah                  ;want to print MSB first        
                call    put_hex_byte
                mov     al, dl

put_hex_byte:                
                mov     ah, al
put_hex_100:
                shr     al, 4                   ;get high portion
                call    put_nibble
                mov     al, ah
                and     al, 0fh      
put_nibble:
                cmp     al, 9
                ja      short put_nib_100
                add     al, '0'
                jmp     short put_nib_300
put_nib_100:
                add     al, 'A' - 10
put_nib_300:
                stosb
                inc     di                      ;past attribute
                ret

;--------------------------------------------------------------
;get_validate - Retrieve and validate an ASCII hex number.    |
;                                                             |
;              Enter: si = ptr to data                        |
;                     dl = max number of digits to get        |
;                     dh = if non zero, is a delimiter which  |
;                          may be at end of number (typically |
;                          ':' when retrieving a segment)     |
;                     cx = number of remaining chars in buffer|
;                                                             |
;               Exit: cx decremented by length of number      |
;                     si incremented past data                |
;                     ax=binary value of number               |
;                     If invalid, carry set                   |
;      bx saved                                               |
;--------------------------------------------------------------
get_validate    proc    near
                push    bx
                xor     bx, bx

                push    cx
                sub     ch, ch
                mov     cl, dl                  ;max digits to get
get_v100:
                or      dh, dh                  ;may hit delimiter?
                jz      short get_v150          ;if not, skip
                cmp     byte ptr [si + bx], dh  ;hit delimiter?
                je      short get_v200          ;if so, look only up to it
get_v150:
                cmp     byte ptr [si + bx], ' ' 
                je      short get_v200
                inc     bx
                loop    short get_v100
get_v200:
                pop     cx
                sub     cx, bx                  ;chars left
                push    cx
                mov     cx, bx
                xor     bx, bx
get_v300:
                sub     ah, ah
                lodsb                           ;get a digit
                call    hex2bin                 ;validate and convert
                jc      short get_v900          ;exit if invalid
                push    cx
                jcxz    get_v500
                dec     cx                      ;position from right - 1
                shl     cl, 2
                shl     ax, cl                  ;get nibble into position
get_v500:
                or      bx, ax                  ;build number
                pop     cx
                loop    get_v300
                clc                             ;ok

get_v900:
                mov     ax, bx
                pop     cx
                pop     bx
                ret
get_validate    endp        




hex2bin         proc    near
                cmp     al, '0'
                jb      short hex2_800
                cmp     al, '9'                 ;see if 0-9 or A-F
                ja      short hex2_500
                sub     al, '0'                 ;convert to binary
                jmp     short hex2_600
hex2_500:
                cmp     al, 'F'
                ja      short hex2_800
                sub     al, 'A' - 10
hex2_600:
                clc
                ret
hex2_800:
                stc
hex2_900:
                ret
hex2bin        endp        



skip_white_sp   proc    near
                jcxz    skip_w900
skip_w100:
                cmp     byte ptr [si], ' '
                je      short skip_w200
                cmp     byte ptr [si], TAB
                jne     short skip_w900

skip_w200:
                inc     si
                loop    skip_w100     
skip_w900:
                ret
skip_white_sp   endp

zcode            ends
        	end          

