    echo off

rem Qualitas DPMI library installation
rem (c) 1992 Qualitas, Inc.  All rights reserved.

rem %1 == "install to" path
rem %2 == DPMI library
rem %3 == source floppy (optional, default=A)

rem Test for library selection
    if "%2"=="bc2"  goto LIB_OK
    if "%2"=="bc3"  goto LIB_OK
    if "%2"=="msc6" goto LIB_OK
    if "%2"=="msc7" goto LIB_OK
    if "%2"=="BC2"  goto LIB_OK
    if "%2"=="BC3"  goto LIB_OK
    if "%2"=="MSC6" goto LIB_OK
    if "%2"=="MSC7" goto LIB_OK
    rem Wrong or no library selected
    goto ERROR

rem Library is valid
   :LIB_OK

rem Test for path selection
    rem make directory
    if not exist %1\*.* md %1

rem Test for floppy specification
    rem Assume no specified floppy
    set DPMI_FLOPPY=A
    rem Check for no room in the environment
    if "%DPMI_FLOPPY%"=="" goto NOROOM
    if not "%3"=="" set DPMI_FLOPPY=%3

rem Unzip files for %2 into %1
    rem first display license.txt
    type %DPMI_FLOPPY%:license.txt
    pause
    %DPMI_FLOPPY%:pkunzip -d %DPMI_FLOPPY%:\%2 %1
    echo Installation complete!
    goto END

:NOROOM
echo We need to define a small variable and
echo find there isn't enough room in your
echo environment.  Please increase it by 32
echo bytes and re-run this batch file.
    goto END

:ERROR
echo.
echo Use the following syntax to install
echo the Qualitas DPMI Library:
echo.
echo INSTALL path library [source drive]
echo.
echo where "path" points to the directory into which
echo the DPMI library will be installed and "library"
echo is the specific version of the DPMI library
echo you wish installed.  Source drive is the floppy drive
echo from which you are installing (default = A)

echo Select the library from the following:
echo.
echo    BC2      Borland C++ version 2.x comaptible library
echo    BC3      Borland C++ version 3.x comaptible library
echo    MSC6     Microsoft C verson 6.x comaptible library
echo    MSC7     Microsoft C verson 7.x comaptible library
echo.
echo Example:  INSTALL C:\TOOLS MSC6 B
echo.
echo would install the Microsoft C 6 compatible DPMI library
echo from B: to C:\TOOLS.

    :END
rem Clear environment variable
    set DPMI_FLOPPY=

