.PO1
.RR      L----!----!----!----!----!----!----!----!----!----!----!--------R
.OJ ON
/*
** File BarChartP.h 
** This is a private header file for the internal 
** data structures for the BarChart Widget.
*/

#ifndef BARCHARTP_H
#define BARCHARTP_H 1

/*
**   Dummy structure required for all widgets. 
*/ 
typedef struct _XvBarChartClassPart { 
   int    ignore; 
   } BarChartClassPart; 

/*
**   Dummy structure required for all widgets. 
*/ 
typedef struct _XvBarChartClassRec {
   CoreClassPart         core_class; /* for all classes */ 
   BarChartClassPart      barchart_class; /* for my class, ignore*/
} XvBarChartClassRec; 

/*
** This structure is in the source file but declare it here. 
*/
extern XvBarChartClassRec xvbarchartClassRec; 

typedef struct _XvBarChartPart{
   int       maxItemCount;       /* the max array size   */
   int       itemCount;        /* The number of items in*/
   int      *items;          /* the list of items    */
   int      *auxItems;       /* the secondary data   */ 
   XRectangle *itemHt;       /* for drawing calls    */ 
   XRectangle *auxItemHt;    /* for drawing calls    */ 
   int     itemWidth;        /* for each bar.        */  
   int     maxValue;         /* for maximum clipping */
   int     midValue;         /* for midrange value   */
   int     minValue;         /* for minimum clipping */
   int     fmax;             /* ratios for clipping  */
   int     fmid;             /* onto the display     */
   int     fmin;             /* screen               */
   Pixel   positiveColor;    /* for items > midValue */
   Pixel   zeroColor;        /* for midValue line    */
   Pixel   negativeColor;    /* for items < midValue */ 
   GC      positiveGC;      /* to show positive      */ 
   GC      negativeGC;      /* etc, etc              */ 
   GC      zeroGC;          /* for the axes          */ 
   GC      inverseGC;       /* for erasing           */ 
   int     namelen;       /* length of default name  */
   char    *name;         /* Display this string     */
   XtCallbackList   select; /* For all callbacks     */
   int       redraw;        /* flag to indicate redraw*/
   int       showValue;     /* flags to show text on  */
   int       maxShowValue;  /* display screen         */ 
   int       minShowValue;  /* ditto                  */ 
   int       showChartLabel;/* the display            */
   char      *chartLabel;   /* The string to show     */
   } XvBarChartPart; 

/* 
** The barchart widget instance record is defined here. 
**/
typedef struct _XvBarChartRec { 
   CorePart   core;           /* req. for all widgets */
   XvBarChartPart   barchart; /* req. for this widget */ 
   } XvBarChartRec; 

#endif
