
/* 
** File: LineChartP.h
** This is an example of a header file that 
** inherits all the BarChart features and 
** adds it's own features. 
**/

#ifndef LINECHARTP_H
#define LINECHARTP_H 1

/*
**	Required Dummy structure.
*/
typedef struct _XvLineChartClassPart { 
	int 	ignore; 
	} LineChartClassPart; 

/*
**	Required Dummy structure.
*/
typedef struct _XvLineChartClassRec {
	CoreClassPart		core_class;      /* for all classes */ 
	BarChartClassPart	barchart_class;  /* for inheritance     */
	LineChartClassPart	linechart_class; /* for my class, ignore*/
} XvLineChartClassRec; 

/*
** This is defined in the LineChart.c source file
*/
extern XvLineChartClassRec XvlinechartClassRec; 

/*
** Some new (dummy for now) features are described here. 
*/
typedef struct _XvLineChartPart{
	Boolean	showGraticules; 
	Boolean   showHorizontal; 
	Boolean   showVertical; 
	} XvLineChartPart; 

/* 
** The linechart widget instance record is defined here. 
**/
typedef struct _XvLineChartRec { 
	CorePart			core; 
	XvBarChartPart		barchart; 
	XvLineChartPart	linechart; 
	} XvLineChartRec; 

#endif
