static char *RcsId = "$Id: navrdisp.c,v 1.2 1992/02/21 19:38:54 khx Exp $";

/*
 * $Id: navrdisp.c,v 1.2 1992/02/21 19:38:54 khx Exp $
 *
 * $Log: navrdisp.c,v $
 * Revision 1.2  1992/02/21  19:38:54  khx
 * redirected navMsgs.h to navcomm directory
 *
 * Revision 1.1  1992/02/19  17:27:45  khx
 * Initial revision
 *
 * Revision 1.1  1992/02/12  15:43:04  rfs
 * Initial revision
 *
*/


/* 
 * This file contains the statistical display functions for ranges
 */

#include <X11/X.h>
#include "stdlib.h"
#include "stdio.h"
#include "math.h"
#include "navcomm/navMsgs.h"
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/MessageB.h>
#include <Xm/BulletinB.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/Label.h>
#include <Xm/Text.h>
#include <Xm/ToggleBG.h>
#include <Xm/Form.h>
#include <Xm/DrawingA.h>
#include <Xm/SelectioB.h>
#include "navLib.h"
#include "LineChart.h"

static int makeHistogramData(int num , 
int *ipop, int *ihist, int *max, int *min) ;
int SRSgetRangeData(Widget myw, int id, caddr_t cptr);
int SRSmakeRangeShell(Widget parent, int id);
int useAlphaFilter(Widget w, int id, caddr_t cp);
int useSpikeFilter(Widget w, int id, caddr_t cp);
int getFilterParms(FILTERATTR *fptr, Widget ftype, Widget one, Widget two);

int SRSmakeRangeShell(Widget parent, int id)
{
	int icount, tcount, imaxDummy, iminDummy, imidDummy, iave, sum;
	int ivalue, iminShow , imaxShow , iHistCount;
	HISTORYITEM *hptr;
	int n;
	int sx1 = 10;
	int sx2 = 50;
	int dw = 35;
	int sy = 15;
	int dh = 12;
	char strName[32];
	Arg wars[24];
	Widget   mw;
	XGCValues  gcv;
	XtGCMask  gcmask;
	XFontStruct *fptr;
	RANGESTATS  *rp;
	int 	*raw, *filth, *ihist;
	double devalue;
	NAVX_RANGE *rngPtr;

	rp = GbAcousticRanges[id].stats;

	if (rp != NULL)
	{
		XtRealizeWidget(rp->mainAppShell);
		return;
	}
	rngPtr = (NAVX_RANGE *)&(GbAcousticRanges[id]);

	GbAcousticRanges[id].stats = 
	    (RANGESTATS *) XtMalloc(sizeof(RANGESTATS));
	rp = GbAcousticRanges[id].stats;

	sprintf(strName,"%s to %s", 
	    GbAllStations[(GbAcousticRanges[id].sndx)].alias, 
	    GbAllStations[(GbAcousticRanges[id].dndx)].alias);

	n =0;
	XtSetArg(wars[n], XmNwidth, 500); 
	n++;
	XtSetArg(wars[n], XmNheight, 300); 
	n++;
	XtSetArg(wars[n], XmNiconic, False ); 
	n++;
	XtSetArg(wars[n], XmNiconName, strName); 
	n++;
	rp->mainAppShell = XtAppCreateShell( NULL, strName, 	
	    topLevelShellWidgetClass, 
	    XtDisplay(parent), wars, n);

	XtCreateManagedWidget("widget", widgetClass, 
	    rp->mainAppShell,  NULL, 0);
	XtRealizeWidget(rp->mainAppShell);

	n=0;
	XtSetArg(wars[n], XmNwidth, 500); 
	n++;
	XtSetArg(wars[n], XmNheight, 300); 
	n++;
	rp->mainForm = XmCreateForm(rp->mainAppShell,"rangenAppForm",wars,n);
	XtManageChild( rp->mainForm );

	/* 
 * Macros begin here. 
 */

	#define SLICE_FORM_INTO_TWO(big,one,two,cut) \
	n = 0; 				\
	XtSetArg(wars[n], XmNbackground , navdefaultNavyColor ); n++; \
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_FORM ); n++; \
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_FORM ); n++; \
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_FORM ); n++; \
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNrightPosition, (cut)); n++; \
	one = XmCreateForm(big,"left",wars,n);   \
	n = 0; 				\
	XtSetArg(wars[n], XmNbackground , navdefaultNavyColor ); n++; \
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_FORM ); n++; \
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_FORM ); n++; \
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_FORM ); n++; \
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNleftPosition, (1+cut)); n++; \
	two = XmCreateForm(big,"left",wars,n);   \
	XtManageChild(one); XtManageChild(two); XtManageChild(big)

/*
 *  Requires the following declarations:
 *
 * int n; 
 * Arg wars[20]; 
 */


	#define MAKE_LBL_ON_FORM(form,lbl,x,y,w,h,str) \
	n = 0; \
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNrightPosition, (x+w)); n++; \
	XtSetArg(wars[n], XmNleftPosition, (x)); n++; \
	XtSetArg(wars[n], XmNtopPosition, (y)); n++; \
	XtSetArg(wars[n], XmNbottomPosition, (h+y)); n++; \
	lbl = XmCreateLabel(form,str,wars,n); \
	XtManageChild(lbl)

	/* 
 * Requires the following declarations
 * int n; 
 * Arg wars[20]; 
 */
	#define MAKE_BTN_ON_FORM(form,btn,x,y,w,h,str) \
	n = 0; 	\
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNrightPosition, (x+w)); n++; \
	XtSetArg(wars[n], XmNleftPosition, (x)); n++; \
	XtSetArg(wars[n], XmNtopPosition, (y)); n++; \
	XtSetArg(wars[n], XmNbottomPosition, (h+y)); n++; \
	btn = XmCreatePushButton(form,str,wars,n); \
	XtManageChild(btn)


	/* 
 * Requires the following declarations
 * int n; 
 * Arg wars[20]; 
 */
	#define MAKE_TXT_ON_FORM(form,txt,x,y,w,h,str) \
	n = 0; 	\
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNrightPosition, (x+w)); n++; \
	XtSetArg(wars[n], XmNleftPosition, (x)); n++; \
	XtSetArg(wars[n], XmNtopPosition, (y)); n++; \
	XtSetArg(wars[n], XmNbottomPosition, (h+y)); n++; \
	txt = XmCreateText(form,str,wars,n); \
	XtManageChild(txt)



	sx1 = 10;
	sx2 = 50;
	dw = 35;
	sy = 15;
	dh = 10;
	SLICE_FORM_INTO_TWO(rp->mainForm,rp->btnForm,rp->drawForm,40);
	n = 0;
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNrightPosition, (sx2+dw)); 
	n++;
	XtSetArg(wars[n], XmNleftPosition, (sx1)); 
	n++;
	XtSetArg(wars[n], XmNtopPosition, (5)); 
	n++;
	XtSetArg(wars[n], XmNbottomPosition, (dh+15)); 
	n++;
	XtSetArg(wars[n], XmNradioBehavior, True); 
	n++;
	XtSetArg(wars[n], XmNradioAlwaysOne, True); 
	n++;
	rp->filterRCForm = XmCreateRowColumn(rp->btnForm,"help",wars,n);
	XtManageChild(rp->filterRCForm);
	rp->alphaRTG = XmCreateToggleButtonGadget(
	    rp->filterRCForm,"AlphaBeta", NULL, 0);
	rp->spikeRTG = XmCreateToggleButtonGadget(
	    rp->filterRCForm,"Spike", NULL, 0);
	XtManageChild(rp->alphaRTG);
	XtManageChild(rp->spikeRTG);
	XmToggleButtonGadgetSetState(rp->spikeRTG, True, True);
	XtManageChild(rp->spikeRTG);
	XtManageChild(rp->filterRCForm);

	sy = 20;
	MAKE_LBL_ON_FORM(rp->btnForm,rp->filterLabel,sx1,sy,(sx2+dw),dh,"Filter");
	sy+= dh;
	MAKE_LBL_ON_FORM(rp->btnForm,rp->alphaLabel,sx1,sy,dw,dh,"Alpha");
	MAKE_LBL_ON_FORM(rp->btnForm,rp->windowLabel,sx1,sy,dw,dh,"Window");
	MAKE_TXT_ON_FORM(rp->btnForm,rp->oneText,sx2,sy,dw,dh,"Alpha");
	sy+= dh;
	MAKE_LBL_ON_FORM(rp->btnForm,rp->betaLabel,sx1,sy,dw,dh,"Beta");
	MAKE_LBL_ON_FORM(rp->btnForm,rp->threshLabel,sx1,sy,dw,dh,"Thresh");
	MAKE_TXT_ON_FORM(rp->btnForm,rp->twoText,sx2,sy,dw,dh,"Alpha");
	sy+= dh;
	MAKE_BTN_ON_FORM(rp->btnForm,rp->testBtn,sx1,sy,dw,dh,"Test");
	sy+= dh;
	MAKE_BTN_ON_FORM(rp->btnForm,rp->applyBtn,sx1,sy,dw,dh,"Apply");
	sy+= dh;
	MAKE_BTN_ON_FORM(rp->btnForm,rp->clearBtn,sx1,sy,dw,dh,"Clear");

	XtAddCallback( rp->alphaRTG, XmNvalueChangedCallback, useAlphaFilter, id);
	XtAddCallback( rp->spikeRTG, XmNvalueChangedCallback, useSpikeFilter, id);
	XtAddCallback(rp->testBtn,XmNactivateCallback, SRSgetRangeData, id);
	/* 
 * make the drawing area widget here with the maximum history count.
 * make the histogram here for the raw history.
 * make the histogram here for the new history.
 * Replicate the last known value if the history is not complete.. 
 * set defaults for the spike filter 
 */
	XmTextSetString(rp->oneText,"8");
	XmTextSetString(rp->twoText,"10");
	XtManageChild(rp->oneText);
	XtManageChild(rp->twoText);

	icount = readXHistory(&(rngPtr->values), 
	    rngPtr->values.numitems, rngPtr->filter.dpop);
	if (icount < rngPtr->filter.iOpLen ) rngPtr->filter.iOpLen = icount;
	tcount = rngPtr->values.maxitems;
	icount = rngPtr->values.numitems;

	filth  = (int *)XtMalloc(sizeof(int) * tcount);
	raw = (int *)XtMalloc(sizeof(int) * tcount);
	ihist = (int *)XtMalloc(sizeof(int) * tcount);

	sum = 0;
	imaxDummy = -1000;
	iminDummy = 1000;
	hptr = rngPtr->values.qptr;
	rngPtr->filter.dPrevious = fabs(hptr->x);
	for (n = 0; n < icount; n++)
	{
		/*
    ivalue = (int)(hptr->x); 
	*/
		ivalue = (int)(rngPtr->filter.dpop[n]);

		if (ivalue < 0) ivalue *= -1;
		sum += ivalue;
		raw[n] = ivalue;

		iave = sum/(n+1);

		getFilterData(&(rngPtr->filter), (hptr->x), &devalue);
		filth[n] = (int)devalue;

		if (imaxDummy < ivalue) imaxDummy = ivalue;
		if (iminDummy > ivalue) iminDummy = ivalue;
		hptr++;
	}

	iave = sum / icount;
	imidDummy = (imaxDummy + iminDummy)/2;

	n = icount;
	while ( n < tcount)
	{
		raw[n] = iave;
		/*
     getFilterData(&(rngPtr->filter), (hptr->x), &devalue); 
	filth[n] = (int)devalue; 
	*/
		filth[n] = iave;
		n++;
	}

	iminShow = iminDummy;
	imaxShow = imaxDummy;

	printf ("\ncreating the line chart widget\n");
	sprintf(strName,"%d,%d",imaxDummy,iminDummy);
	n = 0;
	XtSetArg(wars[n], XmNheight, 50); 
	n++;
	XtSetArg(wars[n], XmNwidth, 50); 
	n++;
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNleftPosition, 5 ); 
	n++;
	XtSetArg(wars[n], XmNrightPosition, 95); 
	n++;
	XtSetArg(wars[n], XmNtopPosition, 5 ); 
	n++;
	XtSetArg(wars[n], XmNbottomPosition, 45 ); 
	n++;
	XtSetArg(wars[n], XmNforeground, navdefaultBlackColor); 
	n++;
	XtSetArg(wars[n], XmNbackground, navdefaultWhiteColor); 
	n++;
	XtSetArg(wars[n], XtNitems, raw); 
	n++;
	XtSetArg(wars[n], XtNauxItems, filth); 
	n++;
	XtSetArg(wars[n], XtNitemCount, tcount); 
	n++;
	XtSetArg(wars[n], XtNmaxItemCount, tcount); 
	n++;
	XtSetArg(wars[n], XtNmaxValue, imaxDummy); 
	n++;
	XtSetArg(wars[n], XtNmidValue, iminDummy); 
	n++;
	XtSetArg(wars[n], XtNminValue, iminDummy); 
	n++;
	XtSetArg(wars[n], XtNzeroColor, navdefaultBlackColor); 
	n++;
	XtSetArg(wars[n], XtNpositiveColor, navdefaultBlueColor); 
	n++;
	rp->plotLChart = XtCreateManagedWidget("cluso", 
	    XvlinechartWidgetClass, 
	    rp->drawForm, wars, n);

	printf ("\ncreating the raw chart widget\n");
	iHistCount = makeHistogramData(icount,filth,ihist,&imaxDummy,&iminDummy);
	n = 0;
	XtSetArg(wars[n], XmNforeground, navdefaultBlackColor); 
	n++;
	XtSetArg(wars[n], XmNbackground, navdefaultWhiteColor); 
	n++;
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNleftPosition, 10 ); 
	n++;
	XtSetArg(wars[n], XmNrightPosition, 90); 
	n++;
	XtSetArg(wars[n], XmNtopPosition, 50 ); 
	n++;
	XtSetArg(wars[n], XmNbottomPosition, 72 ); 
	n++;
	XtSetArg(wars[n], XtNitems, ihist); 
	n++;
	XtSetArg(wars[n], XtNitemCount, iHistCount); 
	n++;
	XtSetArg(wars[n], XtNmaxItemCount, iHistCount); 
	n++;
	XtSetArg(wars[n], XtNmaxValue, imaxDummy); 
	n++;
	XtSetArg(wars[n], XtNmidValue, iminDummy); 
	n++;
	XtSetArg(wars[n], XtNminValue, iminDummy); 
	n++;
	XtSetArg(wars[n], XtNminShowValue, imaxShow); 
	n++;
	XtSetArg(wars[n], XtNmaxShowValue, iminShow); 
	n++;
	XtSetArg(wars[n], XtNzeroColor, navdefaultBlueColor); 
	n++;
	XtSetArg(wars[n], XtNpositiveColor, navdefaultBlueColor); 
	n++;
	rp->rawBChart = XtCreateManagedWidget("cluso", 
	    XvbarchartWidgetClass, 
	    rp->drawForm, wars, n);

	printf ("\ncreating the filtered chart widget\n");
	iHistCount = makeHistogramData(icount,raw,ihist,&imaxDummy,&iminDummy);
	n = 0;
	XtSetArg(wars[n], XtNminShowValue, imaxShow); 
	n++;
	XtSetArg(wars[n], XtNmaxShowValue, iminShow); 
	n++;
	XtSetArg(wars[n], XtNchartLabel, strName); 
	n++;
	XtSetArg(wars[n], XmNbackground, navdefaultWhiteColor); 
	n++;
	XtSetArg(wars[n], XmNforeground, navdefaultBlackColor); 
	n++;
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_POSITION ); 
	n++;
	XtSetArg(wars[n], XmNleftPosition, 10 ); 
	n++;
	XtSetArg(wars[n], XmNrightPosition, 90); 
	n++;
	XtSetArg(wars[n], XmNtopPosition, 75 ); 
	n++;
	XtSetArg(wars[n], XmNbottomPosition, 99 ); 
	n++;
	XtSetArg(wars[n], XtNitems, ihist); 
	n++;
	XtSetArg(wars[n], XtNitemCount, iHistCount); 
	n++;
	XtSetArg(wars[n], XtNmaxItemCount, iHistCount); 
	n++;
	XtSetArg(wars[n], XtNmaxValue, imaxDummy); 
	n++;
	XtSetArg(wars[n], XtNmidValue, iminDummy); 
	n++;
	XtSetArg(wars[n], XtNminValue, iminDummy); 
	n++;
	XtSetArg(wars[n], XtNzeroColor, navdefaultRedColor); 
	n++;
	XtSetArg(wars[n], XtNpositiveColor, navdefaultRedColor); 
	n++;
	rp->filterBChart = XtCreateManagedWidget("filthy", 
	    XvbarchartWidgetClass, 
	    rp->drawForm, wars, n);

	XtManageChild(rp->btnForm);
	XtManageChild(rp->drawForm);
	XtManageChild(rp->mainForm);
	XtFree(raw);
	XtFree(filth);
	XtFree(ihist);
}
/*
 *	Range Selection Procedure here.  
 */
int SRSSmakeSelectBox(Widget parent,int *id, caddr_t cp);

static int SRSgetRangeName(Widget myw,int *id, 
XmSelectionBoxCallbackStruct *cp);

Widget   SRSselection = NULL;

int SRSSmakeSelectBox(Widget parent,int *id, caddr_t cp)
{
	int ndx, n, count, sndx, dndx;
	Arg wars[20];
	XmString *xlist;
	Widget okay;
	char tempname[64];
	NIM *nimptr;

	if (SRSselection != NULL)
	{
		XtManageChild(SRSselection);
		return;
	}
	nimptr = navmainGetNimPtr();
	xlist = (XmString *)
	    XtMalloc(sizeof(XmString) * G_NAV_NUM_A_RANGES(nimptr));

	count = 0;
	for (ndx =0; ndx < G_NAV_NUM_A_RANGES(nimptr); ndx++)
	{
		sndx = GbAcousticRanges[ndx].sndx;
		dndx = GbAcousticRanges[ndx].dndx;
		sprintf(tempname,"%s to %s",
		    GbAllStations[sndx].alias, 
		    GbAllStations[dndx].alias);
		xlist[ndx] = XmStringCreate(tempname, XmSTRING_DEFAULT_CHARSET);
	}

	n = 0;
	XtSetArg(wars[n], XmNlistItems, xlist); 
	n++;
	XtSetArg(wars[n], XmNlistItemCount, ndx ); 
	n++;
	SRSselection = XmCreateSelectionDialog(parent,"Ranges",wars,n);
	XtManageChild(SRSselection);
	*id = -1;
	XtAddCallback(SRSselection ,XmNokCallback, SRSgetRangeName, id);
	XtUnmanageChild(XmSelectionBoxGetChild(SRSselection,XmDIALOG_HELP_BUTTON));

	for (n=0; n < ndx; n++) XmStringFree(xlist[n]);
	XtFree(xlist);
}

static int SRSgetRangeName(Widget myw,int *id, 
XmSelectionBoxCallbackStruct *cp)
{
	int n, sndx, dndx;
	XmString xmstr;
	NIM *nimptr;
	char tempname[64];

	nimptr = navmainGetNimPtr();

	for (n = 0; n < G_NAV_NUM_A_RANGES(nimptr); n++)
	{
		sndx = GbAcousticRanges[n].sndx;
		dndx = GbAcousticRanges[n].dndx;
		sprintf(tempname,"%s to %s",
		    GbAllStations[sndx].alias, GbAllStations[dndx].alias);
		xmstr = XmStringCreate(tempname, XmSTRING_DEFAULT_CHARSET);
		if (XmStringCompare(xmstr,cp->value))
		{
			*id = n;
			XmStringFree(xmstr);
			printf("\n found!");
			/* 
		 * Call the function to create the station display here. 
		 */
			SRSmakeRangeShell(myw, n);
			return;
		}
		XmStringFree(xmstr);
	}
}

SRSfreeAllGraphics()
{
	int i;
	NIM *nimptr;
	RANGESTATS *rp;
	nimptr = navmainGetNimPtr();
	for (i=0; i < G_NAV_NUM_A_RANGES(nimptr); i++)
	{
		if (GbAcousticRanges[i].stats == NULL) continue;
		rp = GbAcousticRanges[i].stats;
		XtDestroyWidget(rp->plotLChart);
		XtDestroyWidget(rp->filterBChart);
		XtDestroyWidget(rp->rawBChart);
		XtFree(GbAcousticRanges[i].stats);
	}
}

int SRSgetRangeData(Widget myw, int id, caddr_t cptr)
{
	int icount, tcount, imaxDummy, iminDummy, imidDummy, iave, sum;
	int ivalue, iminShow, imaxShow, iHistCount;
	int *raw, *filth, *ihist;
	HISTORYITEM *hptr;
	RANGESTATS  *rp;
	int n;
	Arg wars[12];
	char strName[32];
	double devalue;
	NAVX_RANGE *rngPtr;

	rp = GbAcousticRanges[id].stats;

	rngPtr = (NAVX_RANGE *)&(GbAcousticRanges[id]);

	icount = readXHistory(&(rngPtr->values), 
	    rngPtr->values.numitems, rngPtr->filter.dpop);
	if (icount < rngPtr->filter.iOpLen ) rngPtr->filter.iOpLen = icount;
	tcount = rngPtr->values.maxitems;
	icount = rngPtr->values.numitems;

	filth  = (int *)XtMalloc(sizeof(int) * tcount);
	raw = (int *)XtMalloc(sizeof(int) * tcount);
	ihist = (int *)XtMalloc(sizeof(int) * tcount);

	sum = 0;
	imaxDummy = -1000;
	iminDummy = 1000;
	hptr = GbAcousticRanges[id].values.qptr;
	GbAcousticRanges[id].filter.dPrevious = fabs(hptr->x);
	/* 
 * get the filter parameters from the user, 
 * if ab .. get a from oneText beta from twoText
 * if spike .. get window from oneText and thersh from twoText
 */
	getFilterParms((FILTERATTR *)&(GbAcousticRanges[id].filter), 
	    rp->alphaRTG, rp->oneText, rp->twoText);

	for (n = 0; n < icount; n++)
	{
		/*
    ivalue = (int)(hptr->x); 
    */
		ivalue = (int)(GbAcousticRanges[id].filter.dpop[n]);
		if (ivalue < 0) ivalue *= -1;

		sum += ivalue;
		raw[n] = ivalue;
		iave = sum / (n+1);
		getFilterData((FILTERATTR *)&(GbAcousticRanges[id].filter), 
		    (hptr->x), &devalue);
		filth[n] = (int)devalue;

		if (imaxDummy < ivalue) imaxDummy = ivalue;
		if (iminDummy > ivalue) iminDummy = ivalue;
		hptr++;
	}

	iave = sum / icount;
	imidDummy = (imaxDummy + iminDummy)/2;

	n = icount;
	while ( n < tcount)
	{
		raw[n] = iave;
		/*
     getFilterData((FILTERATTR *)&(GbAcousticRanges[id].filter), 
							(hptr->x), &devalue); 
	filth[n] = (int)devalue;  
	*/
		filth[n] = iave;
		n++;
	}

	sprintf(strName,"%d,%d",imaxDummy,iminDummy);
	iminShow = iminDummy;
	imaxShow = imaxDummy;
	n = 0;
	XtSetArg(wars[n], XtNitems, raw); 
	n++;
	XtSetArg(wars[n], XtNauxItems, filth); 
	n++;
	XtSetArg(wars[n], XtNmaxItemCount, tcount); 
	n++;
	XtSetArg(wars[n], XtNitemCount, tcount); 
	n++;
	XtSetArg(wars[n], XtNmaxValue, imaxDummy); 
	n++;
	XtSetArg(wars[n], XtNmidValue, iminDummy); 
	n++;
	XtSetArg(wars[n], XtNminValue, iminDummy); 
	n++;
	XtSetValues(rp->plotLChart, wars, n);
	XtManageChild(rp->plotLChart);

	sprintf(strName,"%d,%d",imaxDummy,iminDummy);
	iHistCount = makeHistogramData(icount,raw,ihist,&imaxDummy,&iminDummy);
	n = 0;
	XtSetArg(wars[n], XtNitems, ihist); 
	n++;
	XtSetArg(wars[n], XtNitemCount, iHistCount); 
	n++;
	XtSetArg(wars[n], XtNmaxItemCount, iHistCount); 
	n++;
	XtSetArg(wars[n], XtNmaxValue, imaxDummy); 
	n++;
	XtSetArg(wars[n], XtNmidValue, iminDummy); 
	n++;
	XtSetArg(wars[n], XtNminValue, iminDummy); 
	n++;
	XtSetArg(wars[n], XtNminShowValue, imaxShow); 
	n++;
	XtSetArg(wars[n], XtNmaxShowValue, iminShow); 
	n++;
	XtSetValues(rp->rawBChart, wars, n);
	XtManageChild( rp->rawBChart);

	iHistCount = makeHistogramData(icount,filth,ihist,&imaxDummy,&iminDummy);
	printf("\n strName = %s", strName);
	n = 0;
	/* XtSetArg(wars[n], XtNchartLabel, strName); n++;  */
	XtSetArg(wars[n], XtNitems, ihist); 
	n++;
	XtSetArg(wars[n], XtNitemCount, iHistCount); 
	n++;
	XtSetArg(wars[n], XtNmaxItemCount, iHistCount); 
	n++;
	XtSetArg(wars[n], XtNmaxValue, imaxDummy); 
	n++;
	XtSetArg(wars[n], XtNmidValue, iminDummy); 
	n++;
	XtSetArg(wars[n], XtNminValue, iminDummy); 
	n++;
	XtSetArg(wars[n], XtNminShowValue, imaxShow); 
	n++;
	XtSetArg(wars[n], XtNmaxShowValue, iminShow); 
	n++;
	XtSetValues(rp->filterBChart, wars, n);
	XtManageChild(rp->filterBChart);


	XtFree(raw);
	XtFree(filth);
	XtFree(ihist);
}

int compareInts(void  *one, void  *two)
{
	return(*(int *)one - *(int *)two);
}

static int makeHistogramData(int num , int *ipop, 
int *ihist, int *max, int *min)
{
	register int i, k,classes;

	if ( num < 5 ) return ;
	*min = 0;
	*max = 0;
	qsort(ipop, (size_t)num,sizeof(int), compareInts);

	for (i=1; i < num; i++)  ihist[i] = 0;
	classes = 0;
	ihist[0] = 1; 	/* start with the first one! */
	k = ipop[0];
	for (i=1; i < num; i++)
	{
		if (ipop[i] == k) ihist[classes] += 1;
		else 
		{
			classes++;
			(ihist[classes])++;
			k = ipop[i];
		}
	}
	for (i=0; i <= classes; i++)
		if (*max < ihist[i])  *max = ihist[i];
	/*
printf("\n classes %d", classes); 
for (i=0; i <= classes;  i++)  printf(" %d", ihist[i]);
printf("\n num  %d", num); 
for (i=0; i < num;  i++)  printf(" %d", ipop[i]);
printf("\n "); 
*/
	return (classes + 1);
}

int useSpikeFilter(Widget w, int id, caddr_t cp)
{
	RANGESTATS  *rp;
	char        str[16];
	rp = GbAcousticRanges[id].stats;
	if (rp == NULL) return;

	GbAcousticRanges[id].filter.iType = 0;
	sprintf(str,"%6d", GbAcousticRanges[id].filter.iOpLen);
	XmTextSetString(rp->oneText,str);
	sprintf(str,"%6.2f", GbAcousticRanges[id].filter.dTolerance);
	XmTextSetString(rp->twoText,str);
	XtUnmanageChild(rp->alphaLabel);
	XtUnmanageChild(rp->betaLabel);
	XtManageChild(rp->windowLabel);
	XtManageChild(rp->threshLabel);
	XtManageChild(rp->btnForm);
}

int useAlphaFilter(Widget w, int id, caddr_t cp)
{
	RANGESTATS  *rp;
	char str[16];
	rp = GbAcousticRanges[id].stats;
	if (rp == NULL) return;

	GbAcousticRanges[id].filter.iType = ALPHABETA_FILTER;
	sprintf(str,"%6.2f", GbAcousticRanges[id].filter.dAlpha);
	XmTextSetString(rp->oneText,str);
	sprintf(str,"%6.2f", GbAcousticRanges[id].filter.dBeta);
	XmTextSetString(rp->twoText,str);
	XtManageChild(rp->oneText);
	XtManageChild(rp->twoText);
	XtManageChild(rp->alphaLabel);
	XtManageChild(rp->betaLabel);
	XtUnmanageChild(rp->windowLabel);
	XtUnmanageChild(rp->threshLabel);
	XtManageChild(rp->btnForm);
}

int getFilterParms(FILTERATTR *fptr, Widget ftype, Widget one, Widget two)
{
	double a, b;
	int    i;
	char *str;

	if (XmToggleButtonGadgetGetState(ftype) == True)
	{
		/* 
	 * get the real number for the alpha wt.
	 */
		fptr->iType = ALPHABETA_FILTER;
		str = XmTextGetString(one);
		sscanf(str,"%lf",&a);
		if ((a < 0) || (a > 1.0)) a = 0.25;
		XtFree(str);
		fptr->dAlpha = a;
		/* 
	 * get the real number for the beta wt.
	 */
		str = XmTextGetString(two);
		sscanf(str,"%lf",&b);
		if ((b < 0) || (b > 1.0)) b = 0.25;
		XtFree(str);
		fptr->dBeta = b;
		printf("\n b == %lf", b);
		printf("\n a == %lf", a);
	}
	else 
	{
		/* 
	 * get the integer for the window
	 */
		fptr->iType = 0;
		str = XmTextGetString(one);
		sscanf(str,"%d",&i);
		if ((i < 5) || (i >= MAX_HISTORY_ITEMS)) i = 8;
		XtFree(str);
		fptr->iOpLen = i;

		/* 
	 * get the real number for the threshold aka tolerance 
	 */
		str = XmTextGetString(two);
		sscanf(str,"%lf",&b);
		if ((b < 3) || (b > 100)) b = 10;
		XtFree(str);
		fptr->dTolerance = b;
		printf("\n b == %lf", b);
		printf("\n i == %d", i);
	}

	printf("\n Operator length = %d \n", fptr->iOpLen);
}
