static char *RcsId = "$Id: navsdisp.c,v 1.2 1992/02/21 19:37:56 khx Exp $";

/*
 * $Id: navsdisp.c,v 1.2 1992/02/21 19:37:56 khx Exp $
 *
 * $Log: navsdisp.c,v $
 * Revision 1.2  1992/02/21  19:37:56  khx
 * redirected navMsgs.h to navcomm directory.
 *
 * Revision 1.1  1992/02/19  17:27:45  khx
 * Initial revision
 *
 * Revision 1.1  1992/02/12  15:43:04  rfs
 * Initial revision
 *
*/


/* 
 * This file contains the statistical display functions for ranges
 */

#include <X11/X.h>
#include "stdlib.h"
#include "stdio.h"
#include "navcomm/navMsgs.h"
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/MessageB.h>
#include <Xm/BulletinB.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/CascadeB.h>
#include <Xm/Label.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/Form.h>
#include <Xm/DrawingA.h>
#include <Xm/SelectioB.h>
#include "navLib.h"


static int SFcompleteXYdraw(Widget parent, int id, caddr_t cp);
int SFSmakeStationShell(Widget parent, int id);

int SFSmakeStationShell(Widget parent, int id)
{
	int n;
	Arg wars[10];
	Widget   mw;
	XGCValues  gcv;
	XtGCMask  gcmask;
	XFontStruct *fptr;

	if (GbAllStations[id].xystatAppShell != NULL)
	{
		XtRealizeWidget(GbAllStations[id].xystatAppShell);
		return;
	}


	n =0;
	XtSetArg(wars[n], XmNwidth, 400); 
	n++;
	XtSetArg(wars[n], XmNheight, 400); 
	n++;
	XtSetArg(wars[n], XmNiconic, False ); 
	n++;
	XtSetArg(wars[n], XmNiconName, GbAllStations[id].alias ); 
	n++;
	GbAllStations[id].xystatAppShell = XtAppCreateShell( NULL, 
	    GbAllStations[id].alias, 
	    topLevelShellWidgetClass, 
	    XtDisplay(parent), wars, n);
	XtCreateManagedWidget("widget", widgetClass, 
	    GbAllStations[id].xystatAppShell, NULL, 0);
	XtRealizeWidget(GbAllStations[id].xystatAppShell);

	n=0;
	XtSetArg(wars[n], XmNwidth, 400); 
	n++;
	XtSetArg(wars[n], XmNheight, 400); 
	n++;
	GbAllStations[id].xystatAppForm = XmCreateForm(
	    GbAllStations[id].xystatAppShell,"StatsmainAppForm",wars,n);
	XtManageChild( GbAllStations[id].xystatAppForm );

	n = 0;
	XtSetArg(wars[n], XmNforeground, navdefaultBlackColor ); 
	n++;
	XtSetArg(wars[n], XmNbackground, navdefaultWhiteColor ); 
	n++;
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_FORM); 
	n++;
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_FORM); 
	n++;
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_FORM); 
	n++;
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_POSITION); 
	n++;
	XtSetArg(wars[n], XmNrightPosition, 88); 
	n++;
	GbAllStations[id].xydrawarea = 	
	    XmCreateDrawingArea(GbAllStations[id].xystatAppForm, 		
	    "DrawArea", wars, n);
	XtManageChild( GbAllStations[id].xydrawarea);
	mw = GbAllStations[id].xydrawarea;

	n = 0;
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_POSITION); 
	n++;
	XtSetArg(wars[n], XmNtopPosition, 10); 
	n++;
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_FORM); 
	n++;
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_POSITION); 
	n++;
	XtSetArg(wars[n], XmNleftPosition, 92); 
	n++;
	GbAllStations[id].xyredrawBtn =
	    XmCreatePushButton(GbAllStations[id].xystatAppForm, "Ok", wars, n);
	XtManageChild( GbAllStations[id].xyredrawBtn);

	XtAddCallback(GbAllStations[id].xyredrawBtn, XmNactivateCallback,
	    SFcompleteXYdraw, id);

	XtAddCallback(GbAllStations[id].xydrawarea, XmNinputCallback,
	    SFcompleteXYdraw, id);

	gcv.line_width = 1;
	gcv.foreground = navdefaultBlackColor;
	gcv.background = navdefaultWhiteColor;
	gcmask = GCForeground  | GCLineWidth | GCBackground;
	GbAllStations[id].xydrawGC = XtGetGC(mw, gcmask, &gcv);

	gcv.foreground = navdefaultRedColor;
	GbAllStations[id].xyhorzGC = XtGetGC(mw, gcmask, &gcv);

	gcv.foreground = navdefaultBlueColor;
	GbAllStations[id].xyvertGC = XtGetGC(mw, gcmask, &gcv);

	GbAllStations[id].stnfontPtr = XLoadQueryFont(XtDisplay(mw), "fixed");
	if (GbAllStations[id].stnfontPtr == NULL)
		printf("\n  NULL FONT FOR STATION **** ");
	else 
	{
		fptr = GbAllStations[id].stnfontPtr ;
		gcv.foreground = navdefaultRedColor;
		gcv.font = fptr->fid;
		gcmask = GCForeground  | GCLineWidth | GCFont;
		GbAllStations[id].xyaxesGC = XtGetGC(mw, gcmask, &gcv);
	}
}

static int SFcompleteXYdraw(Widget parent, int id, caddr_t cp)
{
	Widget draw;
	int 	  ddx,ddy, sdx,sdy;
	double maxX,maxY,minX,minY, scX, scY;
	int    i, count, n;
	Dimension ht, wd;
	Arg wars[4];
	XPoint *xlist;
	HISTORYITEM *hptr;
	char tempstr[32];

	count = GbAllStations[id].coor.numitems;
	if (count < 2) return;
	xlist = (XPoint *)XtMalloc(sizeof(XPoint) * count);
	draw = GbAllStations[id].xydrawarea;
	hptr = GbAllStations[id].coor.qptr;
	maxX = hptr->x;
	maxY = hptr->y;
	minX = hptr->x;
	minY = hptr->y;
	for (i = 1; i < count; i++)
	{
		hptr++;
		if (maxX < hptr->x) maxX = hptr->x;
		if (maxY < hptr->y) maxY = hptr->y;
		if (minX > hptr->x) minX = hptr->x;
		if (minY > hptr->y) minY = hptr->y;
	}

	/* 
 * Determine the screen width and height 
 */
	n = 0;
	XtSetArg(wars[n], XmNheight, &ht); 
	n++;
	XtSetArg(wars[n], XmNwidth, &wd); 
	n++;
	XtGetValues(draw,wars,n);

	wd -= 10;
	ht -= 10;

	XClearArea(XtDisplay(draw),XtWindow(draw),0,0,0,0,False);

	XDrawLine(XtDisplay(draw),XtWindow(draw),GbAllStations[id].xyvertGC, 
	    10,ht - 10,wd, ht - 10);

	sdy = (int)(ht - 10);
	ddx = (int)(wd / 10);
	for (i = 1; i < 10; i++)
	{
		sdx = (int)(ddx * i);
		XDrawLine(XtDisplay(draw),XtWindow(draw),GbAllStations[id].xyhorzGC, 
		    sdx, sdy, sdx, sdy - 10);
	}

	sdx = 10;
	ddy = ht / 10;
	for (i = 1; i < 10; i++)
	{
		sdy = ddy * i;
		XDrawLine(XtDisplay(draw),XtWindow(draw),GbAllStations[id].xyhorzGC, 
		    sdx, sdy, sdx + 10, sdy);
	}

	XDrawLine(XtDisplay(draw),XtWindow(draw),GbAllStations[id].xyvertGC, 
	    10,10,10, ht - 10);

	scX = (double)(wd)/(maxX - minX);
	scY = (double)(ht)/(maxY - minY);

	hptr = GbAllStations[id].coor.qptr;
	for (i = 1; i < count; i++)
	{
		xlist[i].x =  10 + (short)(scX * (hptr->x - minX));
		xlist[i].y =  (short)ht - (short)(scY * (hptr->y - minY)) + 10;
		hptr++;
	}
	XDrawLines(XtDisplay(draw),XtWindow(draw),GbAllStations[id].xydrawGC, 
	    xlist, count, CoordModeOrigin);

	sprintf(tempstr,"%6.1lf,%6.1lf",minY,minX);
	XDrawString(XtDisplay(draw),XtWindow(draw),GbAllStations[id].xyaxesGC, 
	    0,ht-2, tempstr, strlen(tempstr));
	sprintf(tempstr,"%6.1lf",maxY);
	XDrawString(XtDisplay(draw),XtWindow(draw),GbAllStations[id].xyaxesGC, 
	    10,10, tempstr, strlen(tempstr));

	sprintf(tempstr,"%6.1lf",maxX);
	XDrawString(XtDisplay(draw),XtWindow(draw),GbAllStations[id].xyaxesGC, 
	    wd - 10, ht-2, tempstr, strlen(tempstr));

	XtManageChild(draw);
	XtFree(xlist);
}


/* 
 *	Station Selection Procedure here.  
 */
int SFSSmakeSelectBox(Widget parent,int *id, caddr_t cp);
static int SFSgetStationName(Widget myw,int *id, 
XmSelectionBoxCallbackStruct *cp);

Widget   SFSselection = NULL;

int SFSSmakeSelectBox(Widget parent,int *id, caddr_t cp)
{
	int ndx, n, count;
	Arg wars[20];
	XmString *xlist;
	Widget okay;
	char tempname[64];
	NIM *nimptr;

	if (SFSselection != NULL)
	{
		XtManageChild(SFSselection);
		return;
	}
	nimptr = navmainGetNimPtr();
	xlist = (XmString *)
	    XtMalloc(sizeof(XmString) * G_NAV_NUM_STATIONS(nimptr));

	count = 0;
	for (ndx =0; ndx < G_NAV_NUM_STATIONS(nimptr); ndx++)
	{
		sprintf(tempname,"%s", GbAllStations[ndx].alias);
		xlist[ndx] = XmStringCreate(tempname, XmSTRING_DEFAULT_CHARSET);
	}

	n = 0;
	XtSetArg(wars[n], XmNlistItems, xlist); 
	n++;
	XtSetArg(wars[n], XmNlistItemCount, ndx ); 
	n++;
	SFSselection = XmCreateSelectionDialog(parent,"Stations",wars,n);
	XtManageChild(SFSselection);
	*id = -1;
	XtAddCallback(SFSselection ,XmNokCallback, SFSgetStationName, id);
	XtUnmanageChild(XmSelectionBoxGetChild(SFSselection,XmDIALOG_HELP_BUTTON));

	for (n=0; n < ndx; n++) XmStringFree(xlist[n]);
	XtFree(xlist);
}

static int SFSgetStationName(Widget myw,int *id, 
XmSelectionBoxCallbackStruct *cp)
{
	int n;
	XmString xmstr;
	NIM *nimptr;

	nimptr = navmainGetNimPtr();

	for (n = 0; n < G_NAV_NUM_STATIONS(nimptr); n++)
	{
		xmstr = XmStringCreate(GbAllStations[n].alias,XmSTRING_DEFAULT_CHARSET);
		if (XmStringCompare(xmstr,cp->value))
		{
			*id = n;
			XmStringFree(xmstr);
			printf("\n found!");
			/* 
		 * Call the function to create the station display here. 
		 */
			SFSmakeStationShell(myw, n);
			return;
		}
		XmStringFree(xmstr);
	}
}

SFfreeAllGraphics()
{
	int i;
	NIM *nimptr;
	nimptr = navmainGetNimPtr();

	for (i=0; i < G_NAV_NUM_STATIONS(nimptr); i++)
	{
		if (GbAllStations[i].xydrawarea == NULL) continue;
		XFreeFont(XtDisplay(GbAllStations[i].xydrawarea),
		    GbAllStations[i].stnfontPtr);
		XFreeGC(XtDisplay(GbAllStations[i].xydrawarea),GbAllStations[i].xydrawGC);
		XFreeGC(XtDisplay(GbAllStations[i].xydrawarea),GbAllStations[i].xyhorzGC);
		XFreeGC(XtDisplay(GbAllStations[i].xydrawarea),GbAllStations[i].xyvertGC);
		XFreeGC(XtDisplay(GbAllStations[i].xydrawarea),GbAllStations[i].xyaxesGC);
	}
}
