#include <X11/X.h>
#include "stdlib.h"
#include "stdio.h"
#include "math.h"
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/PushB.h>
#include <Xm/Form.h>
#include "LineChart.h"

#define MAKE_BTN_ON_FORM(form,btn,x,y,w,h,str) \
	n = 0; 	\
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_POSITION ); n++; \
	XtSetArg(wars[n], XmNrightPosition, (x+w)); n++; \
	XtSetArg(wars[n], XmNleftPosition, (x)); n++; \
	XtSetArg(wars[n], XmNtopPosition, (y)); n++; \
	XtSetArg(wars[n], XmNbottomPosition, (h+y)); n++; \
	btn = XmCreatePushButton(form,str,wars,n); \
	XtManageChild(btn)

#define  ScrnWidth 500 
#define  ScrnHt    400
#define MAXITEMS 10

Widget mainShell, 
	  mainApp, 
       mainForm,
	  plotLChart, 
	  plotBChart,
	  otherPBtn,
	  donePBtn; 

unsigned long WhiteColor, 
		    BlackColor,
		    BlueColor, 
		    RedColor,
		    GreenColor;
	
int one[MAXITEMS] = { -10. -5, 0, 15, 20, 15 ,0, -5, -10, -5 }; 
int two[MAXITEMS] = { 4, 13, 13, 10 ,11, 9, 4, -11, -13, -11 }; 

void exitCB(); 
int  toggleCB(); 
unsigned long str2pix(char *spec, Widget w); 

int main(int argc, char *argv[])
{
	Arg wars[24];
	XGCValues  gcv;
	XtGCMask  gcmask;
	XFontStruct *fptr;
	char strName[24];
	int FormHt = 88;
	int margin = 10; 
	int dw = 30; 
	int dh = 10;
	int h1 = margin; 
	int h2 = margin + dw + dh; 
	int DispHt, DispWd, ivalue, n, i, imax, imin, imid; 


	mainShell = XtInitialize(argv[0],"Demo", NULL, NULL, 
			&argc, argv) ;
	n =0;
	XtSetArg(wars[n], XmNwidth, 500); n++;
	XtSetArg(wars[n], XmNheight, 400); n++;
	XtSetArg(wars[n], XmNiconic, False ); n++;
	XtSetArg(wars[n], XmNiconName, "TestMe"); n++;
	XtSetValues(mainShell,wars,n); 	
	XtRealizeWidget(mainShell);

	n=0;
	XtSetArg(wars[n], XmNwidth, 500); n++;
	XtSetArg(wars[n], XmNheight, 400); n++;
	mainForm = XmCreateForm(mainShell,"mainForm",wars,n);
	XtManageChild( mainForm );

MAKE_BTN_ON_FORM(mainForm,otherPBtn,h1,FormHt,dw,dh,"Next");
MAKE_BTN_ON_FORM(mainForm,donePBtn,h2,FormHt,dw,dh,"Done");

	XtAddCallback(otherPBtn,XmNactivateCallback, toggleCB, NULL);
	XtAddCallback(donePBtn,XmNactivateCallback, exit, NULL);


	imax = -100; imin = 100; 
	for (i=0; i< MAXITEMS;i++)
		{
		ivalue  = one[i]; 
		if (imax < ivalue) imax = ivalue;
		if (imin > ivalue) imin = ivalue;
		ivalue  = two[i]; 
		if (imax < ivalue) imax = ivalue;
		if (imin > ivalue) imin = ivalue;
		}

	imid = imin + 1; 

	printf("\n Min = %d  Mid = %d  Max = %d", imin,imid,imax); 

	WhiteColor = str2pix("White", mainForm);  
     BlackColor = str2pix("Black", mainForm); 
     BlueColor = str2pix("Blue", mainForm);  
     RedColor = str2pix("Red",mainForm); 
     GreenColor = str2pix("Green", mainForm); 

	sprintf(strName,"%d,%d",imax,imin);
	n = 0;
	XtSetArg(wars[n], XmNheight, DispHt); n++;
	XtSetArg(wars[n], XmNwidth, DispWd); n++;
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_POSITION ); n++;
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_POSITION ); n++;
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_POSITION ); n++;
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_POSITION ); n++;
	XtSetArg(wars[n], XmNleftPosition, 5 ); n++;
	XtSetArg(wars[n], XmNrightPosition, 95); n++;
	XtSetArg(wars[n], XmNtopPosition, 5 ); n++;
	XtSetArg(wars[n], XmNbottomPosition, 75 ); n++;
	XtSetArg(wars[n], XmNforeground, BlackColor); n++;
	XtSetArg(wars[n], XmNbackground, WhiteColor); n++;
	XtSetArg(wars[n], XtNitems, one); n++;
	XtSetArg(wars[n], XtNauxItems, two); n++;
	XtSetArg(wars[n], XtNitemCount, MAXITEMS); n++;
	XtSetArg(wars[n], XtNmaxItemCount, MAXITEMS); n++;
	XtSetArg(wars[n], XtNmaxValue, imax); n++;
	XtSetArg(wars[n], XtNmidValue, imid); n++;
	XtSetArg(wars[n], XtNminValue, imin); n++;
	XtSetArg(wars[n], XtNzeroColor, BlueColor); n++;
	XtSetArg(wars[n], XtNpositiveColor, BlueColor); n++;
	XtSetArg(wars[n], XtNnegativeColor, RedColor); n++;
	plotLChart = XtCreateWidget("cluso", 
	    XvlinechartWidgetClass, mainForm, wars, n);


	imid = (imax + imin) / 2; 

	n = 0;
	XtSetArg(wars[n], XmNheight, DispHt); n++;
	XtSetArg(wars[n], XmNwidth, DispWd); n++;
	XtSetArg(wars[n], XmNforeground, BlackColor); n++;
	XtSetArg(wars[n], XmNbackground, WhiteColor); n++;
	XtSetArg(wars[n], XmNleftAttachment, XmATTACH_POSITION ); n++;
	XtSetArg(wars[n], XmNrightAttachment, XmATTACH_POSITION ); n++;
	XtSetArg(wars[n], XmNtopAttachment, XmATTACH_POSITION ); n++;
	XtSetArg(wars[n], XmNbottomAttachment, XmATTACH_POSITION ); n++;
	XtSetArg(wars[n], XmNleftPosition, 5 ); n++;
	XtSetArg(wars[n], XmNrightPosition, 95); n++;
	XtSetArg(wars[n], XmNtopPosition, 5 ); n++;
	XtSetArg(wars[n], XmNbottomPosition, 75 ); n++;
	XtSetArg(wars[n], XtNitems, one); n++;
	XtSetArg(wars[n], XtNauxItems, two); n++;
	XtSetArg(wars[n], XtNitemCount, MAXITEMS); n++;
	XtSetArg(wars[n], XtNmaxItemCount, MAXITEMS); n++;
	XtSetArg(wars[n], XtNmaxValue, imax); n++;
	XtSetArg(wars[n], XtNmidValue, imid); n++;
	XtSetArg(wars[n], XtNminValue, imin); n++;
	XtSetArg(wars[n], XtNmaxShowValue, imax); n++;
	XtSetArg(wars[n], XtNminShowValue, imin); n++;
	XtSetArg(wars[n], XtNzeroColor, BlueColor); n++;
	XtSetArg(wars[n], XtNpositiveColor, BlueColor); n++;
	XtSetArg(wars[n], XtNnegativeColor, RedColor); n++;
	plotBChart = XtCreateManagedWidget("cluso", 
	    XvbarchartWidgetClass, mainForm, wars, n);

	XtManageChild(mainForm);
	XtRealizeWidget(mainShell); 
	XtMainLoop(); 

}


/*
**
*/
void exitCB()
{
exit(0); 
}


static ToggleFlag = 1; 

int  toggleCB()
{
if (ToggleFlag) {
	XtUnmanageChild(plotBChart);
	XtManageChild(plotLChart);
 	ToggleFlag = 0; 
	}
	else {
	XtManageChild(plotBChart);
	XtUnmanageChild(plotLChart);
 	ToggleFlag = 1; 
	}
}

/*
char *spec;      color name
Widget w;        a widget pointer 
*/
unsigned long str2pix(char *spec, Widget w)
{
	Colormap cmap;
	XColor color_struct;			/* For this color     */
	Display  *dpy;			/* Curent display     */
	static void *ht = NULL;		/* hash table pointer */

	dpy = XtDisplay(w);

	/* 
	 * Get color map
	 */
	cmap = XDefaultColormap(dpy, DefaultScreen(dpy));

	/*
 	* Parse the color specification
 	*/
	if (!XParseColor(dpy, cmap, spec, &color_struct)) {
		printf("Invalid color name (%s)\n",spec);
		exit(1);
	}

	/*
 	* Try to allocate the color
 	*/
	if (!XAllocColor(dpy, cmap, &color_struct)) {
		printf("Cannot allocate color in colormap\n");
		exit(1);
	}

	/*
 	* Return the allocated color
 	*/
	return(color_struct.pixel);
}
