#include <stdlib.h>

#include "wndx.h"
#include "list.h"
#include "listitem.h"

#include "h_stddef.h"
#include "h_list.h"
#include "hwx.h"

#include "main.h"

void HWB_BigBrowseList( int	 		lMessage ,
  				   		int     	lSelect ,
						WX_rect     *lRect ,
						WX_point    *lCell ,
						int      	lType ,
						void      	*lData ,
						int       	lLen ,
						LST_Ptr   	lHandle )
  
  {
	WX_rect     	R;
	lpList			pInstance;

    if ( lMessage == LST_DrawMsg )
      {
        WX_Mode( WX_REP );
        R = *lRect;
        WX_InsetRect( &R , 2 , 0 );
        R.top++;
		R.left++;

		pInstance = HWX_GetInstanceData( ( lpList * ) lHandle->userHandle , lCell->Y , lCell->X );

		HWB_RenderInstance( lHandle->window , pInstance , &R );

		WX_MoveTo( lRect->left , lRect->bottom );
		WX_LineTo( lRect->right , lRect->bottom );
		WX_LineTo( lRect->right , lRect->top );
          
		if ( lSelect & LST_Maybe )
		  WX_FrameRect( lRect );
	  }
  }

int	CloseBigBrowser(DLG_Ptr dp)
  {
	free(DLG_GetDp(dp, HWB_DRAWOPTIONS));
	return TRUE;
  }

int	HWB_BigBrowserView( struct WND_Record *dp , int itemNo, struct EVNT_Record *ev,
						int action, int msg, void *data)
  {
    char		*fileName;
	WX_point	whichOne;
	
	if ( action == DLG_hadDoubleClick )
	  {
	    DLG_Get( dp , dlg_filename , NULL , &fileName );

		DLG_GetItemCopy( dp , itemNo , itmList_lastClick , sizeof( WX_point ) , &whichOne );
		
		HWB_Instance( (lpList*) DLG_GetDp(dp, HWB_CHARDATA),
					  fileName ,
					  DLG_GetDp(dp, HWB_DRAWOPTIONS),
					  whichOne.Y , whichOne.X );
					  
		DLG_SetIItem( dp, itemNo, itm_highlight, FALSE );
	  }
	return TRUE;
  }

DLG_Ptr	HWB_BigBrowser( lpList CharData[] , char *fileName , DrawOptions *draw_opt , int defChar )

  {
    DLG_Ptr		dp;
	LST_Handle	LH;
	WX_rect		R;
	DrawOptions	*drw_opt;
	WX_point	defCell;
	
	dp = DLG_New( dlg_title , fileName ,
				  dlg_centered_xy , 215 , 215 ,
				  dlg_visible , FALSE ,
				  dlg_filename , fileName ,
				  dlg_close, CloseBigBrowser,
				  dlg_menuname , "Options" ,
				  0 );

	DLG_SetDp( dp , HWB_CHARDATA , CharData );

	drw_opt = malloc(sizeof( DrawOptions ));
	*drw_opt = *draw_opt;
	DLG_SetDp(dp, HWB_DRAWOPTIONS, drw_opt);

	DLG_GetCopy( dp , dlg_content , sizeof( WX_rect ) , &R );				  

	DLG_AddItem( dp ,
				 listItm , "test" ,
					itm_action , HWB_BigBrowserView ,
					itm_placement , 0 , 0 , 1000 , 1000 ,
					itmList_top , 0 ,
					itmList_left , 0 ,
					itmList_defWidth , 50 ,
					itmList_defHeight , 50 ,
					itmList_verticalScroll ,  TRUE ,
					itmList_horizontalScroll , TRUE ,
					itmList_ReframeCellV , TRUE ,
					itmList_ReframeCellH , TRUE ,
					itmList_active , TRUE ,
					itmList_DoDraw , TRUE ,
					itmList_OnlyOne , TRUE ,
					itmList_rows , 128 , /* the defined maximum number of
										    characters */
					itmList_columns  , 20 ,
					0 );

	DLG_SetPpItem( dp , 1 , itmList_defProc , ( iFunc ) HWB_BigBrowseList );

	LH = ( LST_Handle ) DLG_GetDpItem( dp , 1 , itmList_handle );

	LH->userHandle = CharData;
	LST_CalcVisible( LH );

	if ( ( defCell.Y = defChar ) >= 0 )
	  {
	    defCell.X = 0;

		LST_MakeVisible( &defCell , TRUE , FALSE , LH );
	  }

	DLG_Draw( dp );

	return dp;
  }
