#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "wndx.h"
#include "list.h"
#include "select.h"
#include "listitem.h"

#include "h_stddef.h"
#include "h_list.h"
#include "hwx.h"

#include "hwb.h"
#include "main.h"

int HWB_RenderInstance( DLG_Ptr dp , lpList pInstance , WX_rect *pR )

  {
	WX_rect			boundingBox;
	WND_WindowState	state;
	DrawOptions		*draw_opt;
	WX_rect			R;
	
	if ( pInstance == NULL )
	  WX_EraseRect( pR );
	else
	  {
		WND_SaveState(&state);
		if (DLG_GetCopy( dp , HWB_DRAWOPTIONS, sizeof(DrawOptions*), &draw_opt))
		  {
			WX_PenSize(draw_opt->width, draw_opt->width);
			WX_PenColor(draw_opt->foreground);
			WX_BackColor(draw_opt->background);
		  }

		HWX_CalcInstanceBoundingBox( pInstance , &boundingBox );

		WX_EraseRect( pR );

		R = *pR;
		WX_InsetRect( &R , draw_opt->margin , draw_opt->margin );
		
		HWX_NormalizeAndDisplayInstance( pInstance , &boundingBox , &R , TRUE );
		
		WND_RestoreState(&state);
	  }

	return pInstance != NULL;
  }

void HWB_SampleList( int	 	lMessage ,
  			   		 int     	lSelect ,
					 WX_rect    *lRect ,
					 WX_point   *lCell ,
					 int      	lType ,
					 void      	*lData ,
					 int       	lLen ,
					 LST_Ptr   	lHandle )

  {
	WX_rect     	R;
	lpList			pInstance;
    
    if ( lMessage == LST_DrawMsg )
      {
        WX_Mode( WX_REP );
        R = *lRect;
        WX_InsetRect( &R , 2 , 0 );
        R.top++;
		R.left++;

		pInstance = HWX_GetInstanceData( ( lpList * ) lHandle->userHandle , ( int ) lHandle->refCon - 1 , lCell->Y - 1 );

		R.right = R.left + ( R.bottom - R.top + 1 );
		HWB_RenderInstance( lHandle->window , pInstance , &R );

		WX_MoveTo( lRect->left , lRect->bottom );
		WX_LineTo( lRect->right , lRect->bottom );

		if ( lSelect & LST_Maybe )
		  WX_FrameRect( lRect );

		if ( lSelect & LST_Highlighted )
		  WX_InvertRect( lRect );
	  }
	else if ( lMessage == LST_HiliteMsg )
	  {
		if ( ( lHandle->selFlags & LST_Edit ) &&
			 ( lSelect & LST_Static ) == 0 )
		  UT_InvertFrame( lRect );
		else
		  WX_InvertRect( lRect );
	  }
  }

void HWB_CharList( int	 		lMessage ,
  			   	   int     		lSelect ,
				   WX_rect    	*lRect ,
				   WX_point   	*lCell ,
				   int      	lType ,
				   void      	*lData ,
				   int       	lLen ,
				   LST_Ptr   	lHandle )
  
  {
    WX_rect     	R;
	char			charDesc[ 40 ];
	char			c;
	FONT_FontInfo	fi;
    
    if ( lMessage == LST_DrawMsg )
      {
        WX_Mode( WX_REP );
        R = *lRect;
        WX_InsetRect( &R , 2 , 0 );
        R.top++;
		R.left++;

		c = isprint( lCell->Y - 1 ) ? ( lCell->Y - 1 ) : ' ';
		
		sprintf( charDesc , "0x%2.2x %c" , lCell->Y - 1 , c );
		
		FONT_GetFontInfo( WND_GetI( lHandle->window , dlg_font ) , &fi );
		WX_MoveTo( lRect->left + 2 , lRect->top + fi.ascent + 1 );
			
        WX_DrawText( charDesc , 0 , strlen( charDesc ) );

		if ( lSelect & LST_Maybe )
		  WX_FrameRect( lRect );

		if ( lSelect & LST_Highlighted )
		  WX_InvertRect( lRect );
	  }
	else if ( lMessage == LST_HiliteMsg )
	  {
		if ( ( lHandle->selFlags & LST_Edit ) &&
			 ( lSelect & LST_Static ) == 0 )
		  UT_InvertFrame( lRect );
		else
		  WX_InvertRect( lRect );
	  }
  }

void HWB_DisplayList( int	 		lMessage ,
					  int     		lSelect ,
					  WX_rect    	*lRect ,
					  WX_point   	*lCell ,
					  int      		lType ,
					  void      	*lData ,
					  int       	lLen ,
					  LST_Ptr   	lHandle )
  
  {
    WX_rect     	R;
	lpList			pInstance;
	WX_point		*pWhichOne;
    
    if ( lMessage == LST_DrawMsg )
      {
        WX_Mode( WX_REP );
        R = *lRect;
        WX_InsetRect( &R , 2 , 0 );
        R.top++;
		R.left++;

		if ( lLen != sizeof( WX_point ) )
		  pInstance = NULL;
		else
		  {
		    pWhichOne = ( WX_point * ) lData;
		    pInstance = HWX_GetInstanceData( ( lpList * ) lHandle->userHandle ,
											 pWhichOne->X, pWhichOne->Y );
		  }

		HWB_RenderInstance( lHandle->window , pInstance , &R );
	  }
  }

DLG_Ptr	HWB_OpenBrowser( char *rFileName )

  {
	lpList		*CharData;
	DLG_Ptr		dp;
	LST_Handle	LH;
	DrawOptions	*drw_opt;
	WX_rect		R;

	WX_SetCursor( WX_hourglass );
	CharData = HWX_LoadData( rFileName );
	WX_SetCursor( WX_arrow );

	if ( CharData == NULL )
	  {
		ALRT_Alert( "Failed to open data file '%s'" , rFileName );
		return NULL;
	  }

	dp = DLOG_New( 3000 );

	drw_opt = malloc(sizeof(DrawOptions));
	drw_opt->width = DFLT_Get(HWB_DFLTLINEWIDTH);
	drw_opt->foreground = DFLT_GetL(DFLT_WindowTextColor);
	drw_opt->background = DFLT_GetL(DFLT_WindowBackgroundColor);
	drw_opt->margin = 2;
	DLG_SetDp(dp, HWB_DRAWOPTIONS, drw_opt);

	DLG_SetDp( dp , HWB_CHARDATA , CharData );
	DLG_Set( dp , dlg_filename , strlen( rFileName ) + 1 , rFileName );
	
	DLG_Set( dp , dlg_title , strlen( rFileName ) + 1 , rFileName );

	DLG_SetPp( dp , dlg_filter , DLG_StdFilter );

	DLG_SetPpItem( dp , SAMPLES_ITEM , itmList_defProc , ( iFunc ) HWB_SampleList );
	DLG_SetIItem( dp , SAMPLES_ITEM , itmList_defHeight , 2 * DLG_GetIItem( dp , SAMPLES_ITEM , itmList_defHeight ) );
	LH = ( LST_Handle ) DLG_GetDpItem( dp , SAMPLES_ITEM , itmList_handle );
	LH->userHandle = CharData;
	LH->refCon = 0l;
	
	DLG_SetPpItem( dp , CHAR_ITEM , itmList_defProc , ( iFunc ) HWB_CharList );
	LH = ( LST_Handle ) DLG_GetDpItem( dp , CHAR_ITEM , itmList_handle );
	LH->userHandle = CharData;

	SLCT_Update( dp , CHAR_ITEM , FALSE );
	DLG_SetIItem( dp , CHAR_ITEM , itmList_rows , 128 );

	DLG_SetPpItem( dp , DISPLAY_ITEM , itmList_defProc , ( iFunc ) HWB_DisplayList );
	DLG_SetIItem( dp , DISPLAY_ITEM , itmList_left , 0 );
	DLG_SetIItem( dp , DISPLAY_ITEM , itmList_top , 0 );
	DLG_SetIItem( dp , DISPLAY_ITEM , itmList_horizontalScroll , TRUE );
	SLCT_Update( dp , CHAR_ITEM , TRUE );
	
	LH = ( LST_Handle ) DLG_GetDpItem( dp , DISPLAY_ITEM , itmList_handle );
	LH->userHandle = CharData;

	DLG_SetIItem( dp , DISPLAY_ITEM , itmList_rows , 1 );
	DLG_SetIItem( dp , DISPLAY_ITEM , itmList_active , TRUE );

	DLG_GetItemCopy( dp , DISPLAY_ITEM , itmList_view , sizeof( WX_rect ) , &R );

	DLG_SetIItem( dp , DISPLAY_ITEM , itmList_defHeight , R.bottom - R.top + 1 );
	DLG_SetIItem( dp , DISPLAY_ITEM , itmList_defWidth , R.bottom - R.top + 1 );

	return dp;
  }

void DisplaySetCell( DLG_Ptr dp , int cellNo , int ch , int instance )

  {
	WX_point	data;

	DLG_SetIItem( dp , DISPLAY_ITEM , itmList_columnno , cellNo );
	DLG_SetIItem( dp,  DISPLAY_ITEM , itmList_rowno , 0 );
	
	DLG_SetIItem( dp,  DISPLAY_ITEM , itmList_setType , LST_unknown );
	
    data.X = ch;
	data.Y = instance;
	
	DLG_SetItem( dp , DISPLAY_ITEM , itmList_itemdata , sizeof( WX_point ) , &data );
  }

void DisplayAddCell( DLG_Ptr dp , int ch , int instance )

  {
    int			c;

	c = DLG_GetIItem( dp , DISPLAY_ITEM , itmList_columns );
	DLG_SetIItem( dp , DISPLAY_ITEM , itmList_columns , c + 1 );

	DisplaySetCell( dp , c , ch , instance );
  }

void Clear_Phrase( DLG_Ptr dp )

  {
	DLG_SetIItem( dp , DISPLAY_ITEM , itmList_columns , 0 );
  }

int BrClear( struct WND_Record *dp , int itemNo, struct EVNT_Record *ev,
				int action, int msg, void *data)

  {
	if (action == DLG_inButton && msg)
	  {
		Clear_Phrase( dp );
		DLG_SetIItem( dp , itemNo , itm_highlight , FALSE );
	  }

	return TRUE;
  }

/*
 *	menu selection procedure for standard phrases
 */

int Select_Standard( struct WND_Record *dp, int menu, int item,
                    struct EVNT_Record *ev )
  {
    int   		i;
    char  		buf[ 128 ];
	int			len;

    if( MENU_GetItem( menu, item, buf ) )
      {
	    Clear_Phrase( dp );
		
		DLG_SetIItem( dp , DISPLAY_ITEM , itmList_DoDraw , FALSE );
		DLG_SetIItem( dp , DISPLAY_ITEM , itmList_columns , len = strlen( buf ) );

		for ( i = 0; i < len; i++ )
		  DisplaySetCell( dp , i , buf[ i ] , 0 );

		DLG_SetIItem( dp , DISPLAY_ITEM , itmList_DoDraw , TRUE );
		DLG_DrawItem( dp , DISPLAY_ITEM );
	  }

    return TRUE;
  }

/*
 *	"Add To Phrase" push button (the default on Return)
 */

int	BrDisplay( struct WND_Record *dp , int itemNo, struct EVNT_Record *ev,
				int action, int msg, void *data)
  {
	if (action == DLG_inButton && msg)
	  {
		DisplayAddCell( dp ,
						(char) (SLCT_SelectedIdx(dp, CHAR_ITEM) - 1),
					    SLCT_SelectedIdx(dp, SAMPLES_ITEM) - 1);
	  	DLG_SetIItem( dp, itemNo, itm_highlight, FALSE );
	  }
	
	return TRUE;
  }

/*
 *	"Create Window" push button
 */

int	BrCreate( struct WND_Record *dp , int itemNo, struct EVNT_Record *ev,
				int action, int msg, void *data)
  {
    char	*fileName;
	
	if (action == DLG_inButton && msg)
	  {
	    DLG_Get( dp , dlg_filename , NULL , &fileName );
		
		HWB_Instance( (lpList*) DLG_GetDp(dp, HWB_CHARDATA),
					  fileName ,
					  DLG_GetDp(dp, HWB_DRAWOPTIONS),
					  (char) (SLCT_SelectedIdx(dp, CHAR_ITEM) - 1),
					  SLCT_SelectedIdx(dp, SAMPLES_ITEM) - 1);
		DLG_SetIItem( dp, itemNo, itm_highlight, FALSE );
	  }
	return TRUE;
  }

/*
 *	Show all samples button - create matrix window.
 */

int	BrShowAll( struct WND_Record *dp , int itemNo, struct EVNT_Record *ev,
				int action, int msg, void *data)
  {
    char	*fileName;
	
	if (action == DLG_inButton && msg)
	  {
	    DLG_Get( dp , dlg_filename , NULL , &fileName );
		
		HWB_BigBrowser( (lpList*) DLG_GetDp(dp, HWB_CHARDATA) ,
						fileName ,
						(DrawOptions*) DLG_GetDp(dp, HWB_DRAWOPTIONS) ,
						SLCT_SelectedIdx( dp , CHAR_ITEM ) - 1 );

		DLG_SetIItem( dp, itemNo, itm_highlight, FALSE );
	  }
	return TRUE;
  }

void BrSetCreateWindowEnable( DLG_Ptr dp )

  {
    int	state;
	
    state = SLCT_SelectedIdx( dp , CHAR_ITEM )  &&
			SLCT_SelectedIdx( dp , SAMPLES_ITEM );

	DLG_SetIItem( dp , CREATE_ITEM , itm_active , state );
	DLG_SetIItem( dp , OK_ITEM , itm_active , state );
  }

/*
 *	Character selection
 */

int	BrChar( struct WND_Record *dp , int itemNo, struct EVNT_Record *ev,
				int action, int msg, void *data)
  {
	LST_Handle		LH;
	int				instance;

	if ( action == DLG_inSelect || action == DLG_doSelect )
	  {
		BrSetCreateWindowEnable( dp );
		LH = DLG_GetDpItem( dp , SAMPLES_ITEM , itmList_handle );

		instance = SLCT_SelectedIdx( dp , itemNo ) - 1;

		SLCT_Update( dp , SAMPLES_ITEM , FALSE );
		LH->refCon = ( long ) instance + 1;
		DLG_SetIItem( dp , SAMPLES_ITEM , itmList_rows , HWX_GetInstanceCount( ( lpList * ) LH->userHandle , instance ) );

		SLCT_Update( dp , SAMPLES_ITEM , TRUE );
		return TRUE;
	  }

	return SLCT_DefaultAction( dp , itemNo , ev , action , msg , data );
  }

/*
 *	Sample selection
 */

int	BrSample( struct WND_Record *dp , int itemNo, struct EVNT_Record *ev,
				int action, int msg, void *data)
  {
    int	ch;
	
	if ( action == DLG_inSelect || action == DLG_doSelect )
	  {
		BrSetCreateWindowEnable( dp );

		if ( action == DLG_doSelect )
		  {
		    if ( ( ch = SLCT_SelectedIdx(dp, CHAR_ITEM) - 1 ) >= 0 )
		      DisplayAddCell( dp , ch , SLCT_SelectedIdx( dp , SAMPLES_ITEM ) - 1 );
		  }
		  
		return TRUE;
	  }

	return SLCT_DefaultAction( dp , itemNo , ev , action , msg , data );
  }

/*
 *	Selecting a standard phrase from a menu
 */

int	BrStandard( struct WND_Record *dp , int itemNo, struct EVNT_Record *ev,
				int action, int msg, void *data)
  {
	MENU_Invoke( dp, 3000, NULL, ev, NULL );
	DLG_SetIItem( dp, itemNo, itm_highlight, FALSE );
	return TRUE;
  }

int	BrCloseProc(DLG_Ptr dp)
  {
	DLG_Ptr	search, nextSearch;
	lpList			*charData;

	free(DLG_GetDp(dp, HWB_DRAWOPTIONS));
	
	charData = (lpList*) DLG_GetDp(dp, HWB_CHARDATA);

	for (search = WND_Front(WND_deskTop) ; search ; search = nextSearch)
	  {
		nextSearch = WND_Next(search);
		if ( search != dp && charData == (lpList*) DLG_GetDp(search, HWB_CHARDATA))
		  DLG_Dispose(search);
	  }
	HWX_UnloadData(charData);

	return TRUE;
  }

void	BrActivate( struct WND_Record *wp , int active, int willRedraw )

  {
	MENU_SetItemEnable( HWB_FILEMENU , FILEMENU_CLOSE , active );
  }	

void BrItemProc( DLG_Ptr dp , int itm , EVNT_Record *pEv )

  {
    int	ch;
	int instance;
	
	if ( itm == OK_ITEM )
	  {
		if ( ( ch = SLCT_SelectedIdx( dp , CHAR_ITEM ) - 1 ) >= 0 &&
			 ( instance = SLCT_SelectedIdx( dp , SAMPLES_ITEM ) - 1 ) >= 0 )
		  DisplayAddCell( dp , ch , instance );
	  }
  }
