/*
	WNDX Interface Management
	Copyright (C) 1989, 1990, 1991, 1992 The WNDX Corporation.
	All rights resrved.

    The WNDX Corporation.
    Suite 305, 1550 - 8 St. S.W.
    Calgary, Alberta, Canada.
    T2R 1K1

    (403) 244-0995
 */
#include <stdio.h>
#include <stdlib.h>

#include "wndx.h"
#include "select.h"
#include "list.h"
#include "listitem.h"

#include "h_stddef.h"
#include "h_list.h"

#include "hwb.h"
#include "main.h"

void HWB_OptionsList( int	 		lMessage ,
  			   		  int     		lSelect ,
					  WX_rect 	   	*lRect ,
					  WX_point	   	*lCell ,
					  int	      	lType ,
					  void      	*lData ,
					  int       	lLen ,
					  LST_Ptr   	lHandle )

  {
	WX_rect     	R;
	int				center;
    
    if ( lMessage == LST_DrawMsg )
      {
        WX_Mode( WX_REP );
        R = *lRect;
        WX_InsetRect( &R , 2 , 0 );
        R.top++;
		R.left++;

		WX_PenSize( lCell->Y , lCell->Y );

		WX_MoveTo( R.left + 2 , center = ( R.bottom + R.top ) >> 1 );
		WX_LineTo( R.right - 2 , center );

		WX_PenSize( 1 , 1 );

		if ( lSelect & LST_Maybe )
		  WX_FrameRect( lRect );

		if ( lSelect & LST_Highlighted )
		  WX_InvertRect( lRect );
	  }
	else if ( lMessage == LST_HiliteMsg )
	  {
		if ( ( lHandle->selFlags & LST_Edit ) &&
			 ( lSelect & LST_Static ) == 0 )
		  UT_InvertFrame( lRect );
		else
		  WX_InvertRect( lRect );
	  }
  }

int 	ConfigureDrawing( DrawOptions *opts )
  {
	DLG_Ptr		optdp;
	int			done = FALSE, retCode = FALSE, res;
	long		val, min, max;
	char		*pstrValue, *pName;
	int			type;

	optdp = DLOG_New( HWB_DRAWOPTIONS_DLOG );

/* Set up the line width selbox.
*/
	DFLT_GetInfo( HWB_DFLTLINEWIDTH, &pstrValue, &type, &val, &min, &max, &pName );

	DLG_SetPpItem( optdp , HWB_DRAWOPT_LWSELBOX, itmList_defProc , ( iFunc ) HWB_OptionsList );

	DLG_SetIItem( optdp, HWB_DRAWOPT_LWSELBOX, itmList_rows , ( int ) max );

/* Set the current color according to what was passed in opts
*/
	SLCT_SetSelected( optdp , HWB_DRAWOPT_LWSELBOX , opts->width );
    DLG_SetLItem( optdp, HWB_DRAWOPT_FORE, itm_value, opts->foreground );
    DLG_SetLItem( optdp, HWB_DRAWOPT_BACK, itm_value, opts->background );

	while (!done)
	  {
		res = DLG_SimpleModal( optdp );
		switch ( res )
		  {
		  case HWB_DRAWOPT_OK:

			opts->foreground = DLG_GetLItem( optdp, HWB_DRAWOPT_FORE, itm_value );
			opts->background = DLG_GetLItem( optdp, HWB_DRAWOPT_BACK, itm_value );

			opts->width = SLCT_SelectedIdx( optdp, HWB_DRAWOPT_LWSELBOX );
			retCode = TRUE;

		  case HWB_DRAWOPT_CANCEL:
			done = TRUE;
			break;
		  }
	  }

	DLG_Dispose( optdp );
	return retCode;
  }

int		HWB_Help(struct WND_Record *wp, int menu, int item, struct EVNT_Record *ev)

  {
  	DrawOptions testo;

	testo.width = 4;
	testo.foreground = WX_BLACK;
	testo.background = WX_WHITE;

	ConfigureDrawing( &testo );

	return( TRUE );
  }


int	HWB_Configure(struct WND_Record *wp, int menu, int item, struct EVNT_Record *ev)
  {
	WX_rect		R;
	DrawOptions	*draw_opt;

	if (!DLG_GetCopy(wp, HWB_DRAWOPTIONS, sizeof(DrawOptions*), &draw_opt))
	  return 0;
	  
	if (ConfigureDrawing(draw_opt))
	  {
		DLG_GetCopy( wp , dlg_content , sizeof( WX_rect ) , &R );

		WND_SetDrawable( wp );
		WND_InvalidateRect( &R );
	  }

	return item;
  }

