/****************************************************************
| 
|  code heavily borrowed from DOSBROWS.C --
|  LMain Module for DOS-based Handwriting Data Browser
|      by Ray Valdes, DDJ
\****************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "wndx.h"
#include "ioref.h"

#include "h_stddef.h"
#include "h_list.h"
#include "hwx.h"

/****************************************************************/
int HWX_GetInstanceCount( lpList CharData[] , int ch )

  {
    if ( CharData[ ch ] )
	  return CharData[ ch ]->num_items;
    else
	  return 0;
  }
  
/****************************************************************/
lpList HWX_GetInstanceData( lpList CharData[] , int ch , int inst )

  {
	lpList 	pChar;
	
    if ( ch < 0 || ch >= MAX_CHARS )
	  return NULL;
	  
	if( ( pChar = CharData[ ch ] ) == NULL )
	  return NULL;

	if ( inst < 0 || inst >= pChar->num_items )
	  return NULL;

	return pChar->items[ inst ];
  }
  
/***************************************************************
|    OTHER SUPPORTING ROUTINES
\****************************************************************/
void HWX_UnloadData( lpList CharData[] )

  {
    INT16 i,j,k;
	
    for (i = 0; i < MAX_CHARS; i++) if (CharData[i]) 
      {
	    if ( CharData[ i ] != NULL )
		  {
        	for (j = 0; j < CharData[i]->num_items; j++) 
	 		  {
        	    lpList char_instance = CharData[i]->items[j];
        	    for (k = 0; k < char_instance->num_items; k++)
					free(char_instance->items[k]);
				free(char_instance);
        	  }
			free(CharData[i]);
        	CharData[i] = NULL;
		  }
      }
	free( CharData );
  }
  
/****************************************************************/
static int HWX_ReadHeader( struct IO_Stream *pIO )

  {
    INT16 signature,header_size,version_major,version_minor;
	
    signature = IO_ReadShort( pIO );
	
    if( signature != FILE_SIGNATURE )
	  return FALSE;
	  
    header_size = IO_ReadShort( pIO ); //number of bytes should be even
    if( header_size & 01 )
	  return FALSE;
	  
    header_size >>= 1;  // number of words
    header_size--;
	
    version_major = IO_ReadShort( pIO ); header_size--;
	
    version_minor = IO_ReadShort( pIO ); header_size--;
	
    while( header_size-- )
	  IO_ReadShort( pIO );

	return TRUE;
  }
  
/****************************************************************/
lpList *HWX_ParseDataFormat( struct IO_Stream *pIO )

  {
	WX_point Pt;
	WX_point *pPt;
	lpList   char_instance;
	lpList   stroke;
	INT16    i,j,k,num_strokes,num_pts,which;
	INT16    char_code,num_instances;
	lpList	 *CharData;
	int		 hadError = FALSE;

	CharData = ( lpList * ) malloc( sizeof( lpList ) * MAX_CHARS );

	for ( i = 0; i < MAX_CHARS; i++ )
	  CharData[ i ] = NULL;

	if ( !HWX_ReadHeader( pIO ) )
	  hadError = TRUE;
	else
	  {
		while ( !IO_Eof( pIO ) )
          {
			char_code = IO_ReadShort( pIO );
			if ( IO_Eof( pIO ) )
			  break;
        	num_instances = IO_ReadShort( pIO );

        	which = (char_code < MAX_CHARS) ? char_code : 1;
			CharData[ which ] = ( lpList ) malloc( sizeof(INT16) + (num_instances * sizeof(long)));
				
			if( !CharData[which])
			  {
			    hadError = TRUE;
				break;
			  }
				
        	CharData[which]->num_items = num_instances;
			
        	for (i = 0; i < num_instances; i++) 
			  {
				num_strokes = IO_ReadShort( pIO );
				if ( IO_Eof( pIO ) )
				  break;

				char_instance = ( lpList ) malloc(sizeof(INT16) + (num_strokes * sizeof(long)));
				if( !char_instance )
				  {
					hadError = TRUE;
					break;
				  }

				for ( j = 0; j < num_strokes; j++ )
				  char_instance->items[ j ] = NULL;

				char_instance->num_items = num_strokes;

				for (j = 0; j < num_strokes; j++)
				  {
					num_pts = IO_ReadShort( pIO );
					Pt.X = IO_ReadShort( pIO );
					Pt.Y = IO_ReadShort( pIO );

					if ( IO_Eof( pIO ) )
					  break;

					stroke = malloc(sizeof(INT16) + num_pts * sizeof(long));

					if(!stroke)
					  {
						hadError = TRUE;
						break;
					  }

					stroke->num_items = num_pts;
					pPt = ( WX_point * ) &stroke->items[ 0 ];

					*pPt++ = Pt;
					for (k = 1; k < num_pts; k++)
					  {
						INT16 s = IO_ReadShort( pIO );
						char *ps = (char *)&s;

						Pt.X += ps[1];
						Pt.Y += ps[0];
						*pPt ++ = Pt;
					  } /* for loop (k) */
					char_instance->items[j] = stroke;

				  } /* for loop (j) */
				CharData[which]->items[i] = char_instance;
			  }  /* for loop (i) */
		   } /*while loop */
	  } /*if*/

	if ( hadError )
	  {
	    HWX_UnloadData( CharData );
		CharData = NULL;
	  }

	return CharData;
  }
  
#define MIN_VALUE (-0x7FFF)
#define MAX_VALUE ( 0x7FFF)

void HWX_CalcInstanceBoundingBox(lpList char_instance,WX_rect *bb)

  {
    INT16 		i , j , v;
    INT16 		x_min,x_max,y_min,y_max;
	WX_point	*p;

	x_min = y_min = MAX_VALUE;
    x_max = y_max = MIN_VALUE;

    /*------for a given char, find the maximum and minimum -------*/
    for (i = 0; i < char_instance->num_items; i++) 
      {
        lpList    stroke =   char_instance->items[i];

		p = ( WX_point * ) &stroke->items[ 0 ];
		
        for (j = 0; j < stroke->num_items; j++ , p++ ) 
		  {
            if ( ( v = p->X ) > x_max)
			  x_max = v;
			  
            if ( v < x_min)
			  x_min = v;
			  
			if ( ( v = p->Y ) > y_max)
			  y_max = v;
			  
            if ( v < y_min)
			  y_min = v;
          }
      }

	WX_SetRect( bb , x_min , y_min , x_max , y_max );
  }
  
/****************************************************************/
void HWX_NormalizeAndDisplayInstance( lpList 	char_instance ,
									  WX_rect 	*pBoundingBox ,
									  WX_rect	*pDisplayRect ,
									  bool 		use_lines )
  {
    INT16 i,j;
	WX_point	*p;
	WX_point	pt;
    
	for (i = 0; i < char_instance->num_items; i++)
      {
        lpList    stroke =   char_instance->items[i];

		p = ( WX_point * ) &stroke->items[ 0 ];
		for (j = 0; j < stroke->num_items; j++ )
		  {
			pt = *p++;
			WX_MapPt( &pt , pBoundingBox , pDisplayRect );
			
	    	if( use_lines )
	    	  {
				if( j == 0 )
				  WX_MoveTo( pt.X , pt.Y );
				else
				  WX_LineTo( pt.X , pt.Y );
	    	  }
			  
	    	WX_SetPixel( pt.X , pt.Y );	
          }
	  }
  }
  
/****************************************************************/
lpList *HWX_LoadData( char *file_name )

  {
	struct IO_Stream	*pIO;
	lpList				*CharData;

    pIO = IO_fopen(file_name,"rb");
	
	if ( pIO == NULL )
	  {
	    ALRT_Alert( "Data file '%s' not found" , file_name );
		return NULL;
	  }

	ATTR_SetI( ( ATTR_Record * ) pIO , IO_msb_first , TRUE );

    CharData = HWX_ParseDataFormat( pIO );
	IO_Close( pIO );

	return CharData;
  }

