/*****************************************************************
| 
|    CONFIG.H  -- this is the master configuration file
|
+-----------------------------------------------------------------
|    It contains #defines that configure the test harness code
|    for different environments and compilers (e.g. TURBO_C,
|    MSOFT_C7, LIGHTSPEED_C, etc).  See READ.ME for more info.
|
|    Some systems allow command-line #defines, others have IDEs
|    with PRJ files, others have flavors of Make utilities. This
|    file replaces all those mechanisms with a single text file.
|    A bit cumbersome, but more maintainable across platforms.
| 
|    The original version of this code ran on MAC, SUN, and PC platforms.
|    Recent small modifications to the code may require back-tweaking
|    to run on the Macintosh or Sun. The changes made since the 
|    original version have to do with portability, generality, 
|    clarity and configurability. Porting the code back to the 
|    Mac and Sun should be trivial,  an order of magnitude less effort 
|    than coming up with a recognizer.
|
+*****************************************************************/


/****************************************************************
| COMPILER -- for now, #define either TURBO_C or MSOFT_C7.
|       The LightspeedC version is the original, but recent
|       modifications may require tweaking of this version.
|       All changes should be trivial.
|       The basic version has been run on MAC, SUN, and PC platforms.
+****************************************************************/

/*#define TURBO_C*/
/*#define MSOFT_C7*/
/*#define LIGHTSPEED_C*/

/****************************************************************
| PLATFORM -- for now, only MS_DOS has been tested with this
|       exact version of the code. See comments at the top of
|       this file. The original code ran on MAC and SUN.
|       A Windows version is in the works.
+****************************************************************/

/*#define MS_DOS*/
/*#define MACINTOSH*/
/*#define SUN */
/*#define WINDOWS */
#define WNDX

/****************************************************************
| DEBUG TRACE -- define DEBUG_TRACE for a whole lot of 
|         printf() style output to use in debugging.
|         See module H_DBG.C for more.
+****************************************************************/

#define DEBUG_TRACE

/****************************************************************
| MACINTOSH -- the Mac version did not incremental IO, but
|    read everything in one gulp. PC platform unfortunately
|    cannot do such large reads()
+**************************************************************/
#ifdef MACINTOSH
#undef USE_INCREMENTAL_IO
#endif

/****************************************************************
| MICROSOFT C -- subordinate #defines that depend on MSOFT_C7
+**************************************************************/
#ifdef MSOFT_C7
#define USE_INCREMENTAL_IO
#endif

/****************************************************************
| TURBO C -- subordinate #defines that depend on Borland's TURBO_C
+**************************************************************/

#ifdef TURBO_C
#define USE_INCREMENTAL_IO
#define USE_BGI_GRAPHICS  /* this graphics option is very PRIMITIVE! */
#define BGI_PATHNAME ".\\"    /* specifies directory where BGI files are  */ 
#endif

/****************************************************END*********/

#ifdef WNDX
#define USE_INCREMENTAL_IO
#endif
