#include <stdlib.h>
#include <stdio.h>

#include "wndx.h"
#include "scrollba.h"

#include "h_stddef.h"
#include "h_list.h"
#include "hwx.h"

#include "hwb.h"
#include "main.h"

/* Attributes for the instance window.
 */  /* EYE These first two come from somewhere else! */
#define CHARACTER		3001 /* Integer ascii id of the character to display. */
#define INSTANCE		3002 /* Integer instance index for character instance. */
#define	ZOOM_FACTOR		3003 /* Amount to zoom in. */

/* Scrollbars are added in code - these are their ID numbers.
 */
#define HORIZ_SCROLL	1
#define VERT_SCROLL		2

static void	InvalInstance(DLG_Ptr dp, int wholeWindow);
static void	InstanceUpdate(DLG_Ptr dp, WX_rect *r);
static void	DrawInstance(DLG_Ptr dp);
static int	CloseInstance(DLG_Ptr dp);
static void InstanceScroll( DLG_Ptr		dp ,
					  int 			item ,
					  EVNT_Record	*ev ,
					  int			action ,
					  int			OldValue ,
					  void			*data );
void ResizeInstance( DLG_Ptr dp , WX_rect *pOldSize );

/* HWB_Instance -> Public function:
 *	Creates a window which may be used to closely examine a single
 * handwriting sample. The window is sizeable and has a zoom option
 * with scrollbars.
 */
DLG_Ptr	HWB_Instance(lpList	*cd, char *file, DrawOptions *drw, char c, int inst)
  {
	DLG_Ptr			instWindow;
	char	   		title[256];
	static WX_rect	cascade = {0, 20, 100, 120};
	DrawOptions     *draw_opt;
	WX_rect			content;
	int				width, height;

	/* Give the window a descriptive title.
	 */
	sprintf(title, "%s: '%c' #%d", file, c, inst);

	/* Create a cascade rectangle.
	 */
	WX_OffsetRect(&cascade, 10, 10);
	if (cascade.bottom > WX_deskRect.bottom)
	  {
		cascade.top = WX_deskRect.top;
		cascade.bottom = WX_deskRect.top + 100;
	  }
	if (cascade.right > WX_deskRect.right)
	  {
		cascade.left = WX_deskRect.left;
		cascade.right = WX_deskRect.left + 100;
	  }

	/* Create the window.
	 */
	instWindow = DLG_New(dlg_title, title,
						 dlg_rect_xy, &cascade,
						 dlg_draw, DrawInstance,
						 dlg_close, CloseInstance,
						 dlg_visible, FALSE,
						 dlg_resize , ResizeInstance ,
						 dlg_menu, INSTANCE_CONFIG_MENU,
						 CHARACTER, (int) c,
						 INSTANCE, inst,
						 ZOOM_FACTOR, 1,
						 dlg_large, HWB_CHARDATA, sizeof(lpList*), &cd,
						 NULL);

	DLG_GetCopy(instWindow, dlg_content, sizeof(WX_rect), &content);
	width = content.right - content.left - 1;
	height = content.bottom - content.top - 1;
	DLG_AddItem(instWindow,
						scrollBarItm, "",
							itm_visible, FALSE,
							itm_bnds_xy, 0, height - 15, width - 15, height,
							itm_placement, 0, 1000, 1000, 1000,
							itm_action, InstanceScroll,
						scrollBarItm, "",
							itm_visible, FALSE,
							itm_bnds_xy, width - 15, 0, width, height - 15,
							itm_placement, 1000, 0, 1000, 1000,
							itm_action, InstanceScroll,
						 NULL);

	draw_opt = malloc(sizeof(DrawOptions));
	*draw_opt = *drw;
	DLG_Set(instWindow, HWB_DRAWOPTIONS, sizeof(DrawOptions*), &draw_opt);

	WND_Show(instWindow);
	return instWindow;
  }


/* InstanceScroll:
 * Scrollbar actions procedure tracks scrollbar activity for both
 * vertical and horizontal scrolling. Does a bitmap scroll and redraws
 * the exposed portion.
 */
static void InstanceScroll( DLG_Ptr		dp ,
					  		int 		item ,
					  		EVNT_Record	*ev ,
					  		int			action ,
					  		int			OldValue ,
					  		void		*data )
  {
	int			deltaValue;
	WX_rect		R;
	WX_region	update;

	if ( action == 0 )
      return;

	DLG_GetCopy(dp, dlg_content, sizeof( WX_rect ), &R);
	R.right -= 16;
	R.bottom -= 16;
	WX_InsetRect(&R, 2, 2);

	deltaValue = SCRLBR_Update( dp , item , action , OldValue , 8 , R.right & ~7 ) - OldValue;

	/* Set to the window's drawing context.
	 */
	DLG_Context( dp );
	
	/* Scroll the canvas.
	 */
	WND_SetClip(&R);
	WX_ScrollRect(&R, item == HORIZ_SCROLL ? -deltaValue : 0 ,
					  item == VERT_SCROLL ? -deltaValue : 0 , &update);

	WND_SetClipRgn(&update);
	InstanceUpdate(dp, &R);

	RGN_Clear(&update);
  }

/* InvalInstance:
 *  Forces redrawing of the display are, or the entire contents of
 * the window. This also calculates the scrollbar parameters according
 * to the current zoom_factor.
 */
static void	InvalInstance(DLG_Ptr dp, int wholeWindow)
  {
	int		zf, size;
	int		pagesize;
	WX_rect	R;

	DLG_GetCopy(dp, dlg_content, sizeof(WX_rect), &R);
	if (wholeWindow)
	  WND_InvalidateRect(&R);
	WX_InsetRect(&R, 2, 2);
	if ((zf = DLG_GetI(dp, ZOOM_FACTOR)) > 1)
	  {
		R.right -= 16;
		R.bottom -= 16;

		size = R.right - R.left + 1;
		DLG_SetIItem(dp, HORIZ_SCROLL, itm_pagesize, pagesize = size - size /8 );
		DLG_SetIItem(dp, HORIZ_SCROLL, itm_max, size * zf - pagesize );
		DLG_SetIItem(dp, HORIZ_SCROLL, itm_value, DLG_GetIItem(dp, HORIZ_SCROLL, itm_value));

		size = R.bottom - R.top + 1;
		DLG_SetIItem(dp, VERT_SCROLL, itm_pagesize, pagesize = size - size / 8 );
		DLG_SetIItem(dp, VERT_SCROLL, itm_max, size * zf - pagesize);
		DLG_SetIItem(dp, VERT_SCROLL, itm_value, DLG_GetIItem(dp, VERT_SCROLL, itm_value));
		DLG_SetIItem(dp, HORIZ_SCROLL, itm_visible, TRUE);
		DLG_SetIItem(dp, VERT_SCROLL, itm_visible, TRUE);
	  }
	else
	  {
		DLG_SetIItem(dp, HORIZ_SCROLL, itm_visible, FALSE);
		DLG_SetIItem(dp, VERT_SCROLL, itm_visible, FALSE);
	  }
	if (!wholeWindow)
	  WND_InvalidateRect(&R);
  }

/* ZoomInstance:
 */
int	ZoomInstance(struct WND_Record *dp, int menu, int item, struct EVNT_Record *ev)
  {
	int		zoom_factor, new_zf, i;
	char	name[256];

	zoom_factor = DLG_GetI(dp, ZOOM_FACTOR);
	if (item == -1)
	  for (i = 0 ; i < MENU_ItemCount(menu) ; i++)
		{
		  MENU_GetItem(menu, i+1, name);
		  MENU_SetItemCheck(menu, i+1, zoom_factor == atoi(name));
		}
	else
	  {
		MENU_GetItem(menu, item, name);
		new_zf = atoi(name);
		if (new_zf != zoom_factor)
		  {
			DLG_SetI(dp, ZOOM_FACTOR, new_zf);
			WND_SetDrawable(dp);
			InvalInstance(dp, TRUE);
		  }
	  }

	return item;
  }

void ResizeInstance( DLG_Ptr dp , WX_rect *pOldSize )

  {
  	WX_point	where;
	WX_rect		newR;
	int			v;

	where.Y = DLG_GetIItem(dp, VERT_SCROLL, itm_value );
	where.X = DLG_GetIItem(dp, HORIZ_SCROLL, itm_value );

	DLG_Resize( dp , pOldSize );

	if ( DLG_GetI( dp , ZOOM_FACTOR ) > 1 )
	  {
		DLG_GetCopy( dp , dlg_content , sizeof( WX_rect ) , &newR );

		InvalInstance( dp , TRUE );

		WX_MapPt( &where , &newR , pOldSize );

		DLG_SetIItem( dp, VERT_SCROLL, itm_value, where.Y );
		DLG_SetIItem( dp, HORIZ_SCROLL, itm_value, where.X );
	  }

  }

static void	InstanceUpdate(DLG_Ptr dp, WX_rect *r)
  {
	WX_rect		R;
	int			zoom_factor;
	lpList		pInstance;

	R = *r;
	zoom_factor = DLG_GetI(dp, ZOOM_FACTOR);
	if (zoom_factor > 1)
	  {
		R.right = R.left + ( R.right - R.left + 1 ) * zoom_factor;
		R.bottom = R.top + ( R.bottom - R.top + 1 ) * zoom_factor;
		WX_OffsetRect(&R, -DLG_GetIItem(dp, HORIZ_SCROLL, itm_value),
						  -DLG_GetIItem(dp, VERT_SCROLL, itm_value));
	  }

	pInstance = HWX_GetInstanceData( DLG_GetDp( dp , HWB_CHARDATA ) , DLG_GetI(dp, CHARACTER), DLG_GetI(dp, INSTANCE) );

	HWB_RenderInstance( dp , pInstance , &R );
  }

static void	DrawInstance(DLG_Ptr dp)
  {
	WX_rect		R;
	int			zoom_factor;

	zoom_factor = DLG_GetI(dp, ZOOM_FACTOR);

	DLG_GetCopy(dp, dlg_content, sizeof(WX_rect), &R);
	if (zoom_factor > 1)
	  {
		R.right -= 16;
		R.bottom -= 16;
	  }
	WX_InsetRect(&R, 2, 2);
	WND_SetClip(&R);
	InstanceUpdate(dp, &R);
  }

static int	CloseInstance(DLG_Ptr dp)
  {
	DrawOptions	*draw_opt;

	DLG_GetCopy(dp, HWB_DRAWOPTIONS, sizeof(DrawOptions*), &draw_opt);
	free(draw_opt);

	return TRUE;
  }
