/*=========================================================================
 * H_GM1.C   Handwriting display program
 *
 * graphics-Menu (R) GUI Toolkit.
 *
 * From:     Island Systems
 *           7 Mountain Road
 *           Burlington, MA 01813
 *
 * Voice: (617) 273-0421  Fax: (617) 270-4437  BBS: (617) 270-9552 ////
 *                                                                 ////
 *
 =========================================================================*/

#include "usual.h"
#include "DEMconst.h"
#include "DEMextrn.h"

#include "h_gm.h"

#include "h_config.h"
#include "h_stddef.h"
#include "h_list.h"
#include "h_grafic.h"

/*============================ EXTERNS ==================================*/
extern unsigned _stklen    =  8192; // up stack (effects Borland C++ only)

extern int  doAttributeForm( void );
extern void UnloadHWXData(void);
extern void LoadHWXData(LPSTR name);
extern void omShowSetOfInstances(Rect boundR, INT16 ch, int shift,
             int boxcolor, int drawcolor, int xoffset, int yoffset);
extern void omShowAlphabet( Rect boundR, INT16 inst, int shift,
                     int boxcolor, int drawcolor, int xoffset, int yoffset);
extern void omShowAll( Rect boundR, int shift,
                int boxcolor, int drawcolor, int xoffset, int yoffset);
extern void RegisterCallback(
       HDISPLAY display_entity,
       void (*pf_move_to)(HDISPLAY,INT16,INT16),
       void (*pf_line_to)(HDISPLAY,INT16,INT16));
extern void    myMoveTo(HDISPLAY display_entity,INT16 h,INT16 v);
extern void    myLineTo(HDISPLAY display_entity,INT16 h,INT16 v);

/*============================ PROTOTYPES ===============================*/
void  InitMenus( void );
void  DoThisMenu( MenuRecType  *HM );
void  setScrollRange( void );
void  PrepareW1( MenuRecType  *Hmenu );
void  DoW1( void );
void  DrawW1( void );
int   DisplayTime( void );
void  drawSample(int xOffset, int yOffset, boolean holdposx, boolean holdposy);
int   loadDataFile( void );
int   loadDataFileTMP( void );
int   doPrint( void );
int   displayAbout( void );


/*========================= GLOBAL VARIABLES ============================*/
static WinType      W1;

int          globalsecs = 0;
boolean      FirstTime = true;
int          Hitem,TrackStatus;
short        VertItem;
MenuRecType  HM;
MenuRecType  Q_File;
MenuRecType  Q_Edit;
MenuRecType  Q_Browse;
MenuRecType  Q_lineThic_4;
MenuRecType  Q_lineStyl_5;
MenuRecType  Q_Colors;

rect         gDrawArea;
long         gWORLDX = 400;      /* X size of entire drawing area avail */
long         gWORLDY = 750;      /* Y size of entire drawing area avail */
int          gDrawWhat   = INSTANCE_DRAW;
int          gCurrSample = 1;
int          gCurrChar   = 'A';
int          gCurrScale  = 3;
int          gBackColor  = GREEN;
int          gDrawColor  = BLACK;
int          gLineStyle  = SOLID_LINE;
int          gThickness  = THICK_WIDTH;
boolean      gFileLoaded = false;
boolean      gSaveWindow = false;

/*=============================== MAIN ==================================*/
int main(int argc, char *argv[])
{
  char msg[80];
  unsigned EMSt, EMSu;
  long EMSavail;

  GM_init(argc, argv);
  /* Is there sufficient amount of EMS */
  if (EmmInstalled)
   {
      EMS_getnumofpages( &EMSt, &EMSu );
      EMSavail = (long)EMSu * 16384L;
      if (EMSavail < 25000)
       {
          AllowEMS = false;
          Bleep(1000, 100);
          Bleep(100,   75);
          strcpy(msg, "Not enough EMS, using conventional.");
       }
      else
       {
         sprintf(msg, "Using EMS %ld", EMSavail);
         gSaveWindow = true;
       }
   }
  else strcpy(msg, "No EMS");


  SetHorizontalLimits(0, sR.Xmax);
  SetVerticalLimits(0, sR.Ymax);
  RegisterCallback(0, myMoveTo, myLineTo);

  GapY= 3;
  TextAlign(alignLeft, alignBottom);
  strcpy( iconpath, "");
  strcpy( iconext, ".icn");

  InitMenus();

  if ( MaxColors>2 )
   {
     btnpat=1;
     btnbkpat=1;
     btnbkfill=WHITE;
   }
  else /*monochrome*/
   {
     btnbkcolor=WHITE;
   }

  PrepareW1( &HM );
  userproc1 = DisplayTime;

  DrawW1();
  FreezeWin( &W1 );

  do
   {
     PollUser();
     DoW1();
   } while (err==err); /* forever */

  GM_close();
  return 0;
}

/*---------------------------------------------------------------*/
void  DrawW1( void )
{
  HideCursor();
  // draw window
  DrawWindow( &W1, true /*DoBevel*/, gSaveWindow /*DoSave*/, true /*HasHmenu*/ );
  setcolor(gBackColor);
  PaintRect (&W1.WorkingR);
  // set inner drawing rectangle
  gDrawArea.Xmin = W1.WorkingR.Xmin+8;   gDrawArea.Xmax = W1.WorkingR.Xmax-8;
  gDrawArea.Ymin = W1.WorkingR.Ymin;     gDrawArea.Ymax = W1.WorkingR.Ymax;

  setScrollRange();

  DrawScrollRect( &(W1.SbarR) );
  DrawDragBoxV( &(W1.SbarR), &(W1.DragBoxR),
                     W1.PcntVert,      W1.PcntR );
  DrawScrollRect( &(W1.SbarB) );
  DrawDragBoxH( &(W1.SbarB), &(W1.DragBoxB),
                     W1.PcntHorz,      W1.PcntB );
  ShowCursor();
}
/*---------------------------------------------------------------*/
void  InitMenus( void )
{
  NewItems(4, &HM, &err);
   strcpy( HM.Title, "") ;
   strcpy( *HM.ItemArray[1],     "File") ;
   strcpy( *HM.ItemArray[2],     "Edit") ;
   strcpy( *HM.ItemArray[3],     "Browse") ;
   strcpy( *HM.ItemArray[4],     "Colors") ;
   HM.ULx=ShadowX; HM.ULy=ShadowY; HM.URx=sR.Xmax;

  NewItems(4, &Q_File, &err);
   strcpy(*Q_File.ItemArray[1], " Open"  );
   strcpy(*Q_File.ItemArray[2], " Print"  );
   strcpy(*Q_File.ItemArray[3], " About"  );
   strcpy(*Q_File.ItemArray[4], " eXit  Alt-X"  );

  NewItems(4, &Q_Edit, &err);
   strcpy(*Q_Edit.ItemArray[1], " Cut"  );
   Q_Edit.IsEnabled[1] = false;
   strcpy(*Q_Edit.ItemArray[2], " cOpy"  );
   strcpy(*Q_Edit.ItemArray[3], " Paste"  );
   Q_Edit.IsEnabled[3] = false;
   strcpy(*Q_Edit.ItemArray[4], " Undo"  );
   Q_Edit.IsEnabled[4] = false;

  NewItems(3, &Q_Browse, &err);
   strcpy(*Q_Browse.ItemArray[1], " Attributes"  );
   strcpy(*Q_Browse.ItemArray[2], " line Thickness..."  );
   strcpy(*Q_Browse.ItemArray[3], " line Style..."  );

  NewItems(2, &Q_lineThic_4, &err);
   strcpy(*Q_lineThic_4.ItemArray[1], " Normal"  );
   strcpy(*Q_lineThic_4.ItemArray[2], " Thick"  );

  NewItems(3, &Q_lineStyl_5, &err);
   strcpy(*Q_lineStyl_5.ItemArray[1], " Solid"  );
   strcpy(*Q_lineStyl_5.ItemArray[2], " Dashed"  );
   strcpy(*Q_lineStyl_5.ItemArray[3], " dOtted"  );

  NewItems(2, &Q_Colors, &err);
   strcpy(*Q_Colors.ItemArray[1], " Foreground"  );
   strcpy(*Q_Colors.ItemArray[2], " Background"  );

} /* InitMenus */
/*---------------------------------------------------------------*/
void  DoThisMenu( MenuRecType  *Hmenu )
{
  int     SI, loadOk, acolor, xstart, ystart, changes;
  boolean tmpKS;

  if ( (! MousePressedInR( &(Hmenu->ChoiceRect) ))
           &&
       (! KeyStatus.DidPress) )
    return;

  if ( gFileLoaded &&
       KeyStatus.DidPress &&
       ((KeyStatus.ch2==rightarrow) || (KeyStatus.ch2==leftarrow) ||
        (KeyStatus.ch2==uparrow)    || (KeyStatus.ch2==downarrow) ||
        (KeyStatus.ch2==PgUp)       || (KeyStatus.ch2==PgDn) ||
        (KeyStatus.ch2==Home)       || (KeyStatus.ch2==EndKey)) )
    return;  //allow scrollbars to act on arrow keys

  SI=SaveIndex;
  do
   {
    tmpKS = KeyStatus.DidPress;
    GetHorizMenuItem( &Hitem, Hmenu );
    if (Hitem < 0) KeyStatus.DidPress=tmpKS;
    if (Hitem > 0) /* is valid horiz selection */
      switch (Hitem)
        {
          case 1: /* File */
             {
               AlignVertMenu( Hmenu, &Q_File);
               DrawChoiceBox( &Q_File, true );
               TrackHorizMenu( Hmenu, &Q_File, &TrackStatus);
               if (TrackStatus < 0) /*remove menu and un-hilite*/
                  PopMenu(&err);
               else
               if (TrackStatus==0)  /* use this vert menu */
                 {
                  GetChoiceBoxItem( &VertItem, &Q_File );
                  switch (VertItem)
                   {
                   case -1:  PopMenu(&err); break;
                   case 1: /*  Open */
                     {
                       WaitForNot(swLeft);
                       PopMenu( &err );
                       loadOk = loadDataFile();
                       if (loadOk==0)
                        {
                         drawSample(0,0, UPDATEPOSX, UPDATEPOSY);
                         Hitem = -1;  // force exit from this menu loop
                        }

                       break;
                     }

                   case 2: /*  Print */
                     {
                       WaitForNot(swLeft);
                       PopMenu( &err );
                       doPrint();
                       break;
                     }

                   case 3: /*  About */
                     {
                       displayAbout();
                       WaitForNot(swLeft);
                       PopMenu( &err );
                       break;
                     }

                   case 4: /*  eXit */
                     {
                       WaitForNot(swLeft);
                       PopMenu( &err );
                       //UnloadHWXData();
                       gFileLoaded = false;
                       GM_close();
                       exit(0);
                       break;
                     }

                  } /* s7   Case VertItem of */
                 } /* s6  if TrackStatus==0*/
               MenuInvertRect(Hmenu);
               break;
             }

          case 2: /* Edit */
             {
               AlignVertMenu( Hmenu, &Q_Edit);
               DrawChoiceBox( &Q_Edit, true );
               TrackHorizMenu( Hmenu, &Q_Edit, &TrackStatus);
               if (TrackStatus < 0) /*remove menu and un-hilite*/
                  PopMenu(&err);
               else
               if (TrackStatus==0)  /* use this vert menu */
                 {
                  GetChoiceBoxItem( &VertItem, &Q_Edit );
                  switch (VertItem)
                   {
                   case -1:  PopMenu(&err); break;
                   case 1: /*  Cut */
                     {
                       WaitForNot(swLeft);
                       PopMenu( &err );
                       break;
                     }

                   case 2: /*  cOpy */
                     {
                       Bleep(1000,200);
                       WaitForNot(swLeft);
                       PopMenu( &err );
                       Hitem = -1;  // force exit from this menu loop
                       break;
                     }

                   case 3: /*  Paste */
                     {
                       WaitForNot(swLeft);
                       PopMenu( &err );
                       break;
                     }

                   case 4: /*  Undo */
                     {
                       WaitForNot(swLeft);
                       PopMenu( &err );
                       break;
                     }
                  } /* s7   Case VertItem of */
                 } /* s6  if TrackStatus==0*/
               MenuInvertRect(Hmenu);
               break;
             }

          case 3: /* Browse */
             {
               AlignVertMenu( Hmenu, &Q_Browse);
               DrawChoiceBox( &Q_Browse, true );
               TrackHorizMenu( Hmenu, &Q_Browse, &TrackStatus);
               if (TrackStatus < 0) /*remove menu and un-hilite*/
                  PopMenu(&err);
               else
               if (TrackStatus==0)  /* use this vert menu */
                 {
                  GetChoiceBoxItem( &VertItem, &Q_Browse );
                  switch (VertItem)
                   {
                   case -1:  PopMenu(&err); break;
                   case 1: /*  Attributes */
                     {
                       WaitForNot(swLeft);
                       changes = doAttributeForm();
                       PopMenu( &err );
                       setScrollRange();
                       if (changes)
                         drawSample(0,0, UPDATEPOSX, UPDATEPOSY);
                       else
                         drawSample(0,0, HOLDPOSX, HOLDPOSY);
                       Hitem = -1;  // force exit from this menu loop
                       break;
                     }

                   case 2: /* >line Thickness */
                     {
                       AlignVertMenu2( &Q_Browse, &Q_lineThic_4 );
                       DrawChoiceBox( &Q_lineThic_4, true );
                       DoVmenu( &Q_lineThic_4, &VertItem, NoDrag );
                       if (VertItem<=0) PopTo( SI );
                       else
                       switch (VertItem)
                        {
                       case 1: /* Normal*/
                         {
                           gThickness = NORM_WIDTH;
                           PopTo( SI ); /*remove Q_lineThic_4*/
                           WaitForNot(swLeft);
                           drawSample(0,0, HOLDPOSX, HOLDPOSY);
                           Hitem = -1;  // force exit from this menu loop
                           break;
                         } /* (case 1) Q_lineThic_4 */

                       case 2: /* Thick*/
                         {
                           gThickness = THICK_WIDTH;
                           PopTo( SI ); /*remove Q_lineThic_4*/
                           WaitForNot(swLeft);
                           drawSample(0,0, HOLDPOSX, HOLDPOSY);
                           Hitem = -1;  // force exit from this menu loop
                           break;
                         } /* (case 2) Q_lineThic_4 */

                       } /* case VertItem of (Q_lineThic_4) */

                       break;
                     }

                   case 3: /* >line Style */
                     {
                       AlignVertMenu2( &Q_Browse, &Q_lineStyl_5 );
                       DrawChoiceBox( &Q_lineStyl_5, true );
                       DoVmenu( &Q_lineStyl_5, &VertItem, NoDrag );
                       if (VertItem<=0) PopTo( SI );
                       else
                       switch (VertItem)
                        {
                       case 1: /* Solid*/
                         {
                           gLineStyle = SOLID_LINE;
                           PopTo( SI ); /*remove Q_lineStyl_5*/
                           WaitForNot(swLeft);
                           drawSample(0,0, HOLDPOSX, HOLDPOSY);
                           Hitem = -1;  // force exit from this menu loop
                           break;
                         } /* (case 1) Q_lineStyl_5 */

                       case 2: /* Dashed*/
                         {
                           gLineStyle = DASHED_LINE;
                           PopTo( SI ); /*remove Q_lineStyl_5*/
                           WaitForNot(swLeft);
                           drawSample(0,0, HOLDPOSX, HOLDPOSY);
                           Hitem = -1;  // force exit from this menu loop
                           break;
                         } /* (case 2) Q_lineStyl_5 */

                       case 3: /* dOtted*/
                         {
                           gLineStyle = DOTTED_LINE;
                           PopTo( SI ); /*remove Q_lineStyl_5*/
                           WaitForNot(swLeft);
                           drawSample(0,0, HOLDPOSX, HOLDPOSY);
                           Hitem = -1;  // force exit from this menu loop
                           break;
                         } /* (case 3) Q_lineStyl_5 */

                       } /* case VertItem of (Q_lineStyl_5) */

                       break;
                     }

                  } /* s7   Case VertItem of */
                 } /* s6  if TrackStatus==0*/
               MenuInvertRect(Hmenu);
               break;
             }

          case 4: /* Colors */
             {
               AlignVertMenu( Hmenu, &Q_Colors);
               DrawChoiceBox( &Q_Colors, true );
               TrackHorizMenu( Hmenu, &Q_Colors, &TrackStatus);
               if (TrackStatus < 0) /*remove menu and un-hilite*/
                  PopMenu(&err);
               else
               if (TrackStatus==0)  /* use this vert menu */
                 {
                  GetChoiceBoxItem( &VertItem, &Q_Colors );
                  switch (VertItem)
                   {
                   case -1:  PopMenu(&err); break;
                   case 1: /*  Foreground */
                     {
                       WaitForNot(swLeft);
                       xstart = Q_Colors.ChoiceRect.Xmax+1;
                       ystart = Q_Colors.ChoiceRect.Ymax-12;
                       DisplayColors( 16, BOXWIDTH, xstart, ystart );
                       WaitFor( swLeft );
                       if ( (acolor = ColorAtCursor( 16, BOXWIDTH,
                                                     xstart, ystart)) >= 0)
                         gDrawColor = acolor;
                       WaitForNot(swLeft);
                       PopMenu( &err );
                       drawSample(0,0, HOLDPOSX, HOLDPOSY);
                       Hitem = -1;  // force exit from this menu loop
                       break;
                     }

                   case 2: /*  Background */
                     {
                       WaitForNot(swLeft);
                       xstart = Q_Colors.ChoiceRect.Xmax+1;
                       ystart = Q_Colors.ChoiceRect.Ymax-12;
                       DisplayColors( 16, BOXWIDTH, xstart, ystart );
                       WaitFor( swLeft );
                       if ( (acolor = ColorAtCursor( 16, BOXWIDTH,
                                                     xstart, ystart)) >= 0)
                         gBackColor = acolor;
                       WaitForNot(swLeft);
                       PopMenu( &err );
                       drawSample(0,0, HOLDPOSX, HOLDPOSY);
                       Hitem = -1;  // force exit from this menu loop
                       break;
                     }

                  } /* s7   Case VertItem of */
                 } /* s6  if TrackStatus==0*/
               MenuInvertRect(Hmenu);
               break;
             }
      }
    }
  while (Hitem > 0);

  PopTo( SI );

} /* DoThisMenu */

/*----------------------------------------------------------*/
void  setScrollRange( void )
{
   int h, w, ipr, dx, dy;

   h   = CELL_HEIGHT;
   w   = CELL_WIDTH;
   ipr = MAX_INST_PER_ROW;
   dx  = W1.WorkingR.Xmax-W1.WorkingR.Xmin;
   dy  = W1.WorkingR.Ymax-W1.WorkingR.Ymin;

   if (gDrawWhat==INSTANCE_DRAW) //display one sample
     gWORLDY = ((20/ipr +1)*h) - dy;
   else if (gDrawWhat==ALPHABET_DRAW)  // display alphabet for a sample
     // 64 chars: -,+,0..9,A..Z,a..z
     gWORLDY = ((64L/ipr +1) * h) - dy + h;
   else
     // 20 instances of 64 alpha chars
     gWORLDY = (((20L*64L)/ipr +1) * h) + h; //add more due to int rounding by scrollbar in a small win

  gWORLDX = (ipr-1) * w;

  /* Use the WorkingR to calculate size of scroll bars */
  W1.PcntB = (((long)dx)*100L)/gWORLDX;
  if (W1.PcntB >= 99)  W1.PcntB = 90;  // allow some horiz scrolling
  if (W1.PcntB <  10)  W1.PcntB = 10;
  W1.PcntR = (((long)dy)*100L)/gWORLDY;
  if (W1.PcntR > 100)  W1.PcntR =100;
  if (W1.PcntR <  10)  W1.PcntR = 10;

  DrawScrollRect( &(W1.SbarB) );
  DrawDragBoxH( &(W1.SbarB), &(W1.DragBoxB),
                (int)W1.PcntHorz, (int)W1.PcntB );
  DrawScrollRect( &(W1.SbarR) );
  DrawDragBoxV( &(W1.SbarR), &(W1.DragBoxR),
                (int)W1.PcntVert, (int)W1.PcntR );
}
/*----------------------------------------------------------*/
void  PrepareW1( MenuRecType  *Hmenu )
{
  /* attach the horizontal menu to the window. */
  W1.HmenuPtr = Hmenu;

  /* Setup the window location & size & scroll bars. */
  //SetR( &(W1.R), 30, 50, 540, 385 );
  SetR( &(W1.R), 60, 80, 510, 335 );
  W1.PcntVert=0; W1.PcntR=25; /* % width  */
  W1.PcntHorz=0; W1.PcntB=25; /* % height */
  W1.HasRscroll= true;
  W1.HasBscroll= true;
  strcpy( W1.title,  "graphics-Menu Handwriting Utility Rev 1.1");
  strcpy( W1.status, "Dr. Dobb's Journal November 1992");

} /* PrepareW1 */
/*----------------------------------------------------------*/
void  DoW1( void )
/*
  This procedure is used to perform "actions" on the window
  including move scroll bars, drag the window, resize the window,
  push the utility buttons, do the icons, buttons, && attached
  horizontal menu.
*/

{
  short k;
  boolean done;
  static long SlideX=0, SlideY=0;
  static long LastSlideX=0, LastSlideY=0;
  int ( *tmpproc)();

  /* Now let user manipulate the window & its objects. */
  do
   {
    /* Wait for the user to do something. */
    WaitForUser();
    if (KeyStatus.DidPress && KeyStatus.ch==0 && KeyStatus.extkey==45)
     {
      /* Alt-X */
      //UnloadHWXData();
      gFileLoaded = false;
      GM_close();
      exit(0);
     }

    /* if ( mouse is close to the edges, re-size the window. */
    if ( gSaveWindow && IsMatRedge( &(W1.WinR), 10 ) && (Button==swLeft) )
      {
        /* Disable the userproc. */
        tmpproc = userproc1;
        userproc1 = NULL;

        PenColor( WHITE ^ winbkcolor );
        ResizeWin( &W1, 30 );
        PopWin( &W1, &err );
        DrawW1();
        drawSample(0,0, HOLDPOSX, HOLDPOSY);

        /* Enable the userproc. */
        userproc1 = tmpproc;
      }

    /* Process the attached horizontal menu. */
    DoThisMenu( W1.HmenuPtr );

    PollWin( &((int)k), &W1 );
    if ( k==4 /*User pressed right scroll bar*/ )
      {
        if ((100-W1.PcntR) > 0)
        {
          SlideY = (gWORLDY / (100 - W1.PcntR)) * (W1.PcntVert);
          drawSample( 0, (int)-SlideY, HOLDPOSX, UPDATEPOSY );
          LastSlideY = SlideY;
        }
      }
    else
    if ( k==5 /*User pressed bottom scroll bar*/ )
      {
        if ((100-W1.PcntB) > 0)
        {
          SlideX = (gWORLDX / (100L - W1.PcntB)) * (W1.PcntHorz);
          drawSample( (int) -SlideX, 0, UPDATEPOSX, HOLDPOSY );
          LastSlideX = SlideX;
        }
      }
    else
    if ( (k==6) && gSaveWindow )
      {
        /* Disable the userproc. */
        tmpproc = userproc1;
        userproc1 = NULL;

        DragWin( &W1, true /*DoBevel*/, false /*DoRedraw*/ );
        DrawW1();
        drawSample(0,0, HOLDPOSX, HOLDPOSY);

        /* Enable the userproc. */
        userproc1 = tmpproc;
      }

    /* check if user chose to do incremental scrolling */
    if ( (W1.PcntHorz+W1.PcntB < 100) &&
         ((KeyStatus.DidPress && (KeyStatus.ch2==rightarrow))
          || MousePressedInR( &(W1.ArectB2)))  )
     {
       W1.PcntHorz += 2;
       DrawScrollRect( &(W1.SbarB) );
       DrawDragBoxH( &(W1.SbarB), &(W1.DragBoxB),
                     (int)W1.PcntHorz, (int)W1.PcntB );
       if ((100-W1.PcntB) > 0)
        {
          SlideX = (gWORLDX / (100L - W1.PcntB)) * (W1.PcntHorz);
          drawSample( (int) -SlideX, 0, UPDATEPOSX, HOLDPOSY );
          LastSlideX = SlideX;
        }
     }
    else
    if ( (W1.PcntHorz >= 2) &&
         ((KeyStatus.DidPress && (KeyStatus.ch2==leftarrow))
         || MousePressedInR( &(W1.ArectB1))) )
     {
       W1.PcntHorz -=2;
       DrawScrollRect( &(W1.SbarB) );
       DrawDragBoxH( &(W1.SbarB), &(W1.DragBoxB),
                     (int)W1.PcntHorz, (int)W1.PcntB );
       if ((100-W1.PcntB) > 0)
        {
          SlideX = (gWORLDX / (100L - W1.PcntB)) * (W1.PcntHorz);
          drawSample( (int) -SlideX, 0, UPDATEPOSX, HOLDPOSY );
          LastSlideX = SlideX;
        }
     }
    else
    if ( (W1.PcntVert+W1.PcntR < 100) &&
         ((KeyStatus.DidPress && (KeyStatus.ch2==downarrow))
         || MousePressedInR( &(W1.ArectR2) ))  )
     {
       W1.PcntVert += 2;
       DrawScrollRect( &(W1.SbarR) );
       DrawDragBoxV( &(W1.SbarR), &(W1.DragBoxR),
                     (int)W1.PcntVert, (int)W1.PcntR );
       if ((100-W1.PcntR) > 0)
        {
          SlideY = (gWORLDY / (100 - W1.PcntR)) * (W1.PcntVert);
          drawSample( 0, (int)-SlideY, HOLDPOSX, UPDATEPOSY );
          LastSlideY = SlideY;
        }
     }
    else
    if ( (W1.PcntVert >= 2) &&
         ((KeyStatus.DidPress && (KeyStatus.ch2==uparrow))
         || MousePressedInR( &(W1.ArectR1))) )
     {
       W1.PcntVert -= 2;
       DrawScrollRect( &(W1.SbarR) );
       DrawDragBoxV( &(W1.SbarR), &(W1.DragBoxR),
                     (int)W1.PcntVert, (int)W1.PcntR );
       if ((100-W1.PcntR) > 0)
        {
          SlideY = (gWORLDY / (100 - W1.PcntR)) * (W1.PcntVert);
          drawSample( 0, (int)-SlideY, HOLDPOSX, UPDATEPOSY );
          LastSlideY = SlideY;
        }
     }
    else
    if (KeyStatus.DidPress && (KeyStatus.ch2==Home))
     {
       W1.PcntVert = 0;
       DrawScrollRect( &(W1.SbarR) );
       DrawDragBoxV( &(W1.SbarR), &(W1.DragBoxR),
                     (int)W1.PcntVert, (int)W1.PcntR );
       if ((100-W1.PcntR) > 0)
        {
          SlideY = (gWORLDY / (100 - W1.PcntR)) * (W1.PcntVert);
          drawSample( 0, (int)-SlideY, HOLDPOSX, UPDATEPOSY );
          LastSlideY = SlideY;
        }
     }
    else
    if (KeyStatus.DidPress && (KeyStatus.ch2==EndKey))
     {
       W1.PcntVert = 100-W1.PcntR;
       DrawScrollRect( &(W1.SbarR) );
       DrawDragBoxV( &(W1.SbarR), &(W1.DragBoxR),
                     (int)W1.PcntVert, (int)W1.PcntR );
       if ((100-W1.PcntR) > 0)
        {
          SlideY = (gWORLDY / (100 - W1.PcntR)) * (W1.PcntVert);
          drawSample( 0, (int)-SlideY, HOLDPOSX, UPDATEPOSY );
          LastSlideY = SlideY;
        }
     }
    else
    if ( KeyStatus.DidPress && (KeyStatus.ch2==PgDn) )
     {
       W1.PcntVert += 15;
       if (W1.PcntVert > 100-W1.PcntR) W1.PcntVert = 100-W1.PcntR;
       DrawScrollRect( &(W1.SbarR) );
       DrawDragBoxV( &(W1.SbarR), &(W1.DragBoxR),
                     (int)W1.PcntVert, (int)W1.PcntR );
       if ((100-W1.PcntR) > 0)
        {
          SlideY = (gWORLDY / (100 - W1.PcntR)) * (W1.PcntVert);
          drawSample( 0, (int)-SlideY, HOLDPOSX, UPDATEPOSY );
          LastSlideY = SlideY;
        }
     }
    else
    if ( KeyStatus.DidPress && (KeyStatus.ch2==PgUp))
     {
       W1.PcntVert -= 15;
       if (W1.PcntVert < 0) W1.PcntVert = 0;
       DrawScrollRect( &(W1.SbarR) );
       DrawDragBoxV( &(W1.SbarR), &(W1.DragBoxR),
                     (int)W1.PcntVert, (int)W1.PcntR );
       if ((100-W1.PcntR) > 0)
        {
          SlideY = (gWORLDY / (100 - W1.PcntR)) * (W1.PcntVert);
          drawSample( 0, (int)-SlideY, HOLDPOSX, UPDATEPOSY );
          LastSlideY = SlideY;
        }
     }

    if (W1.PcntHorz < 0)    W1.PcntHorz=0;
    if (W1.PcntVert < 0)    W1.PcntVert=0;
    if (W1.PcntHorz > 100)  W1.PcntHorz=100;
    if (W1.PcntVert > 100)  W1.PcntVert=100;


    /* We are "done" if ( the mouse button is pressed while not inside
      the window. */

    done= MousePressedInR( &(W1.WinR) );
   } while (! done);

} /* DoW1 */


/*----------------------------------------------------------*/
void drawSample(int xOffset, int yOffset, boolean holdposx, boolean holdposy)
{
  Rect tmpR;
  static int  xLastOffset=0, yLastOffset=0;
  if (holdposx==true)
    xOffset=xLastOffset;
  if (holdposy==true)
    yOffset=yLastOffset;

  HideCursor();
  tmpR.left = gDrawArea.Xmin;  tmpR.top   =gDrawArea.Ymin;
  tmpR.right= gDrawArea.Xmax;  tmpR.bottom=gDrawArea.Ymax;
  setcolor(gBackColor);
  PaintRect(&W1.WorkingR);

  setviewport( gDrawArea.Xmin, gDrawArea.Ymin,
               gDrawArea.Xmax, gDrawArea.Ymax, 1 );

  setlinestyle(gLineStyle, 1, gThickness);

  if (gDrawWhat==INSTANCE_DRAW) //display one sample
  {
    omShowSetOfInstances(tmpR, gCurrChar, gCurrScale, LIGHTGRAY, gDrawColor,
                         (int)xOffset, (int)yOffset);

  }
  else if (gDrawWhat==ALPHABET_DRAW)  // display alphabet for a sample
  {
    omShowAlphabet( tmpR, gCurrSample-1, gCurrScale, LIGHTGRAY, gDrawColor,
                    (int)xOffset, (int)yOffset);
  }
  else
  {
    omShowAll( tmpR, gCurrScale, LIGHTGRAY, gDrawColor,
               (int)xOffset, (int)yOffset);
  }
  setlinestyle(SOLID_LINE, 1, NORM_WIDTH);

  xLastOffset = xOffset;   yLastOffset = yOffset;

  setviewport( sR.Xmin, sR.Ymin, sR.Xmax, sR.Ymax, 1 );
  ShowCursor();
}


/*----------------------------------------------------------*/
int  DisplayTime( void )
/*
 This procedure is called as "userproc1" after the user is
 polled for input. It will display the time on the right
 side of the status rect of the window.
*/

{

#if TurboC
  #include <dos.h>
#endif

#if MicrosoftC
  #include <time.h>
#endif

pusharea G;
char mstr1[3], sstr1[3];
char ampm[4],mstr[3],sstr[3];
char TimeStr[19];
short  H,M,S;

#if TurboC
  struct time   timestruct;
#endif

#if MicrosoftC
  struct tm *newtime;
  long ltime;
#endif


 PushGrafix( &G );

 /* Ask DOS for the current time. */


/* now, get the current system time to use as a starting time for
   user entry  */

#if TurboC
  gettime( &timestruct );
  H = (int) timestruct.ti_hour;
  M = (int) timestruct.ti_min;
  S = (int) timestruct.ti_sec;
#endif

#if MicrosoftC
  time(&ltime);
  newtime = localtime(&ltime);
  H = (int) (newtime->tm_hour);
  M = (int) (newtime->tm_min);
  S = (int) (newtime->tm_sec);
#endif


 /* Update the time only if ( the seconds have chanded. if ( we
   don"t do this, there will be too much flicker. */
 if ( S!=globalsecs )
  {
   BackColor( ScreenColor );
   RasterOp( zREPz );

   /* Set AM | PM. */
   if ( H>=12 ) { strcpy(ampm," PM"); } else strcpy(ampm," AM");
   if ( H>12 )  H=H-12;

   /* Add leading "0" to minutes if ( less than 10. */
   /*str(M,mstr); */
   itoa( M, mstr, 10 );
   strcpy( mstr1, mstr );
   if ( M<10 )
      /* mstr="0"+mstr; */
      { strcpy( mstr1, "0" ); strcat( mstr1, mstr ); }

   /* Add leading "0" to seconds if ( less than 10. */
   /*str(S,sstr); */
   itoa( S, sstr, 10 );
   strcpy( sstr1, sstr );
   if ( S<10 )
      /* sstr="0"+sstr; */
      { strcpy( sstr1, "0" ); strcat( sstr1, sstr ); }

   /* Now put the time string together. */
   /* TimeStr = ItoS(H,2)+":"+mstr+":"+sstr+" "+ampm; */
   strcpy( TimeStr, ItoS(H,2) ); strcat( TimeStr, ":" );
   strcat( TimeStr, mstr1 );     strcat( TimeStr, ":" );
   strcat( TimeStr, sstr1 );     strcat( TimeStr, ampm );

   /* Display the time. */
   HideCursor();
   UpdateTitle(TimeStr, &(W1.statusrect), LIGHTGREEN, 1);
   ShowCursor();

   /* Remember the time so we can see if ( the seconds changed. */
   globalsecs=S;
  }

 PopGrafix( &G );

 /*Important to do for userproc1!*/
 return(0);

} /* UpdateTime */
/*----------------------------------------------------------*/

/*-------------------------------------------------------------------------*/
int loadDataFileTMP( void )
{
  LoadHWXData( "CLEAN.DAT" );
  return 0;
}

/*-------------------------------------------------------------------------*/
int loadDataFile( void )
{
  rect R;
  tPathStr      fspec, fpath;
  tFullPathStr  fullname;
  int        which,howmany, hold;
  CheckListColorRecType C;
  CheckTrecType T;
  SortDirType sortdir;
  SortByType  sortby;
  CheckLineRecPtrPtr tmpptr;

  strcpy(fspec, "*.DAT");
  fpath[0]    = '\0';
  fullname[0] = '\0';

  InitCheckListColors(&C,0);     /* set default colors */
  err = 0;

  sortdir = Ascending;
  sortby  = Ext;


  CurColor = WHITE ^ CYAN;
  hold = btncolor;
  FileChooze( "Select Handwriting file",75,120,
              fspec,fpath,
              true  /*allowtrav*/,
              false /*allowmulti*/,
              true  /*dosave*/,
              false /*allowdrg*/,
              &T,
              sortdir,
              sortby,
              &C,
              8 /* 8 items high */,
              3 /*bevel*/,
              &which,
              &howmany,
              &err);


  /* Now show which files have been checked */
  btncolor=hold;
  if (err>=0)
    if (which >= 0)
    {
      tmpptr = GetItemPtr(&T,which);
      if (tmpptr != NULL)
       {
         // MenuMsg2("you chose ",(*tmpptr)->Lptr);
         strcpy(fullname, fpath);
         strcat(fullname, (*tmpptr)->Lptr);

         // display message
         MoveTo(MidPt.X-(10*StringWidthX), MidPt.Y-(1*FontHeight)); /*screen center*/
         HideCursor();
         DrawTextRect(2,19,10,10,LIGHTGRAY,LIGHTRED,true,&R,&err);
         PenColor(BLUE);         /*text color  */
         BackColor(LIGHTGRAY);   /*same as fill color*/
         DrawStringLN(" One Moment Please. ");
         DrawStringLN(" Loading File... ");
         ShowCursor();

         LoadHWXData( fullname );
         gFileLoaded = true;

         PopRect(&err);
       }

    }
  // else Escape Key Hit

  DisposeTMPTextItems(&T,&err);
  return err;
}



/*-------------------------------------------------------------------------*/
int doPrint( void )
{
  rect R;

  MoveTo(MidPt.X-(11*StringWidthX), MidPt.Y-(5*FontHeight)); /*screen center*/
  HideCursor();
  DrawTextRect(10,24,10,10,LIGHTGRAY,LIGHTRED,true,&R,&err);
  PenColor(BLUE);         /*text color  */
  BackColor(LIGHTGRAY);   /*same as fill color*/
  DrawStringLN(" Printer support can be ");
  DrawStringLN(" easily added using: ");
  DrawStringLN(" ");
  DrawStringLN("   GRAF/DRIVE PLUS");
  DrawStringLN("         by");
  DrawStringLN("   Fleming Software");
  DrawStringLN("   PO 569");
  DrawStringLN("   Oakton VA 22124");
  DrawStringLN("   (703) 591-6451" );
  ShowCursor();

  WaitForUser();
  if (Button)
    WaitForNot(Button);
  PopRect(&err);
  return 0;
}


/*-------------------------------------------------------------------------*/
int displayAbout( void )
{
  rect R;

  MoveTo(MidPt.X-(12*StringWidthX), MidPt.Y-(5*FontHeight)); /*screen center*/
  HideCursor();
  DrawTextRect(10,26,10,10,LIGHTGRAY,LIGHTRED,true,&R,&err);
  PenColor(BLUE);         /*text color  */
  BackColor(LIGHTGRAY);   /*same as fill color*/
  DrawStringLN("      graphics-Menu");
  DrawStringLN("     The Professional");
  DrawStringLN(" Graphical User Interface");
  DrawStringLN("  for C and Pascal From:");
  DrawStringLN(" ");
  DrawStringLN("     Island Systems");
  DrawStringLN("    7 Mountain Road");
  DrawStringLN("  Burlington, MA 01803");
  DrawStringLN(" ");
  DrawStringLN("     (617) 273-0421");
  ShowCursor();

  WaitForUser();
  if (Button)
    WaitForNot(Button);
  PopRect(&err);
  return 0;
}

