/*=========================================================================
 * H_GM2.C   Handwriting display program
 *
 * graphics-Menu (R) GUI Toolkit.
 *
 * From:     Island Systems
 *           7 Mountain Road
 *           Burlington, MA 01813
 *
 * Voice: (617) 273-0421  Fax: (617) 270-4437  BBS: (617) 270-9552 ////
 *                                                                 ////
 *
 =========================================================================*/

#include "ishdr.h"
#include "DEMconst.h"
#include "DEMextrn.h"

#include "h_gm.h"
/*============================ EXTERNS ==================================*/
extern void InitFormColors( int ForceColor );

extern int          gDrawWhat;
extern int          gCurrSample;
extern int          gCurrChar;


/*============================ PROTOTYPES ===============================*/
int  doAttributeForm( void );


boolean KeyForMenu( KeyStatusType *K )
/* This returns TRUE if K is displayable.
  Note that it does not check K.DidPress */
{
  return( (K->ch==13) || ((K->ch>=32) && (K->ch<=126)) );
}   /* KeyForMenu */

/*----------------------------------------------------*/
int  doAttributeForm( void )
{

  FormType    Fn;
  int         FormStatus;
  boolean     done, save;
  short       k;
  char        tmpStr[10];
  MenuRecType FldMenu1;
  MenuRecType BM;
  int         ThisButton;
  int         tmpSample;
  boolean     IsDrawn;

  InitFormColors( 0 );
   strcpy(ULicon," "); strcpy(URicon," ");
   ShadowX=5; ShadowY=5;
   /* Note you can disable the shadow on the form with:
     Fn.AllowShadow = FALSE; */

  /* initialize field menu #1 (View) */
  NewItems( 3, &FldMenu1, &err);
  strcpy(FldMenu1.Title, "display");
  FldMenu1.ULx = 335;
  FldMenu1.ULy = 300;
  strcpy(*FldMenu1.ItemArray[1], "Alphabet");
  strcpy(*FldMenu1.ItemArray[2], "Letter");
  strcpy(*FldMenu1.ItemArray[3], "-All-");

  NewForm(4, &Fn, &err);

  /* Titles */
  initstr(Fn.Title,  "ATTRIBUTES");
  initstr(Fn.Title2, "Esc to Quit");
  initstr(Fn.Title3, "F3 to Save");

  /* ----------- Fn field #1 ----------- */
  /* -------------Sample No.------------- */
  initstr(*Fn.Flabel[1], "1 1 Sample No.");
  initstr(*Fn.PictStr[1], "99");
  Fn.FieldType[1]=Flong;
  *Fn.FieldX[1]=13;  *Fn.FieldY[2]=1;
  //Fn.ExitCommand[1]  = NeverExit;
  Fn.ExitCommand[1]  = AlwaysAfter;
  sprintf(tmpStr, "%2d", gCurrSample);
  initstr(*Fn.FieldInit[1], tmpStr);

  /* ----------- Fn field #2 ----------- */
  /* ---------------Letter--------------- */
  initstr(*Fn.Flabel[2], "3 5 Letter");
  initstr(*Fn.PictStr[2], "X");
  initstr(*Fn.FieldInit[2], " ");
  Fn.FieldType[2]=Fstring;
  *Fn.FieldX[2]=13;  *Fn.FieldY[2]=3;
  Fn.ExitCommand[2]  = NeverExit;
  tmpStr[0]=gCurrChar, tmpStr[1]='\0';
  initstr(*Fn.FieldInit[2], tmpStr);

  /* ----------- Fn field #3 ----------- */
  /* ----------------View---------------- */
  initstr(*Fn.Flabel[3], "5 7 View");
  initstr(*Fn.PictStr[3], "XXXXXXXXXX");
  Fn.FieldType[3]=Fstring;
  *Fn.FieldX[3]=13;  *Fn.FieldY[3]=5;
  Fn.ExitCommand[3]  = AlwaysBefore;
  if (gDrawWhat==INSTANCE_DRAW)
    initstr(*Fn.FieldInit[3], "Letter");
  else if (gDrawWhat==ALPHABET_DRAW)
    initstr(*Fn.FieldInit[3], "Alphabet");
  else
    initstr(*Fn.FieldInit[3], "-All-");

  *Fn.FieldX[4]=1;
  *Fn.FieldY[4]=8;
  Fn.FieldType[4]=Fblank;
  Fn.IsEnabled[4]=false;


  NewItems(2, &BM, &err);
  BM.rows=1; BM.cols=2;
  strcpy(*BM.ItemArray[1],"F3 Save");
  BM.kbdtrig1[1] = 0;  BM.kbdtrig2[1] =61;
  strcpy(*BM.ItemArray[2],"Esc");
  BM.kbdtrig1[2] = 1;  BM.kbdtrig2[2] =1;
	ClearButMenu( &BM );


  /* ------------ Now, process the Fn form. -------------- */
  DrawForm( &Fn, true, true ); /*,DoSave,DoInit*/
  /* Note: true, true - the first TRUE allows saving the underlying
          image, the second TRUE forces FieldValue to be FieldInit
          To conserve EMS or conventional memory, you may want to inhibit.
          the first TRUE.  If you do this, discard the PopForm below.*/

  BM.ULx=Fn.R.Xmin+23;
  BM.ULy=Fn.R.Ymax-(4*bevsize+4*GapY+FontHeight -GapY);
  btnbrdcolor = FormRectColor;

  DrawBtnMenu( &BM,
               0,
               false      /*DoSave*/,
               false      /*allowbrd*/,
               0          /*labelcols*/,
               0          /*labelrows*/ );

  done=false;
  save=false;
  do
   {

   GetForm( &Fn, &FormStatus );
   switch (FormStatus)
   {
     case -1: /* unknown key or unknown mouse */
          {
            save = (boolean)((KeyStatus.ch==0) && (KeyStatus.extkey==61)); // F3
            done = (boolean)(KeyStatus.ch2==EscKey) || save;
            if (! done)
             {
               if (Button == 0) KeyStatus.DidPress = true;
               DoBtn( BM.ULx, BM.ULy, &BM, 1, &ThisButton, &IsDrawn, false, false );
               if (ThisButton == 1) {save = done = true;}
               if (ThisButton == 2) {done = true;}
               if (ThisButton <=0) KeyStatus.DidPress = false;
             }

           break;
          } /* unknown key or unknown mouse */

     case  1: /*Sample No.*/
          {
            tmpSample = atoi((*Fn.FieldValue[1])+1);
            if (tmpSample > 20) tmpSample = 20;
            else
            if (tmpSample < 1)  tmpSample = 1;
            sprintf(tmpStr, "%2d", tmpSample);
            initstr(*Fn.FieldValue[1], tmpStr);
            SayVar( &Fn, 1 );
            break;
          } /*Sample No.*/

     case  2: /*Letter*/
          {
           break;
          } /*Letter*/

     case  3: /*View*/
          {
              qGotoTextXY( *Fn.FieldX[3],
                           *Fn.FieldY[3]  );
              FldMenu1.ULx = getx();
              FldMenu1.ULy = gety() + FontHeight + 3*GapY;
              DoPopMenu( &FldMenu1, &k ); /* do the popmenu */
              if (k>0)
               {
                initstr(*Fn.FieldValue[FormStatus], *FldMenu1.ItemArray[k]);
                SayVar( &Fn, 3 );
                Fn.LeaveCommand = GoDown;
               }
              KeyStatus.DidPress=false;

            /* end of PopMenu code */
           break;
          } /*View*/
   } /* switch FormStatus */
  } /* do */
  while (! done);

  if (save)
   {
     if ((*Fn.FieldValue[3])[1]=='A')
       gDrawWhat=ALPHABET_DRAW;
     else if ((*Fn.FieldValue[3])[1]=='L')
       gDrawWhat=INSTANCE_DRAW;
     else if ((*Fn.FieldValue[3])[1]=='-')
       gDrawWhat=ALL_DRAW;

     gCurrChar = (*Fn.FieldValue[2])[1];
     if (gCurrChar<32) gCurrChar=32;    //printable range
     else
     if (gCurrChar>126) gCurrChar=126;

     gCurrSample = atoi((*Fn.FieldValue[1])+1);
     if (gCurrSample > 20) gCurrSample = 20;
     else
     if (gCurrSample < 1)  gCurrSample = 1;
   }

  /* -------------------- clean up -------------------- */
  /* Restore the underlying graphics image. */
  PopForm( &Fn ); /*discard this PopForm if you did
                DrawForm(&Fn,FALSE,TRUE); above*/

  DisposeForm( &Fn ); /*release dynamic memory*/

  /* Remove any local menus. */
  DisposeMenu( &FldMenu1 );
  return( (int)save );
} /*doAttributeForm*/
/*----------------------------------------------------*/

