/*****************************************************************
| H_GRAFIC.C  ---
+****************************************************************/

#include "h_config.h"

#ifdef USE_BGI_GRAPHICS
#include <dos.h>
#include <math.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <graphics.h>

/****************************************************************/

#include "h_stddef.h"
#include "h_grafic.h"
#include "h_keys.h"

/****************************************************************/

void gr_PutPoint(lpVHPoint p)
{
    putpixel( p->h, p->v, getcolor());
}

/************************************************************************/
void gr_SetRect(lpRect r,
    INT16 left,INT16 top,INT16 right,INT16 bottom)
{
    r->left  = left;    r->top    = top;
    r->right = right;   r->bottom = bottom;
}
/************************************************************************/
void gr_InflateRect(lpRect r,INT16 delta)
{
    r->left   -= delta;    r->top    -= delta;
    r->right  += delta;    r->bottom += delta;
}
/************************************************************************/
void gr_ShiftRect(lpRect r,INT16 x_delta,INT16 y_delta)
{
    r->left   += x_delta;    r->top    += y_delta;
    r->right  += x_delta;    r->bottom += y_delta;
}
/************************************************************************/
void gr_ShiftPoint(lpVHPoint p,INT16 x_delta,INT16 y_delta)
{
    p->h  += x_delta;        p->v  += y_delta;
}
/************************************************************************/
void gr_DrawRect(lpRect r)
{
  struct linesettingstype lineinfo;

  getlinesettings(&lineinfo);
  setlinestyle( SOLID_LINE, 0, NORM_WIDTH );
  rectangle( r->left, r->top, r->right, r->bottom);
  // restore linestyle
  setlinestyle( lineinfo.linestyle, lineinfo.upattern, lineinfo.thickness );
}
/************************************************************************/
static int x_conversion = 3;
static int y_conversion = 3;

static unsigned x_scale = 0x100, y_scale=0x100;

void gr_SetScaling(unsigned x, unsigned y)
{
    x_scale = x;
    y_scale = y;
}

void gr_GetScaling(unsigned *x, unsigned *y)
{
    *x=x_scale;
    *y=y_scale;
}

void gr_SetTabToScrConversion(int x, int y)
{
    x_conversion = x;
    y_conversion = y;
}

#define X_TAB2SCR(x)   (((x) >> x_conversion) * (long)x_scale) >> 8
#define Y_TAB2SCR(y)   (((y) >> y_conversion) * (long)y_scale) >> 8

void gr_TabletToScreen(INT16 x,INT16 y,LPINT16 xx,LPINT16 yy)
{
    *xx = X_TAB2SCR(x);
    *yy = Y_TAB2SCR(y);
}
/****************************************************************/
void gr_CvtTabPtToScreen(lpVHPoint p)
{
    INT16 x,y;
    x = X_TAB2SCR(p->h);
    y = Y_TAB2SCR(p->v);
    p->h = x;
    p->v = y;
}
/****************************************************************/
void gr_ConvertRectTabletToScreen(lpRect r)
{
    INT16 x1,y1,x2,y2;
    x1 = X_TAB2SCR(r->left);     y1 = Y_TAB2SCR(r->top);
    x2 = X_TAB2SCR(r->right);    y2 = Y_TAB2SCR(r->bottom);
    gr_SetRect(r,x1,y1,x2,y2);
}
/****************************************************************/
void gr_MoveTo(INT16 h,INT16 v)
{
    moveto(h,v);
}
/****************************************************************/
void gr_LineTo(INT16 h,INT16 v)
{
    lineto(h,v);
}
#endif
