/****************************************************************
H_GRAFIC.H -- publicly visible interface to H_GRAFIC.C
****************************************************************/
#define CELL_HEIGHT        80;
#define CELL_WIDTH         80;
#define MAX_INST_PER_ROW   5;

//const int CELL_HEIGHT        80;
//const int CELL_WIDTH         80;
//const int MAX_INST_PER_ROW   5;

typedef struct { INT16 v,h; } VHPoint;
typedef VHPoint FAR * lpVHPoint;

typedef struct { INT16 left,top,right,bottom; } Rect;
typedef Rect FAR *lpRect;

extern bool graphics_enabled;  /* in h_main.c */

/****************************************************************/

extern void gr_Initialize(void);
extern void gr_Close(void);
extern void gr_Pause(void);
extern void gr_StatusWindowMsg( char *line1,char *line2);
extern int  gr_Printf( int xloc, int yloc, char *fmt, ... );
extern void gr_SetupWindows( char *title );
extern void gr_ClearViewport(void);
extern void gr_SetTabToScrConversion(int x, int y);
extern void gr_InitColors(void);

/****************************************************************/

extern void gr_TabletToScreen(INT16 x,INT16 y,LPINT16 xx,LPINT16 yy);

extern void gr_MoveTo(INT16 h,INT16 v);
extern void gr_LineTo(INT16 h,INT16 v);

extern void gr_ShiftRect(lpRect r,INT16 x_delta,INT16 y_delta);
extern void gr_InflateRect(lpRect r,INT16 delta);
extern void gr_DrawRect(lpRect r);

extern void gr_CvtTabPtToScreen(lpVHPoint p);
extern void gr_ConvertRectTabletToScreen(lpRect r);
extern void gr_PutPoint(lpVHPoint p);

extern void     gr_SetRect(lpRect r,
                    INT16 left,INT16 top,INT16 right,INT16 bottom);
/****************************************************************/
extern void gr_StringAt( int xloc, int yloc, char *msg);
extern void gr_SetColorBlack(void);
extern void gr_SetColorGray(void);
extern void gr_SetColorWhite(void);
extern void gr_SetColorBlue(void);
extern void gr_SetColorYellow(void);

/****************************************************************/
extern void gr_ShowClock(void);
extern void gr_Test(void);
