/****************************************************************
| H_MEM.C  -- memory allocation module
+****************************************************************/

#include "h_config.h"
#include "h_stddef.h"

#ifdef TURBO_C
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <alloc.h>
#define HEAP_CHECK heapcheck
#endif

#define THRESHOLD_OP  1000L

/****************************************************************/
static long num_operations = 0;
static long bytes_allocd = 0;

void mem_CheckHeap(void)
{
    if(HEAP_CHECK() != _HEAPOK)
	fprintf(stderr,"\n***HEAP CHECK FAILED!****");
}
/****************************************************************/
void *mem_Realloc(void *v,size_t num_bytes)
{
    num_operations++;
    return realloc(v,num_bytes);
}
/****************************************************************/
void mem_Free(void *v)
{
    num_operations++;
    free(v);  /*free it anyway*/
}
/****************************************************************/
void * mem_Alloc(size_t num_bytes)
{
    void *v = malloc(num_bytes);
    bytes_allocd += num_bytes;
    num_operations++;
    return v;
}
/****************************************************************/
void * mem_CAlloc(size_t num_items, size_t item_size)
{
    void *v = calloc(num_items, item_size);
    long num_bytes = (long)(num_items * item_size);
    bytes_allocd += num_bytes;
    num_operations++;
    return v;
}
/****************************************************************/
void mem_AllocFailed(size_t num_bytes)
{
    fprintf(stderr,"\n***Mem alloc #%ld failed on %ld bytes***",
		(long)num_operations,(long)num_bytes);
    getch();
    exit(0);
}

